/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.RotationHelper;

public class ExtractorProjectileEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "extractor_projectile";
    @ObjectHolder(value="tetra:extractor_projectile")
    public static EntityType<ExtractorProjectileEntity> type;
    public static final String damageKey = "dmg";
    private int damage;
    public static final String heatKey = "heat";
    private int heat;
    private boolean extinguishing = false;

    public ExtractorProjectileEntity(World world, LivingEntity shooter, ItemStack itemStack) {
        super(type, shooter, world);
        this.damage = itemStack.func_77952_i();
        this.func_213869_a(SoundEvents.field_232778_ji_);
        this.func_70239_b(0.5);
        this.func_70240_a(3);
        this.func_213872_b((byte)127);
    }

    public ExtractorProjectileEntity(EntityType<? extends ExtractorProjectileEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(0.5);
        this.func_70240_a(3);
        this.func_213872_b((byte)127);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ExtractorProjectileEntity(World worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
        this.func_70239_b(0.5);
        this.func_70240_a(3);
        this.func_213872_b((byte)127);
    }

    public ExtractorProjectileEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(0.5);
        this.func_70240_a(3);
        this.func_213872_b((byte)127);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_70227_a(RayTraceResult rayTraceResult) {
        if (!this.field_70170_p.field_72995_K && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && this.func_213322_ci().func_189985_c() > 0.95) {
            ServerPlayerEntity shooter = CastOptional.cast(this.func_234616_v_(), ServerPlayerEntity.class).orElse(null);
            BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
            if (shooter != null && this.breakBlock(this.field_70170_p, pos, shooter)) {
                this.breakAround(this.field_70170_p, pos, ((BlockRayTraceResult)rayTraceResult).func_216354_b(), shooter);
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.95f));
                this.hitAdditional();
                return;
            }
        }
        super.func_70227_a(rayTraceResult);
    }

    private void hitAdditional() {
        Vector3d target;
        Vector3d position = this.func_213303_ch();
        BlockRayTraceResult rayTraceResult = this.field_70170_p.func_217299_a(new RayTraceContext(position, target = position.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)rayTraceResult)) {
            this.func_70227_a((RayTraceResult)rayTraceResult);
        }
    }

    private void breakAround(World world, BlockPos pos, Direction face, ServerPlayerEntity shooter) {
        Vector3i axis1 = RotationHelper.shiftAxis(face.func_176730_m());
        Vector3i axis2 = RotationHelper.shiftAxis(axis1);
        ServerScheduler.schedule(2, () -> {
            this.breakBlock(world, pos.func_177971_a(axis1), shooter);
            this.breakBlock(world, pos.func_177973_b(axis1), shooter);
        });
        ServerScheduler.schedule(4, () -> {
            this.breakBlock(world, pos.func_177971_a(axis2), shooter);
            this.breakBlock(world, pos.func_177973_b(axis2), shooter);
        });
        ServerScheduler.schedule(6, () -> {
            this.breakBlock(world, pos.func_177971_a(axis1).func_177971_a(axis2), shooter);
            this.breakBlock(world, pos.func_177973_b(axis1).func_177973_b(axis2), shooter);
        });
        ServerScheduler.schedule(8, () -> {
            this.breakBlock(world, pos.func_177971_a(axis1).func_177973_b(axis2), shooter);
            this.breakBlock(world, pos.func_177973_b(axis1).func_177971_a(axis2), shooter);
        });
    }

    private boolean breakBlock(World world, BlockPos pos, ServerPlayerEntity shooter) {
        ServerWorld serverWorld = (ServerWorld)world;
        GameType gameType = shooter.field_71134_c.func_73081_b();
        BlockState blockState = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (blockState.func_185887_b((IBlockReader)world, pos) != -1.0f && this.func_70089_S() && !shooter.func_223729_a(world, pos, gameType) && FracturedBedrockTile.breakMaterials.contains(blockState.func_185904_a()) && blockState.func_177230_c().removedByPlayer(blockState, world, pos, (PlayerEntity)shooter, true, world.func_204610_c(pos)) && ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)shooter, (BlockPos)pos) != -1) {
            blockState.func_177230_c().func_180657_a(world, (PlayerEntity)shooter, pos, blockState, tileEntity, ItemStack.field_190927_a);
            blockState.func_177230_c().func_176206_d((IWorld)world, pos, blockState);
            world.func_217378_a(null, 2001, pos, Block.func_196246_j((BlockState)blockState));
            ++this.damage;
            this.heat += 10;
            int exp = blockState.getExpDrop((IWorldReader)world, pos, 0, 0);
            if (exp > 0) {
                blockState.func_177230_c().func_180637_b(serverWorld, pos, exp);
            }
            if (this.damage > 1024) {
                this.destroyExtractor();
            }
            return true;
        }
        return false;
    }

    private void destroyExtractor() {
        this.func_70106_y();
        this.field_70170_p.func_217385_a(this.func_234616_v_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f, Explosion.Mode.BREAK);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_233570_aj_() && this.heat > 0) {
                int cooldown;
                int n = cooldown = this.func_70090_H() ? 10 : 1;
                if (this.field_70173_aa % 10 == 0) {
                    Vector3d pos = this.func_213303_ch().func_178787_e(this.func_70040_Z().func_186678_a(-Math.random()));
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197594_E, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, cooldown, 0.0, 0.01, 0.0, 0.01);
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a, pos.field_72448_b + 0.1, pos.field_72449_c, 1, 0.0, 0.01, 0.0, 0.01);
                }
                if (cooldown > 1 && !this.extinguishing) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.2f, 0.9f);
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218418_af, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 12, 0.0, 0.01, 0.0, 0.01);
                    this.extinguishing = true;
                }
                this.heat -= cooldown;
            } else if (this.field_70173_aa % 40 == 0) {
                Vector3d pos = this.func_213303_ch().func_178787_e(this.func_70040_Z().func_186678_a(-Math.random()));
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197594_E, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1, 0.0, 0.01, 0.0, 0.01);
            }
        }
    }

    public boolean func_233570_aj_() {
        return this.field_184552_b > 0;
    }

    protected ItemStack func_184550_j() {
        if (this.damage == 0) {
            return new ItemStack((IItemProvider)ChthonicExtractorBlock.item);
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ChthonicExtractorBlock.usedItem);
        itemStack.func_196085_b(this.damage);
        return itemStack;
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        this.func_213869_a(SoundEvents.field_232778_ji_);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        this.func_213317_d(this.func_213322_ci().func_72432_b().func_186678_a(-0.1));
    }

    public void func_70100_b_(PlayerEntity player) {
        if (this.field_70254_i) {
            super.func_70100_b_(player);
            if (!this.func_70089_S()) {
                this.ignitePlayer(player);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.func_233570_aj_() && this.func_70089_S() && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
            ItemStack itemStack = this.func_184550_j();
            boolean success = false;
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, itemStack);
                success = true;
            } else if (player.func_184592_cb().func_190926_b()) {
                player.func_184611_a(Hand.OFF_HAND, itemStack);
                success = true;
            } else if (player.field_71071_by.func_70441_a(itemStack)) {
                success = true;
            }
            if (success) {
                player.func_71001_a((Entity)this, 1);
                this.ignitePlayer(player);
                this.func_70106_y();
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_184199_a(player, vec, hand);
    }

    private void ignitePlayer(PlayerEntity player) {
        if (!this.func_70089_S() && this.heat > 10) {
            player.func_70015_d(3 + this.heat / 20);
        }
    }

    public void func_225516_i_() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74762_e(damageKey);
        this.heat = compound.func_74762_e(heatKey);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(damageKey, this.damage);
        compound.func_74768_a(heatKey, this.heat);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.damage);
        buffer.writeInt(this.heat);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.damage = buffer.readInt();
        this.heat = buffer.readInt();
    }
}

