/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.worldgen;

import com.infamous.dungeons_mobs.entities.creepers.IcyCreeperEntity;
import com.infamous.dungeons_mobs.entities.undead.FrozenZombieEntity;
import com.infamous.dungeons_mobs.entities.undead.JungleZombieEntity;
import com.infamous.dungeons_mobs.entities.undead.MossySkeletonEntity;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;

public class EntitySpawnPlacements {
    public static EntitySpawnPlacementRegistry.PlacementType IN_WATER_ON_GROUND;

    public static void createPlacementTypes() {
        IN_WATER_ON_GROUND = EntitySpawnPlacementRegistry.PlacementType.create((String)"in_water_on_ground", (iWorldReader, blockPos, entityType) -> {
            boolean inWater;
            BlockState blockstate = iWorldReader.func_180495_p(blockPos);
            FluidState fluidstate = iWorldReader.func_204610_c(blockPos);
            BlockPos above = blockPos.func_177984_a();
            BlockPos below = blockPos.func_177977_b();
            BlockState stateAtPos = iWorldReader.func_180495_p(blockPos);
            boolean bl = inWater = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && iWorldReader.func_204610_c(below).func_206884_a((ITag)FluidTags.field_206959_a) && !iWorldReader.func_180495_p(above).func_215686_e((IBlockReader)iWorldReader, above);
            if (!stateAtPos.canCreatureSpawn(iWorldReader, below, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, entityType)) {
                return false;
            }
            boolean validEmptySpawn = EntitySpawnPlacements.isValidEmptySpawnBlockNoFluidCheck((IBlockReader)iWorldReader, blockPos, blockstate, entityType) && EntitySpawnPlacements.isValidEmptySpawnBlockNoFluidCheck((IBlockReader)iWorldReader, above, iWorldReader.func_180495_p(above), entityType);
            return validEmptySpawn && inWater;
        });
    }

    public static boolean isValidEmptySpawnBlockNoFluidCheck(IBlockReader blockReader, BlockPos blockPos, BlockState blockState, EntityType<?> entityType) {
        if (blockState.func_235785_r_(blockReader, blockPos)) {
            return false;
        }
        if (blockState.func_185897_m()) {
            return false;
        }
        if (blockState.func_235714_a_((ITag)BlockTags.field_232884_az_)) {
            return false;
        }
        return !entityType.func_233597_a_(blockState);
    }

    public static void initSpawnPlacements() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WRAITH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.FROZEN_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FrozenZombieEntity::canFrozenZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ICY_CREEPER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, IcyCreeperEntity::canIcyCreeperSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.JUNGLE_ZOMBIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, JungleZombieEntity::canJungleZombieSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.MOSSY_SKELETON.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, MossySkeletonEntity::canMossySkeletonSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.SKELETON_VANGUARD.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.NECROMANCER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ROYAL_GUARD.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.MOUNTAINEER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.GEOMANCER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ICEOLOGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ILLUSIONER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ILLUSIONER_CLONE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WINDCALLER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canIllagerSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::canRaiderSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.REDSTONE_CUBE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.CONJURED_SLIME.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WHISPERER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, EntitySpawnPlacements::canJungleMobSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.LEAPLEAF.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, EntitySpawnPlacements::canJungleMobSpawn);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.FUNGUS_THROWER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkPiglinSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ZOMBIFIED_FUNGUS_THROWER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkZombifiedPiglinSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WILDFIRE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WAVEWHISPERER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.DROWNED_NECROMANCER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.SUNKEN_SKELETON.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySpawnPlacements::checkAquaticMobSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.BLASTLING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.WATCHLING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.SNARELING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ModEntityTypes.ENDERSENT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
    }

    public static boolean checkAquaticMobSpawnRules(EntityType<? extends MobEntity> type, IServerWorld serverWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        boolean canSpawn;
        Optional biomeName = serverWorld.func_242406_i(blockPos);
        boolean bl = canSpawn = serverWorld.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)serverWorld, (BlockPos)blockPos, (Random)random) && (spawnReason == SpawnReason.SPAWNER || serverWorld.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a));
        if (!Objects.equals(biomeName, Optional.of(Biomes.field_76781_i)) && !Objects.equals(biomeName, Optional.of(Biomes.field_76777_m))) {
            return random.nextInt(40) == 0 && IAquaticMob.isDeepEnoughToSpawn((IWorld)serverWorld, blockPos) && canSpawn;
        }
        return random.nextInt(15) == 0 && canSpawn;
    }

    public static boolean checkDrownedSpawnRules(EntityType<DrownedEntity> type, IServerWorld serverWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        boolean canSpawn;
        Optional biomeName = serverWorld.func_242406_i(blockPos);
        boolean bl = canSpawn = serverWorld.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)serverWorld, (BlockPos)blockPos, (Random)random) && (spawnReason == SpawnReason.SPAWNER || serverWorld.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206959_a));
        if (!Objects.equals(biomeName, Optional.of(Biomes.field_76781_i)) && !Objects.equals(biomeName, Optional.of(Biomes.field_76777_m))) {
            return random.nextInt(40) == 0 && EntitySpawnPlacements.isDeepEnoughToSpawn((IWorld)serverWorld, blockPos) && canSpawn;
        }
        return random.nextInt(15) == 0 && canSpawn;
    }

    private static boolean isDeepEnoughToSpawn(IWorld world, BlockPos blockPos) {
        return blockPos.func_177956_o() < world.func_181545_F() - 5;
    }

    public static boolean checkZombifiedPiglinSpawnRules(EntityType<? extends ZombifiedPiglinEntity> p_234351_0_, IWorld p_234351_1_, SpawnReason p_234351_2_, BlockPos p_234351_3_, Random p_234351_4_) {
        return p_234351_1_.func_175659_aa() != Difficulty.PEACEFUL && p_234351_1_.func_180495_p(p_234351_3_.func_177977_b()).func_177230_c() != Blocks.field_189878_dg;
    }

    public static boolean checkPiglinSpawnRules(EntityType<? extends PiglinEntity> p_234418_0_, IWorld p_234418_1_, SpawnReason p_234418_2_, BlockPos p_234418_3_, Random p_234418_4_) {
        return !p_234418_1_.func_180495_p(p_234418_3_.func_177977_b()).func_203425_a(Blocks.field_189878_dg);
    }

    public static boolean canJungleMobSpawn(EntityType<? extends MonsterEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    public static boolean canIllagerSpawn(EntityType<? extends AbstractIllagerEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    public static boolean canRaiderSpawn(EntityType<? extends AbstractRaiderEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || EntitySpawnPlacements.canSeeSkyLight(world, blockPos));
    }

    private static boolean canSeeSkyLight(IServerWorld world, BlockPos blockPos) {
        return world.func_226658_a_(LightType.SKY, blockPos) > 4;
    }
}

