/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.worldgen;

import com.infamous.dungeons_mobs.compat.EnderlingsCompat;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class BiomeSpawnEntries {
    public static final BiomeDictionary.Type CRIMSON = BiomeDictionary.Type.getType((String)"CRIMSON", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    public static final BiomeDictionary.Type WARPED = BiomeDictionary.Type.getType((String)"WARPED", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    public static final BiomeDictionary.Type DELTA = BiomeDictionary.Type.getType((String)"DELTA", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    public static final BiomeDictionary.Type SOULSAND = BiomeDictionary.Type.getType((String)"SOULSAND", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    public static final BiomeDictionary.Type END_CENTER = BiomeDictionary.Type.getType((String)"END_CENTER", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);

    public static void addCustomTypesToBiomes() {
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_235253_az_, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{CRIMSON});
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_235250_aA_, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{WARPED});
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_235251_aB_, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{DELTA});
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_235252_ay_, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{SOULSAND});
        BiomeDictionary.addTypes((RegistryKey)Biomes.field_76779_k, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{END_CENTER});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        ResourceLocation biomeRegistryName = event.getName();
        if (biomeRegistryName != null) {
            RegistryKey biomeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeRegistryName);
            MobSpawnInfoBuilder mobSpawnInfoBuilder = event.getSpawns();
            BiomeSpawnEntries.addMonsterSpawnsToBiome((RegistryKey<Biome>)biomeRegistryKey, mobSpawnInfoBuilder);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onBiomeLoadingEventForVariants(BiomeLoadingEvent event) {
        Biome.Category biomeCategory = event.getCategory();
        MobSpawnInfoBuilder mobSpawnInfoBuilder = event.getSpawns();
        BiomeSpawnEntries.replaceMonsterSpawnsWithVariants(mobSpawnInfoBuilder, biomeCategory);
    }

    private static void addMonsterSpawnsToBiome(RegistryKey<Biome> biomeRegistryKey, MobSpawnInfoBuilder mobSpawnInfoBuilder) {
        List iceologerBiomeTypes = (List)DungeonsMobsConfig.COMMON.ICEOLOGER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, iceologerBiomeTypes, (EntityType)ModEntityTypes.ICEOLOGER.get(), (Integer)DungeonsMobsConfig.COMMON.ICEOLOGER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ICEOLOGER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ICEOLOGER_MAX_GROUP_SIZE.get());
        List wraithBiomeTypes = (List)DungeonsMobsConfig.COMMON.WRAITH_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, wraithBiomeTypes, (EntityType)ModEntityTypes.WRAITH.get(), (Integer)DungeonsMobsConfig.COMMON.WRAITH_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.WRAITH_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.WRAITH_MAX_GROUP_SIZE.get());
        List necromancerBiomeTypes = (List)DungeonsMobsConfig.COMMON.NECROMANCER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, necromancerBiomeTypes, (EntityType)ModEntityTypes.NECROMANCER.get(), (Integer)DungeonsMobsConfig.COMMON.NECROMANCER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.NECROMANCER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.NECROMANCER_MAX_GROUP_SIZE.get());
        List mountaineerBiomeTypes = (List)DungeonsMobsConfig.COMMON.MOUNTAINEER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, mountaineerBiomeTypes, (EntityType)ModEntityTypes.MOUNTAINEER.get(), (Integer)DungeonsMobsConfig.COMMON.MOUNTAINEER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.MOUNTAINEER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.MOUNTAINEER_MAX_GROUP_SIZE.get());
        List windcallerBiomeTypes = (List)DungeonsMobsConfig.COMMON.WINDCALLER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, windcallerBiomeTypes, (EntityType)ModEntityTypes.WINDCALLER.get(), (Integer)DungeonsMobsConfig.COMMON.WINDCALLER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.WINDCALLER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.WINDCALLER_MAX_GROUP_SIZE.get());
        List geomancerBiomeTypes = (List)DungeonsMobsConfig.COMMON.GEOMANCER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, geomancerBiomeTypes, (EntityType)ModEntityTypes.GEOMANCER.get(), (Integer)DungeonsMobsConfig.COMMON.GEOMANCER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.GEOMANCER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.GEOMANCER_MAX_GROUP_SIZE.get());
        List illusionerBiomeTypes = (List)DungeonsMobsConfig.COMMON.ILLUSIONER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, illusionerBiomeTypes, (EntityType)ModEntityTypes.ILLUSIONER.get(), (Integer)DungeonsMobsConfig.COMMON.ILLUSIONER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ILLUSIONER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ILLUSIONER_MAX_GROUP_SIZE.get());
        List vindicatorBiomeTypes = (List)DungeonsMobsConfig.COMMON.VINDICATOR_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, vindicatorBiomeTypes, EntityType.field_200758_ax, (Integer)DungeonsMobsConfig.COMMON.VINDICATOR_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.VINDICATOR_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.VINDICATOR_MAX_GROUP_SIZE.get());
        List evokerBiomeTypes = (List)DungeonsMobsConfig.COMMON.EVOKER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, evokerBiomeTypes, EntityType.field_200806_t, (Integer)DungeonsMobsConfig.COMMON.EVOKER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.EVOKER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.EVOKER_MAX_GROUP_SIZE.get());
        List pillagerBiomeTypes = (List)DungeonsMobsConfig.COMMON.PILLAGER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, pillagerBiomeTypes, EntityType.field_220350_aJ, (Integer)DungeonsMobsConfig.COMMON.PILLAGER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.PILLAGER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.PILLAGER_MAX_GROUP_SIZE.get());
        List whispererBiomeTypes = (List)DungeonsMobsConfig.COMMON.WHISPERER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, whispererBiomeTypes, (EntityType)ModEntityTypes.WHISPERER.get(), (Integer)DungeonsMobsConfig.COMMON.WHISPERER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.WHISPERER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.WHISPERER_MAX_GROUP_SIZE.get());
        List leapleafBiomeTypes = (List)DungeonsMobsConfig.COMMON.LEAPLEAF_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, leapleafBiomeTypes, (EntityType)ModEntityTypes.LEAPLEAF.get(), (Integer)DungeonsMobsConfig.COMMON.LEAPLEAF_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.LEAPLEAF_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.LEAPLEAF_MAX_GROUP_SIZE.get());
        List fungusThrowerBiomeTypes = (List)DungeonsMobsConfig.COMMON.FUNGUS_THROWER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, fungusThrowerBiomeTypes, (EntityType)ModEntityTypes.FUNGUS_THROWER.get(), (Integer)DungeonsMobsConfig.COMMON.FUNGUS_THROWER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.FUNGUS_THROWER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.FUNGUS_THROWER_MAX_GROUP_SIZE.get());
        List zombifiedFungusThrowerBiomeTypes = (List)DungeonsMobsConfig.COMMON.ZOMBIFIED_FUNGUS_THROWER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, zombifiedFungusThrowerBiomeTypes, (EntityType)ModEntityTypes.ZOMBIFIED_FUNGUS_THROWER.get(), (Integer)DungeonsMobsConfig.COMMON.ZOMBIFIED_FUNGUS_THROWER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ZOMBIFIED_FUNGUS_THROWER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ZOMBIFIED_FUNGUS_THROWER_MAX_GROUP_SIZE.get());
        List witherSkeletonBiomeTypes = (List)DungeonsMobsConfig.COMMON.WITHER_SKELETON_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, witherSkeletonBiomeTypes, EntityType.field_200722_aA, (Integer)DungeonsMobsConfig.COMMON.WITHER_SKELETON_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.WITHER_SKELETON_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.WITHER_SKELETON_MAX_GROUP_SIZE.get());
        List sunkenSkeletonBiomeTypes = (List)DungeonsMobsConfig.COMMON.SUNKEN_SKELETON_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, sunkenSkeletonBiomeTypes, (EntityType)ModEntityTypes.SUNKEN_SKELETON.get(), (Integer)DungeonsMobsConfig.COMMON.SUNKEN_SKELETON_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.SUNKEN_SKELETON_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.SUNKEN_SKELETON_MAX_GROUP_SIZE.get());
        List drownedNecromancerBiomeTypes = (List)DungeonsMobsConfig.COMMON.DROWNED_NECROMANCER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, drownedNecromancerBiomeTypes, (EntityType)ModEntityTypes.SUNKEN_SKELETON.get(), (Integer)DungeonsMobsConfig.COMMON.DROWNED_NECROMANCER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.DROWNED_NECROMANCER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.DROWNED_NECROMANCER_MAX_GROUP_SIZE.get());
        List wavewhispererBiomeTypes = (List)DungeonsMobsConfig.COMMON.WAVEWHISPERER_BIOME_TYPES.get();
        BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, wavewhispererBiomeTypes, (EntityType)ModEntityTypes.WAVEWHISPERER.get(), (Integer)DungeonsMobsConfig.COMMON.WAVEWHISPERER_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.WAVEWHISPERER_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.WAVEWHISPERER_MAX_GROUP_SIZE.get());
        if (!EnderlingsCompat.isLoaded()) {
            List enderlingBiomeTypes = (List)DungeonsMobsConfig.COMMON.ENDERLING_BIOME_TYPES.get();
            BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, enderlingBiomeTypes, (EntityType)ModEntityTypes.BLASTLING.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MAX_GROUP_SIZE.get());
            BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, enderlingBiomeTypes, (EntityType)ModEntityTypes.SNARELING.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MAX_GROUP_SIZE.get());
            BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, enderlingBiomeTypes, (EntityType)ModEntityTypes.WATCHLING.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERLING_MAX_GROUP_SIZE.get());
            List endersentBiomeTypes = (List)DungeonsMobsConfig.COMMON.ENDERSENT_BIOME_TYPES.get();
            BiomeSpawnEntries.tryAddMonsterSpawnToBiome(biomeRegistryKey, mobSpawnInfoBuilder, endersentBiomeTypes, (EntityType)ModEntityTypes.ENDERSENT.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERSENT_SPAWN_WEIGHT.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERSENT_MIN_GROUP_SIZE.get(), (Integer)DungeonsMobsConfig.COMMON.ENDERSENT_MAX_GROUP_SIZE.get());
        }
    }

    private static void replaceMonsterSpawnsWithVariants(MobSpawnInfoBuilder mobSpawnInfoBuilder, Biome.Category foundCategory) {
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_JUNGLE_ZOMBIE_REPLACES_ZOMBIE.get()).booleanValue()) {
            BiomeSpawnEntries.handleVariantReplacementWithCategoryCheck(mobSpawnInfoBuilder, foundCategory, Biome.Category.JUNGLE, EntityType.field_200725_aD, (EntityType)ModEntityTypes.JUNGLE_ZOMBIE.get(), 0.8);
        }
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_MOSSY_SKELETON_REPLACES_SKELETON.get()).booleanValue()) {
            BiomeSpawnEntries.handleVariantReplacementWithCategoryCheck(mobSpawnInfoBuilder, foundCategory, Biome.Category.JUNGLE, EntityType.field_200741_ag, (EntityType)ModEntityTypes.MOSSY_SKELETON.get(), 0.8);
        }
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_FROZEN_ZOMBIE_REPLACES_ZOMBIE.get()).booleanValue()) {
            BiomeSpawnEntries.handleVariantReplacementWithCategoryCheck(mobSpawnInfoBuilder, foundCategory, Biome.Category.ICY, EntityType.field_200725_aD, (EntityType)ModEntityTypes.FROZEN_ZOMBIE.get(), 0.8);
        }
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_ICY_CREEPER_REPLACES_CREEPER.get()).booleanValue()) {
            BiomeSpawnEntries.handleVariantReplacementWithCategoryCheck(mobSpawnInfoBuilder, foundCategory, Biome.Category.ICY, EntityType.field_200797_k, (EntityType)ModEntityTypes.ICY_CREEPER.get(), 0.8);
        }
    }

    private static void tryAddMonsterSpawnToBiome(RegistryKey<Biome> biomeRegistryKey, MobSpawnInfoBuilder mobSpawnInfoBuilder, List<String> configuredBiomeTypes, EntityType entityType, int spawnWeight, int minGroupSize, int maxGroupSize) {
        if (configuredBiomeTypes.isEmpty()) {
            return;
        }
        ArrayList<String> disallowedBiomeTypes = new ArrayList<String>();
        for (String configuredBiomeType : configuredBiomeTypes) {
            if (!configuredBiomeType.startsWith("!") || configuredBiomeType.length() <= 1) continue;
            disallowedBiomeTypes.add(configuredBiomeType.substring(1));
        }
        Set biomeTypes = BiomeDictionary.getTypes(biomeRegistryKey);
        boolean containsAllowedType = false;
        boolean containsDisallowedType = false;
        for (BiomeDictionary.Type biomeType : biomeTypes) {
            String biomeTypeName = biomeType.getName();
            if (disallowedBiomeTypes.contains(biomeTypeName)) {
                containsDisallowedType = true;
                break;
            }
            if (!configuredBiomeTypes.contains(biomeTypeName)) continue;
            containsAllowedType = true;
        }
        if (containsAllowedType && !containsDisallowedType) {
            MobSpawnInfo.Spawners monsterSpawnEntry = new MobSpawnInfo.Spawners(entityType, spawnWeight, minGroupSize, maxGroupSize);
            mobSpawnInfoBuilder.getSpawner(EntityClassification.MONSTER).add(monsterSpawnEntry);
        }
    }

    private static void handleVariantReplacementWithCategoryCheck(MobSpawnInfoBuilder mobSpawnInfoBuilder, Biome.Category foundCategory, Biome.Category requiredCategory, EntityType typeToReplace, EntityType typeReplaceBy, double retainAmount) {
        if (foundCategory == requiredCategory) {
            BiomeSpawnEntries.handleVariantReplacement(mobSpawnInfoBuilder, typeToReplace, typeReplaceBy, retainAmount);
        }
    }

    private static void handleVariantReplacement(MobSpawnInfoBuilder mobSpawnInfoBuilder, EntityType typeToReplace, EntityType typeReplaceBy, double retainAmount) {
        retainAmount = MathHelper.func_151237_a((double)retainAmount, (double)0.0, (double)1.0);
        double replaceAmount = MathHelper.func_151237_a((double)(1.0 - retainAmount), (double)0.0, (double)1.0);
        List monsterSpawnList = mobSpawnInfoBuilder.getSpawner(EntityClassification.MONSTER);
        for (int i = 0; i < monsterSpawnList.size(); ++i) {
            MobSpawnInfo.Spawners spawnListEntry = (MobSpawnInfo.Spawners)monsterSpawnList.get(i);
            int weight = spawnListEntry.field_76292_a;
            int minGroupCount = spawnListEntry.field_242589_d;
            int maxGroupCount = spawnListEntry.field_242590_e;
            EntityType entityType = spawnListEntry.field_242588_c;
            if (entityType != typeToReplace) continue;
            MobSpawnInfo.SpawnCosts spawnCosts = mobSpawnInfoBuilder.getCost(typeToReplace);
            if (spawnCosts != null) {
                double maxSpawnCost = spawnCosts.func_242582_a();
                double entitySpawnCost = spawnCosts.func_242585_b();
                mobSpawnInfoBuilder.func_242573_a(typeToReplace, maxSpawnCost * retainAmount, entitySpawnCost * retainAmount);
                mobSpawnInfoBuilder.func_242573_a(typeReplaceBy, maxSpawnCost * replaceAmount, entitySpawnCost * replaceAmount);
            }
            MobSpawnInfo.Spawners typeReplaceByEntry = new MobSpawnInfo.Spawners(typeReplaceBy, (int)((double)weight * replaceAmount), minGroupCount, maxGroupCount);
            MobSpawnInfo.Spawners typeToReplaceEntry = new MobSpawnInfo.Spawners(typeToReplace, (int)((double)weight * retainAmount), minGroupCount, maxGroupCount);
            monsterSpawnList.set(i, typeToReplaceEntry);
            monsterSpawnList.add(typeReplaceByEntry);
        }
    }
}

