/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ModProjectileHelper {
    private static final double RAYTRACE_DISTANCE = 16.0;

    public static Hand getHandWith(LivingEntity livingEntity, Predicate<Item> itemPredicate) {
        return itemPredicate.test(livingEntity.func_184614_ca().func_77973_b()) ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static ItemStack createRocket(int explosions, DyeColor ... dyeColor) {
        ItemStack rocket = new ItemStack((IItemProvider)Items.field_196152_dE);
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT starExplosionNBT = star.func_190925_c("Explosion");
        starExplosionNBT.func_74768_a("Type", FireworkRocketItem.Shape.BURST.func_196071_a());
        CompoundNBT rocketFireworksNBT = rocket.func_190925_c("Fireworks");
        ListNBT rocketExplosionsNBT = new ListNBT();
        CompoundNBT actualStarExplosionNBT = star.func_179543_a("Explosion");
        if (actualStarExplosionNBT != null) {
            int i;
            ArrayList colorList = Lists.newArrayList();
            for (i = 0; i < dyeColor.length; ++i) {
                int pinkFireworkColor = dyeColor[i].func_196060_f();
                colorList.add(pinkFireworkColor);
            }
            actualStarExplosionNBT.func_197646_b("Colors", (List)colorList);
            actualStarExplosionNBT.func_197646_b("FadeColors", (List)colorList);
            for (i = 0; i < explosions; ++i) {
                rocketExplosionsNBT.add((Object)actualStarExplosionNBT);
            }
        }
        if (!rocketExplosionsNBT.isEmpty()) {
            rocketFireworksNBT.func_218657_a("Explosions", (INBT)rocketExplosionsNBT);
        }
        return rocket;
    }

    public static RayTraceResult getLaserRayTrace(LivingEntity shooter) {
        AxisAlignedBB targetAreaBoundingBox;
        EntityRayTraceResult entityRTR;
        World world = shooter.field_70170_p;
        BlockRayTraceResult blockRTR = (BlockRayTraceResult)shooter.func_213324_a(16.0, 1.0f, false);
        Vector3d startVec = shooter.func_174824_e(1.0f);
        Vector3d lookVec = shooter.func_70676_i(1.0f);
        Vector3d endVec = startVec.func_72441_c(lookVec.field_72450_a * 16.0, lookVec.field_72448_b * 16.0, lookVec.field_72449_c * 16.0);
        if (blockRTR.func_216346_c() != RayTraceResult.Type.MISS) {
            endVec = blockRTR.func_216347_e();
        }
        if ((entityRTR = ProjectileHelper.func_221269_a((World)world, (Entity)shooter, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)(targetAreaBoundingBox = shooter.func_174813_aQ().func_216361_a(lookVec.func_186678_a(16.0)).func_186662_g(1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L())) != null) {
            return entityRTR;
        }
        return blockRTR;
    }
}

