/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class GeomancyHelper {
    private static final int[] CONFIG_1_NORTH_ROW = new int[]{2, 3, 4, 5, 6};
    private static final int[] CONFIG_1_EAST_ROW = new int[]{6, 7, 8, 9, 10};
    private static final int[] CONFIG_1_SOUTH_ROW = new int[]{10, 11, 12, 13, 14};
    private static final int[] CONFIG_1_WEST_ROW = new int[]{14, 15, 0, 1, 2};
    public static final int[][] CONFIG_1_ROWS = new int[][]{CONFIG_1_NORTH_ROW, CONFIG_1_EAST_ROW, CONFIG_1_SOUTH_ROW, CONFIG_1_WEST_ROW};
    private static final int[] CONFIG_2_NORTH_ROW = new int[]{2, 3, 4, 5, 6, 7, 8, 1, 2};
    private static final int[] CONFIG_2_EAST_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] CONFIG_2_SOUTH_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] CONFIG_2_WEST_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[][] CONFIG_2_ROWS = new int[][]{CONFIG_2_NORTH_ROW, CONFIG_2_EAST_ROW, CONFIG_2_SOUTH_ROW, CONFIG_2_WEST_ROW};
    public static final int[][][] CONFIGS = new int[][][]{CONFIG_1_ROWS, CONFIG_2_ROWS};
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    private static boolean isValueInArray(int[] arr, int toCheckValue) {
        for (int element : arr) {
            if (element != toCheckValue) continue;
            return true;
        }
        return false;
    }

    private static double getZShift(int i, double zshift) {
        if (i >= 10 && i <= 14) {
            zshift = -2.0;
        }
        if (i >= 2 && i <= 6) {
            zshift = 2.0;
        }
        if (i == 9 || i == 15) {
            zshift = -1.0;
        }
        if (i == 1 || i == 7) {
            zshift = 1.0;
        }
        return zshift;
    }

    private static double getXShift(int i, double xshift) {
        if (i == 0 || i == 1 || i == 2 || i == 14 || i == 15) {
            xshift = -2.0;
        }
        if (i >= 6 && i <= 10) {
            xshift = 2.0;
        }
        if (i == 3 || i == 13) {
            xshift = -1.0;
        }
        if (i == 5 || i == 11) {
            xshift = 1.0;
        }
        return xshift;
    }

    private static BlockPos createCenteredBlockPosOnTarget(Entity targetEntity) {
        return new BlockPos(Math.floor(targetEntity.func_226277_ct_()), Math.floor(targetEntity.func_226278_cu_()), Math.floor(targetEntity.func_226281_cx_()));
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity).func_177963_a(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.field_70170_p.func_180495_p(blockpos1 = targetPos.func_177977_b())).func_224755_d((IBlockReader)casterEntity.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!casterEntity.field_70170_p.func_175623_d(targetPos) && !(voxelshape = (blockstate1 = casterEntity.field_70170_p.func_180495_p(targetPos)).func_196952_d((IBlockReader)casterEntity.field_70170_p, targetPos)).func_197766_b()) {
                yShift = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.func_177977_b()).func_177956_o() >= MathHelper.func_76141_d((float)targetPos.func_177956_o()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), (double)targetPos.func_177956_o() + yShift, targetPos.func_177952_p());
            constructEntity.setLifeTicks(100 + casterEntity.func_70681_au().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        targetPos = targetPos.func_177963_a(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.field_70170_p.func_180495_p(blockpos1 = targetPos.func_177977_b())).func_224755_d((IBlockReader)casterEntity.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!casterEntity.field_70170_p.func_175623_d(targetPos) && !(voxelshape = (blockstate1 = casterEntity.field_70170_p.func_180495_p(targetPos)).func_196952_d((IBlockReader)casterEntity.field_70170_p, targetPos)).func_197766_b()) {
                yShift = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.func_177977_b()).func_177956_o() >= MathHelper.func_76141_d((float)targetPos.func_177956_o()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), (double)targetPos.func_177956_o() + yShift, targetPos.func_177952_p());
            constructEntity.setLifeTicks(100 + casterEntity.func_70681_au().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonOffensiveVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, int xShift, int zShift) {
        AbstractVineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (AbstractVineEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            vineEntity.func_70107_b(targetPos.func_177958_n() + xShift, targetPos.func_177956_o(), targetPos.func_177952_p() + zShift);
            PositionUtils.moveToCorrectHeight((Entity)vineEntity);
            vineEntity.setDefaultFeatures();
            vineEntity.setVanishes(true);
            vineEntity.setStayTime(300 + casterEntity.func_70681_au().nextInt(50));
            vineEntity.setAlwaysOut(true);
            vineEntity.setShouldRetract(false);
            double vineLength = targetEntity.func_226278_cu_() - vineEntity.func_226278_cu_();
            vineEntity.setLengthInBlocks((float)vineLength + 3.0f + (float)vineEntity.func_70681_au().nextInt(6));
            casterEntity.field_70170_p.func_217376_c((Entity)vineEntity);
            if (casterEntity instanceof MobEntity) {
                vineEntity.func_70624_b(((MobEntity)casterEntity).func_70638_az());
            }
        }
    }

    private static void summonAreaDenialVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, double xshift, double zshift, Direction pillarFacing) {
        AbstractVineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity).func_177963_a(xshift, 0.0, zshift);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (AbstractVineEntity)entityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            vineEntity.func_70107_b(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p());
            PositionUtils.moveToCorrectHeight((Entity)vineEntity);
            vineEntity.setDefaultFeatures();
            vineEntity.setVanishes(true);
            vineEntity.setStayTime(100 + casterEntity.func_70681_au().nextInt(20));
            vineEntity.setAlwaysOut(true);
            vineEntity.setShouldRetract(false);
            double vineLength = targetEntity.func_226278_cu_() - vineEntity.func_226278_cu_();
            vineEntity.setLengthInBlocks((float)vineLength + 3.0f + (float)vineEntity.func_70681_au().nextInt(6));
            casterEntity.field_70170_p.func_217376_c((Entity)vineEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity).func_177963_a(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.field_70170_p.func_180495_p(blockpos1 = targetPos.func_177977_b())).func_224755_d((IBlockReader)casterEntity.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!casterEntity.field_70170_p.func_175623_d(targetPos) && !(voxelshape = (blockstate1 = casterEntity.field_70170_p.func_180495_p(targetPos)).func_196952_d((IBlockReader)casterEntity.field_70170_p, targetPos)).func_197766_b()) {
                yShift = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.func_177977_b()).func_177956_o() >= MathHelper.func_76141_d((float)targetPos.func_177956_o()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), (double)targetPos.func_177956_o() + yShift, targetPos.func_177952_p());
            constructEntity.setLifeTicks(100 + casterEntity.func_70681_au().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            constructEntity.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_BOMB_SPAWN.get(), 2.0f, 1.0f);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        targetPos = targetPos.func_177963_a(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.field_70170_p.func_180495_p(blockpos1 = targetPos.func_177977_b())).func_224755_d((IBlockReader)casterEntity.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!casterEntity.field_70170_p.func_175623_d(targetPos) && !(voxelshape = (blockstate1 = casterEntity.field_70170_p.func_180495_p(targetPos)).func_196952_d((IBlockReader)casterEntity.field_70170_p, targetPos)).func_197766_b()) {
                yShift = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.func_177977_b()).func_177956_o() >= MathHelper.func_76141_d((float)targetPos.func_177956_o()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.func_200721_a(casterEntity.field_70170_p)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.func_70107_b(targetPos.func_177958_n(), (double)targetPos.func_177956_o() + yShift, targetPos.func_177952_p());
            constructEntity.setLifeTicks(100 + casterEntity.func_70681_au().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_BOMB_SPAWN.get(), 2.0f, 1.0f);
            casterEntity.field_70170_p.func_217376_c((Entity)constructEntity);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialVineTrap(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.func_240989_a_((Object[])DIRECTIONS, (Random)casterEntity.func_70681_au());
            GeomancyHelper.summonAreaDenialVine(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonWallTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        if (casterEntity.func_70681_au().nextBoolean()) {
            if (casterEntity.func_70681_au().nextBoolean()) {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, -3.0, (double)length, Direction.NORTH);
                }
            } else {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, 3.0, (double)length, Direction.NORTH);
                }
            }
        } else if (casterEntity.func_70681_au().nextBoolean()) {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, -3.0, Direction.NORTH);
            }
        } else {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, 3.0, Direction.NORTH);
            }
        }
    }

    public static void summonWallTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        if (casterEntity.func_70681_au().nextBoolean()) {
            if (casterEntity.func_70681_au().nextBoolean()) {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, -3.0, (double)length, Direction.NORTH);
                }
            } else {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, 3.0, (double)length, Direction.NORTH);
                }
            }
        } else if (casterEntity.func_70681_au().nextBoolean()) {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, -3.0, Direction.NORTH);
            }
        } else {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, 3.0, Direction.NORTH);
            }
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        for (int length = 0; length < 25; ++length) {
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)(-8 + casterEntity.func_70681_au().nextInt(16)), (double)(-8 + casterEntity.func_70681_au().nextInt(16)), Direction.NORTH);
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        for (int length = 0; length < 25; ++length) {
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)(-8 + casterEntity.func_70681_au().nextInt(16)), (double)(-8 + casterEntity.func_70681_au().nextInt(16)), Direction.NORTH);
        }
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, -2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, -2.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, 2.0, Direction.NORTH);
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, -2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, -2.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, 2.0, Direction.NORTH);
    }

    public static boolean canAllowBlockEntitySpawn(Entity entity, BlockPos blockPos) {
        return entity.field_70170_p.func_180495_p(blockPos).func_227032_a_(Fluids.field_204541_a);
    }
}

