/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.network.message;

import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimatedPropsMessage {
    private int entityId;
    private AnimatedProps cap;

    public AnimatedPropsMessage(int entityId, AnimatedProps cap) {
        this.entityId = entityId;
        this.cap = cap;
    }

    public static AnimatedPropsMessage decode(PacketBuffer buffer) {
        int entityId = buffer.readInt();
        AnimatedProps cap = new AnimatedProps();
        cap.setAttackAnimationTick(buffer.readInt());
        cap.setAttackAnimationLength(buffer.readInt());
        cap.setAttackAnimationActionPoint(buffer.readInt());
        return new AnimatedPropsMessage(entityId, cap);
    }

    public static boolean onPacketReceived(AnimatedPropsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(message.entityId);
                if (entity instanceof MobEntity) {
                    AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability((MobEntity)entity);
                    cap.setAttackAnimationTick(message.cap.getAttackAnimationTick());
                    cap.setAttackAnimationLength(message.cap.getAttackAnimationLength());
                    cap.setAttackAnimationActionPoint(message.cap.getAttackAnimationActionPoint());
                }
            });
        }
        return true;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.cap.getAttackAnimationTick());
        buffer.writeInt(this.cap.getAttackAnimationLength());
        buffer.writeInt(this.cap.getAttackAnimationActionPoint());
    }
}

