/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mod;

import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.items.BlueNethershroomItem;
import com.infamous.dungeons_mobs.items.ColoredTridentItem;
import com.infamous.dungeons_mobs.items.CustomArmorMaterial;
import com.infamous.dungeons_mobs.items.GeomancerStaffItem;
import com.infamous.dungeons_mobs.items.MountaineerAxeItem;
import com.infamous.dungeons_mobs.items.NecromancerStaffItem;
import com.infamous.dungeons_mobs.items.NecromancerTridentItem;
import com.infamous.dungeons_mobs.items.PiglinHelmetItem;
import com.infamous.dungeons_mobs.items.PillagerHelmetItem;
import com.infamous.dungeons_mobs.items.VindicatorHelmetItem;
import com.infamous.dungeons_mobs.items.WindcallerStaffItem;
import com.infamous.dungeons_mobs.items.WoodenLadleItem;
import com.infamous.dungeons_mobs.items.armor.DrownedNecromancerArmorGear;
import com.infamous.dungeons_mobs.items.armor.IceologerArmorGear;
import com.infamous.dungeons_mobs.items.armor.IllusionerArmorGear;
import com.infamous.dungeons_mobs.items.armor.MageArmorGear;
import com.infamous.dungeons_mobs.items.armor.NecromancerArmorGear;
import com.infamous.dungeons_mobs.items.armor.WindcallerArmorGear;
import com.infamous.dungeons_mobs.items.shield.RoyalGuardShieldItem;
import com.infamous.dungeons_mobs.items.shield.VanguardShieldItem;
import com.infamous.dungeons_mobs.utils.GeneralHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dungeons_mobs");
    public static final Map<ResourceLocation, RegistryObject<Item>> ARTIFACTS = new HashMap<ResourceLocation, RegistryObject<Item>>();
    public static final Item.Properties ARMOR_PROPERTIES = (Boolean)DungeonsMobsConfig.Common.ENABLE_ITEM_TAB.get() != false ? new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS) : new Item.Properties();
    public static final Map<ResourceLocation, RegistryObject<Item>> ARMORS = new HashMap<ResourceLocation, RegistryObject<Item>>();
    public static final RegistryObject<Item> ROYAL_GUARD_SHIELD = ITEMS.register("royal_guard_shield", () -> new RoyalGuardShieldItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS).func_200918_c(336)));
    public static final RegistryObject<Item> VANGUARD_SHIELD = ITEMS.register("vanguard_shield", () -> new VanguardShieldItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS).func_200918_c(336)));
    public static final RegistryObject<Item> GOLD_PILLAGER_HELMET = ITEMS.register("gold_pillager_helmet", () -> new PillagerHelmetItem((IArmorMaterial)ArmorMaterial.IRON, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), false));
    public static final RegistryObject<Item> DIAMOND_PILLAGER_HELMET = ITEMS.register("diamond_pillager_helmet", () -> new PillagerHelmetItem((IArmorMaterial)ArmorMaterial.DIAMOND, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), true));
    public static final RegistryObject<Item> GOLD_VINDICATOR_HELMET = ITEMS.register("gold_vindicator_helmet", () -> new VindicatorHelmetItem((IArmorMaterial)ArmorMaterial.IRON, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), false));
    public static final RegistryObject<Item> DIAMOND_VINDICATOR_HELMET = ITEMS.register("diamond_vindicator_helmet", () -> new VindicatorHelmetItem((IArmorMaterial)ArmorMaterial.IRON, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), true));
    public static final RegistryObject<Item> NETHERITE_PIGLIN_HELMET = ITEMS.register("netherite_piglin_helmet", () -> new PiglinHelmetItem(CustomArmorMaterial.PURE_NETHERITE, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> CRACKED_NETHERITE_PIGLIN_HELMET = ITEMS.register("cracked_netherite_piglin_helmet", () -> new PiglinHelmetItem(CustomArmorMaterial.PURE_NETHERITE, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GOLD_PIGLIN_HELMET = ITEMS.register("gold_piglin_helmet", () -> new PiglinHelmetItem((IArmorMaterial)ArmorMaterial.GOLD, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> CRACKED_GOLD_PIGLIN_HELMET = ITEMS.register("cracked_gold_piglin_helmet", () -> new PiglinHelmetItem((IArmorMaterial)ArmorMaterial.GOLD, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final ArmorSet CHEF_ARMOR = ModItems.registerArmorSet("chef_armor", "chef_helmet", "chef_chestplate", null, null);
    public static final ArmorSet DROWNED_NECROMANCER_ARMOR = ModItems.registerArmorSetDrownedNecromancer("drowned_necromancer_armor", "drowned_necromancer_helmet", "drowned_necromancer_chestplate", "drowned_necromancer_leggings", null);
    public static final ArmorSet GEOMANCER_ARMOR = ModItems.registerArmorSet("geomancer_armor", "geomancer_helmet", "geomancer_chestplate", null, null);
    public static final ArmorSet ICEOLOGER_ARMOR = ModItems.registerArmorSetIceologer("iceologer_armor", "iceologer_helmet", "iceologer_chestplate", "iceologer_leggings", "iceologer_boots");
    public static final ArmorSet ILLUSIONER_ARMOR = ModItems.registerArmorSetIllusioner("illusioner_armor", "illusioner_helmet", "illusioner_chestplate", "illusioner_leggings", "illusioner_boots");
    public static final ArmorSet NECROMANCER_ARMOR = ModItems.registerArmorSetNecromancerArmor("necromancer_armor", "necromancer_helmet", "necromancer_chestplate", "necromancer_leggings", null);
    public static final ArmorSet NETHERPLATE_ARMOR = ModItems.registerArmorSet("netherplate_armor", "netherplate_helmet", null, null, null);
    public static final ArmorSet ROYAL_GUARD_ARMOR = ModItems.registerArmorSet("royal_guard_armor", "royal_guard_helmet", "royal_guard_chestplate", "royal_guard_leggings", "royal_guard_boots");
    public static final ArmorSet VANGUARD_ARMOR = ModItems.registerArmorSet("vanguard_armor", "vanguard_helmet", "vanguard_chestplate", "vanguard_leggings", null);
    public static final ArmorSet WINDCALLER_ARMOR = ModItems.registerArmorSetWindcaller("windcaller_armor", "windcaller_helmet", "windcaller_chestplate", null, null);
    public static final ArmorSet FUNGUS_THROWER_ARMOR = ModItems.registerArmorSet("fungus_thrower_armor", "fungus_thrower_helmet", "fungus_thrower_chestplate", null, null);
    public static final ArmorSet MOUNTAINEER_ARMOR = ModItems.registerArmorSet("mountaineer_armor", "mountaineer_helmet", "mountaineer_chestplate", "mountaineer_leggings", "mountaineer_boots");
    public static final ArmorSet EXPEDITION_ARMOR = ModItems.registerArmorSet("expedition_armor", "expedition_helmet", "expedition_chestplate", "expedition_leggings", "expedition_boots");
    public static final ArmorSet ALPINE_ARMOR = ModItems.registerArmorSet("alpine_armor", "alpine_helmet", "alpine_chestplate", "alpine_leggings", "alpine_boots");
    public static final ArmorSet MAGE_ARMOR = ModItems.registerArmorSetMage("mage_armor", "mage_helmet", "mage_chestplate", "mage_leggings", "mage_boots");
    public static final RegistryObject<Item> WOODEN_LADLE = ITEMS.register("wooden_ladle", () -> new WoodenLadleItem((IItemTier)ItemTier.WOOD, 0.5f, -2.0f, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> MOUNTAINEER_AXE = ITEMS.register("mountaineer_axe", () -> new MountaineerAxeItem((IItemTier)ItemTier.IRON, 1, -2.8f, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GOLD_MOUNTAINEER_AXE = ITEMS.register("gold_mountaineer_axe", () -> new MountaineerAxeItem((IItemTier)ItemTier.IRON, 1, -2.8f, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> DIAMOND_MOUNTAINEER_AXE = ITEMS.register("diamond_mountaineer_axe", () -> new MountaineerAxeItem((IItemTier)ItemTier.DIAMOND, 1, -2.8f, new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> WINDCALLER_STAFF = ModItems.registerArtifact("windcaller_staff", () -> new WindcallerStaffItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> GEOMANCER_STAFF = ModItems.registerArtifact("geomancer_staff", () -> new GeomancerStaffItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> NECROMANCER_STAFF = ModItems.registerArtifact("necromancer_staff", () -> new NecromancerStaffItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> NECROMANCER_TRIDENT = ModItems.registerArtifact("necromancer_trident", () -> new NecromancerTridentItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS)));
    public static final RegistryObject<Item> BLUE_NETHERSHROOM = ITEMS.register("blue_nethershroom", () -> new BlueNethershroomItem(new Item.Properties().func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS).func_200917_a(16)));
    public static final RegistryObject<Item> YELLOW_TRIDENT = ITEMS.register("yellow_trident", () -> new ColoredTridentItem(new Item.Properties().func_200918_c(250).func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), DyeColor.YELLOW));
    public static final RegistryObject<Item> PURPLE_TRIDENT = ITEMS.register("purple_trident", () -> new ColoredTridentItem(new Item.Properties().func_200918_c(250).func_200916_a(DungeonsMobs.DUNGEONS_MOBS_ITEMS), DyeColor.PURPLE));

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId, boolean animated) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = animated ? new ResourceLocation("dungeons_mobs", "animations/armor/" + armorSetId + ".animation.json") : new ResourceLocation("dungeons_libraries", "animations/armor/armor_default.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new ArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new ArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new ArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new ArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId, ResourceLocation animationFileLocation) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new ArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new ArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new ArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new ArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSet(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        return ModItems.registerArmorSet(armorSetId, helmetId, chestId, legsId, bootsId, false);
    }

    private static ArmorSet registerArmorSetMage(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new MageArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new MageArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new MageArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new MageArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetWindcaller(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new WindcallerArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new WindcallerArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new WindcallerArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new WindcallerArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetIceologer(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new IceologerArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new IceologerArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new IceologerArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new IceologerArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetIllusioner(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new IllusionerArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new IllusionerArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new IllusionerArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(bootsId, () -> new IllusionerArmorGear(EquipmentSlotType.FEET, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)));
    }

    private static ArmorSet registerArmorSetDrownedNecromancer(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new DrownedNecromancerArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new DrownedNecromancerArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new DrownedNecromancerArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), null);
    }

    private static ArmorSet registerArmorSetNecromancerArmor(String armorSetId, String helmetId, String chestId, String legsId, String bootsId) {
        ResourceLocation armorSet = new ResourceLocation("dungeons_mobs", armorSetId);
        ResourceLocation modelLocation = new ResourceLocation("dungeons_mobs", "geo/armor/" + armorSetId + ".geo.json");
        ResourceLocation textureLocation = new ResourceLocation("dungeons_mobs", "textures/models/armor/" + armorSetId + ".png");
        ResourceLocation animationFileLocation = new ResourceLocation("dungeons_mobs", "animations/armor/cloaked_armor.animation.json");
        return new ArmorSet(armorSet, ModItems.registerArmor(helmetId, () -> new NecromancerArmorGear(EquipmentSlotType.HEAD, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(chestId, () -> new NecromancerArmorGear(EquipmentSlotType.CHEST, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), ModItems.registerArmor(legsId, () -> new NecromancerArmorGear(EquipmentSlotType.LEGS, ARMOR_PROPERTIES, armorSet, modelLocation, textureLocation, animationFileLocation)), null);
    }

    private static RegistryObject<Item> registerArmor(String armorId, Supplier<Item> itemSupplier) {
        if (armorId == null) {
            return null;
        }
        RegistryObject register = ITEMS.register(armorId, itemSupplier);
        ARMORS.put(GeneralHelper.modLoc(armorId), (RegistryObject<Item>)register);
        return register;
    }

    private static RegistryObject<Item> registerArtifact(String meleeWeaponId, Supplier<Item> itemSupplier) {
        RegistryObject register = ITEMS.register(meleeWeaponId, itemSupplier);
        ARTIFACTS.put(GeneralHelper.modLoc(meleeWeaponId), (RegistryObject<Item>)register);
        return register;
    }
}

