/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.IMobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GravityPulseMobEnchant
extends MobEnchant {
    public static final double PULL_IN_SPEED_FACTOR = 0.1;

    public GravityPulseMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.GRAVITY_PULSE.get(), level -> {
            IMobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int gravityPulseTimer = comboCap.getGravityPulseTimer();
            if (gravityPulseTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.field_197599_J);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)5.0f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> GravityPulseMobEnchant.pullVictimTowardsTarget(entity, nearbyEntity, ParticleTypes.field_197599_J, level));
                comboCap.setGravityPulseTimer(100);
            } else {
                comboCap.setGravityPulseTimer(gravityPulseTimer - 1);
            }
        });
    }

    public static void pullVictimTowardsTarget(LivingEntity target, LivingEntity nearbyEntity, BasicParticleType particleType, Integer level) {
        double motionX = target.func_226277_ct_() - nearbyEntity.func_226277_ct_();
        double motionY = target.func_226278_cu_() - nearbyEntity.func_226278_cu_();
        double motionZ = target.func_226281_cx_() - nearbyEntity.func_226281_cx_();
        Vector3d vector3d = new Vector3d(motionX, motionY, motionZ).func_186678_a(0.1 * (double)level.intValue());
        nearbyEntity.func_213317_d(vector3d);
        DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, particleType);
    }
}

