/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeflectMobEnchant
extends MobEnchant {
    public DeflectMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onDeflectImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            RayTraceResult rayTraceResult = event.getRayTraceResult();
            if (!DeflectMobEnchant.projectileHitLivingEntity(rayTraceResult)) {
                return;
            }
            if (!DeflectMobEnchant.shooterIsLiving(projectile)) {
                return;
            }
            LivingEntity victim = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (DeflectMobEnchant.victimIsOwner(projectile, victim)) {
                event.setCanceled(true);
                return;
            }
            NewMobEnchantUtils.executeIfPresentWithLevel(victim, (MobEnchant)ModMobEnchants.DEFLECT.get(), level -> {
                if (projectile.field_70170_p.field_72995_K) {
                    DeflectMobEnchant.deflectProjectile(projectile, victim);
                    projectile.func_212361_a((Entity)victim);
                    event.setCanceled(true);
                } else {
                    DeflectMobEnchant.deflectProjectile(projectile, victim);
                    projectile.func_212361_a((Entity)victim);
                    event.setCanceled(true);
                }
            });
        }
    }

    private static void deflectProjectile(ProjectileEntity projectile, LivingEntity victim) {
        if (projectile instanceof ShulkerBulletEntity) {
            ((ShulkerBulletEntity)projectile).field_184571_b = projectile.func_234616_v_();
        } else {
            Vector3d deltaMovement = projectile.func_213322_ci();
            double speed = MathHelper.func_76133_a((double)(deltaMovement.field_72450_a * deltaMovement.field_72450_a + deltaMovement.field_72448_b * deltaMovement.field_72448_b + deltaMovement.field_72449_c * deltaMovement.field_72449_c));
            speed = speed < 1.0E-4 ? 0.0 : speed;
            double d0 = projectile.func_234616_v_().func_226277_ct_() - victim.func_226277_ct_();
            double d1 = projectile.func_234616_v_().func_226283_e_(0.3333333333333333) - projectile.func_226278_cu_();
            double d2 = projectile.func_234616_v_().func_226281_cx_() - victim.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            projectile.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, (float)speed, (float)(14 - victim.field_70170_p.func_175659_aa().func_151525_a() * 4));
        }
    }

    private static boolean victimIsOwner(ProjectileEntity projectile, LivingEntity victim) {
        return victim.equals((Object)projectile.func_234616_v_());
    }

    public static boolean projectileHitLivingEntity(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
            return entityRayTraceResult.func_216348_a() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean shooterIsLiving(ProjectileEntity projectile) {
        return projectile.func_234616_v_() != null && projectile.func_234616_v_() instanceof LivingEntity;
    }
}

