/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.IMobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChillingMobEnchant
extends MobEnchant {
    public ChillingMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.CHILLING.get(), level -> {
            IMobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int freezeNearbyTimer = comboCap.getFreezeNearbyTimer();
            if (freezeNearbyTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.field_197593_D);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)1.5f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> {
                    ChillingMobEnchant.freezeEnemy(1, nearbyEntity, level);
                    DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.field_197593_D);
                });
                comboCap.setFreezeNearbyTimer(40);
            } else {
                comboCap.setFreezeNearbyTimer(freezeNearbyTimer - 1);
            }
        });
    }

    private static void freezeEnemy(int amplifier, LivingEntity nearbyEntity, int durationInSeconds) {
        EffectInstance slowness = new EffectInstance(Effects.field_76421_d, durationInSeconds * 20, amplifier);
        EffectInstance fatigue = new EffectInstance(Effects.field_76419_f, durationInSeconds * 20, Math.max(0, amplifier * 2 - 1));
        nearbyEntity.func_195064_c(slowness);
        nearbyEntity.func_195064_c(fatigue);
        DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.field_197593_D);
    }
}

