/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.IMobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BurningMobEnchant
extends MobEnchant {
    public BurningMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.BURNING.get(), level -> {
            IMobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int burnNearbyTimer = comboCap.getBurnNearbyTimer();
            if (burnNearbyTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.field_197631_x);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)1.5f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> {
                    nearbyEntity.func_70097_a(DamageSource.field_76370_b, 0.5f * (float)level.intValue());
                    DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, ParticleTypes.field_197631_x);
                });
                comboCap.setBurnNearbyTimer(20);
            } else {
                comboCap.setBurnNearbyTimer(burnNearbyTimer - 1);
            }
        });
    }
}

