/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.compat.DungeonsGearCompat;
import com.infamous.dungeons_mobs.mixin.ArrowAccessor;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherSkeletonEntity.class})
public abstract class WitherSkeletonEntityMixin
extends AbstractSkeletonEntity {
    protected WitherSkeletonEntityMixin(EntityType<? extends AbstractSkeletonEntity> p_i48555_1_, World p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
    }

    @Inject(at={@At(value="RETURN")}, method={"getArrow"})
    private void getWitherArrow(ItemStack ammoStack, float p_213624_2_, CallbackInfoReturnable<AbstractArrowEntity> cir) {
        AbstractArrowEntity arrow = (AbstractArrowEntity)cir.getReturnValue();
        arrow.func_70066_B();
        if (arrow instanceof ArrowEntity && ((ArrowAccessor)arrow).getEffects().isEmpty()) {
            int difficultyFactor = 0;
            if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                difficultyFactor = 5;
            } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                difficultyFactor = 10;
            }
            if (difficultyFactor > 0) {
                ((ArrowEntity)arrow).func_184558_a(new EffectInstance(Effects.field_82731_v, difficultyFactor * 20));
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"populateDefaultEquipmentSlots"})
    private void setEquipmentOnInitialSpawn(DifficultyInstance difficultyInstance, CallbackInfo ci) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, this.createSpawnWeapon());
    }

    private ItemStack createSpawnWeapon() {
        ItemStack bowStack = new ItemStack((IItemProvider)Items.field_151031_f);
        ItemStack swordStack = new ItemStack((IItemProvider)Items.field_151052_q);
        if (DungeonsGearCompat.isLoaded()) {
            bowStack = new ItemStack((IItemProvider)DungeonsGearCompat.getRedSnake().get());
            swordStack = new ItemStack((IItemProvider)DungeonsGearCompat.getStoneSword().get());
        }
        return (double)this.field_70146_Z.nextFloat() < 0.5 ? bowStack : swordStack;
    }
}

