/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.goals.RangedWebAttackGoal;
import com.infamous.dungeons_mobs.interfaces.ITrapsTarget;
import com.infamous.dungeons_mobs.interfaces.IWebShooter;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.List;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpiderEntity.class})
public abstract class SpiderEntityMixin
extends MonsterEntity
implements IWebShooter {
    private static final DataParameter<Boolean> WEBSHOOTING = EntityDataManager.func_187226_a(SpiderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private RangedWebAttackGoal<?> rangedWebAttackGoal;
    private LeapAtTargetGoal leapAtTargetGoal;
    private MeleeAttackGoal meleeAttackGoal;
    public int targetTrappedCounter = 0;

    protected SpiderEntityMixin(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"registerGoals"})
    private void registerGoals(CallbackInfo callbackInfo) {
        ((GoalSelectorAccessor)this.field_70714_bg).getAvailableGoals().stream().filter(pg -> pg.func_220770_h() == 4 && pg.func_220772_j() instanceof MeleeAttackGoal).findFirst().ifPresent(pg -> {
            this.meleeAttackGoal = (MeleeAttackGoal)pg.func_220772_j();
        });
        ((GoalSelectorAccessor)this.field_70714_bg).getAvailableGoals().stream().filter(pg -> pg.func_220770_h() == 3 && pg.func_220772_j() instanceof LeapAtTargetGoal).findFirst().ifPresent(pg -> {
            this.leapAtTargetGoal = (LeapAtTargetGoal)pg.func_220772_j();
        });
        this.rangedWebAttackGoal = new RangedWebAttackGoal<SpiderEntityMixin>(this, 1.0, 60, 20.0f);
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData"})
    private void registerData(CallbackInfo callbackInfo) {
        this.field_70180_af.func_187214_a(WEBSHOOTING, (Object)false);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_RANGED_SPIDERS.get()).booleanValue() && this.func_200600_R() != EntityType.field_200794_h) {
            this.reassessAttackGoals();
        }
    }

    private void reassessAttackGoals() {
        LivingEntity target = this.func_70638_az();
        if (this.meleeAttackGoal != null && this.rangedWebAttackGoal != null && target != null) {
            if (!this.isTargetTrapped()) {
                this.field_70714_bg.func_85156_a((Goal)this.meleeAttackGoal);
                if (this.leapAtTargetGoal != null) {
                    this.field_70714_bg.func_85156_a((Goal)this.leapAtTargetGoal);
                }
                this.field_70714_bg.func_75776_a(4, (Goal)this.rangedWebAttackGoal);
            } else {
                this.field_70714_bg.func_85156_a((Goal)this.rangedWebAttackGoal);
                if (this.leapAtTargetGoal != null) {
                    this.field_70714_bg.func_75776_a(3, (Goal)this.leapAtTargetGoal);
                }
                this.field_70714_bg.func_75776_a(4, (Goal)this.meleeAttackGoal);
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.targetTrappedCounter > 0) {
            --this.targetTrappedCounter;
        }
    }

    @Override
    public void setTargetTrapped(boolean trapped, boolean notifyOthers) {
        EntityPredicate spiderTargeting = new EntityPredicate().func_221013_a(10.0).func_221010_e().func_221008_a().func_221011_b();
        if (notifyOthers) {
            List spiders = this.field_70170_p.func_217374_a(SpiderEntity.class, spiderTargeting, (LivingEntity)this, this.func_174813_aQ().func_186662_g(10.0));
            for (SpiderEntity spider : spiders) {
                if (!(spider instanceof ITrapsTarget) || this.func_70638_az() == null || spider.func_70638_az() == null || spider.func_70638_az() != this.func_70638_az()) continue;
                ((ITrapsTarget)spider).setTargetTrapped(trapped, false);
            }
        }
        this.targetTrappedCounter = trapped ? 20 : 0;
    }

    @Override
    public boolean isTargetTrapped() {
        return this.targetTrappedCounter > 0;
    }

    @Override
    public void setWebShooting(boolean webShooting) {
        this.func_184185_a((SoundEvent)ModSoundEvents.SPIDER_PREPARE_SHOOT.get(), this.func_70599_aP(), this.func_70647_i());
        this.field_70180_af.func_187227_b(WEBSHOOTING, (Object)webShooting);
    }

    @Override
    public boolean isWebShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(WEBSHOOTING);
    }
}

