/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.interfaces.BiomeSpecificRaider;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Raid.class})
public class RaidMixin {
    private static final String RAID_WAVE_MEMBER_TYPE_FIELD = "field_221285_g";
    @Shadow
    @Final
    private ServerWorld field_221348_l;

    @ModifyVariable(at=@At(value="STORE", ordinal=0), method={"spawnGroup"})
    private AbstractRaiderEntity spawnNextWave(AbstractRaiderEntity abstractRaiderEntity, BlockPos blockPos) {
        if (!((Boolean)DungeonsMobsConfig.COMMON.ENABLE_BIOME_SPECIFIC_RAIDERS.get()).booleanValue()) {
            return abstractRaiderEntity;
        }
        Biome raidBiome = this.field_221348_l.func_226691_t_(blockPos);
        ResourceLocation biomeRegistryName = raidBiome.getRegistryName();
        if (biomeRegistryName != null) {
            RegistryKey biomeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeRegistryName);
            Set raidBiomeTypes = BiomeDictionary.getTypes((RegistryKey)biomeRegistryKey);
            for (BiomeSpecificRaider currentBiomeSpecificRaider : BiomeSpecificRaider.values()) {
                EntityType originalRaiderType = abstractRaiderEntity != null ? abstractRaiderEntity.func_200600_R() : null;
                EntityType<? extends AbstractRaiderEntity> currentBiomeSpecificRaiderType = currentBiomeSpecificRaider.getType();
                EntityType<? extends AbstractRaiderEntity> equivalentType = currentBiomeSpecificRaider.getEquivalentType();
                Set<BiomeDictionary.Type> biomeTypeSet = currentBiomeSpecificRaider.getBiomeTypeSet();
                boolean biomeTypeMatch = false;
                block1: for (BiomeDictionary.Type allowedBiomeType : biomeTypeSet) {
                    for (BiomeDictionary.Type raidBiomeType : raidBiomeTypes) {
                        if (raidBiomeType != allowedBiomeType) continue;
                        biomeTypeMatch = true;
                        continue block1;
                    }
                }
                if (!biomeTypeMatch && currentBiomeSpecificRaiderType == originalRaiderType) {
                    abstractRaiderEntity = (AbstractRaiderEntity)equivalentType.func_200721_a((World)this.field_221348_l);
                    return abstractRaiderEntity;
                }
                boolean raiderFoundInWaveMembers = false;
                for (Raid.WaveMember waveMember : Raid.WaveMember.values()) {
                    EntityType waveMemberType = (EntityType)ObfuscationReflectionHelper.getPrivateValue(Raid.WaveMember.class, (Object)waveMember, (String)RAID_WAVE_MEMBER_TYPE_FIELD);
                    if (waveMemberType == null || waveMemberType != currentBiomeSpecificRaiderType) continue;
                    raiderFoundInWaveMembers = true;
                    break;
                }
                if (!biomeTypeMatch || originalRaiderType == null || currentBiomeSpecificRaiderType == null || originalRaiderType != equivalentType || raiderFoundInWaveMembers) continue;
                abstractRaiderEntity = (AbstractRaiderEntity)currentBiomeSpecificRaiderType.func_200721_a((World)this.field_221348_l);
                return abstractRaiderEntity;
            }
        }
        return abstractRaiderEntity;
    }
}

