/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.items.interfaces.ISoulConsumer;
import com.infamous.dungeons_libraries.network.BreakItemMessage;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_libraries.utils.SoundHelper;
import com.infamous.dungeons_mobs.interfaces.IHasInventorySprite;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class NecromancerStaffItem
extends ArtifactItem
implements IHasInventorySprite,
ISoulConsumer {
    public NecromancerStaffItem(Item.Properties properties) {
        super(properties);
        this.procOnItemUse = true;
    }

    public ActionResult<ItemStack> procArtifact(ArtifactUseContext itemUseContext) {
        IMaster summonerCap;
        World world = itemUseContext.getLevel();
        if (world.field_72995_K || itemUseContext.isHitMiss()) {
            return ActionResult.func_226248_a_((Object)itemUseContext.getItemStack());
        }
        ItemStack itemUseContextItem = itemUseContext.getItemStack();
        PlayerEntity itemUseContextPlayer = itemUseContext.getPlayer();
        BlockPos itemUseContextPos = itemUseContext.getClickedPos();
        Direction itemUseContextFace = itemUseContext.getClickedFace();
        BlockState blockState = world.func_180495_p(itemUseContextPos);
        BlockPos blockPos = blockState.func_196952_d((IBlockReader)world, itemUseContextPos).func_197766_b() ? itemUseContextPos : itemUseContextPos.func_177972_a(itemUseContextFace);
        if (itemUseContextPlayer != null && (summonerCap = MinionMasterHelper.getMasterCapability((Entity)itemUseContextPlayer)) != null) {
            Entity summoned = SummonHelper.summonEntity((LivingEntity)itemUseContextPlayer, (BlockPos)itemUseContextPlayer.func_233580_cy_(), (EntityType)EntityType.field_200725_aD);
            if (summoned != null) {
                SoundHelper.playCreatureSound((Entity)itemUseContextPlayer, (SoundEvent)((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get()));
                itemUseContextItem.func_222118_a(1, (LivingEntity)itemUseContextPlayer, entity -> NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new BreakItemMessage(entity.func_145782_y(), itemUseContextItem)));
                ArtifactItem.putArtifactOnCooldown((PlayerEntity)itemUseContextPlayer, (Item)itemUseContextItem.func_77973_b());
            } else if (world instanceof ServerWorld) {
                List<Entity> zombieEntities = summonerCap.getSummonedMobs().stream().filter(entity -> entity.func_200600_R() == EntityType.field_200725_aD).collect(Collectors.toList());
                zombieEntities.forEach(entity -> entity.func_223102_j((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.05, (double)blockPos.func_177952_p() + 0.5));
            }
        }
        return ActionResult.func_226249_b_((Object)itemUseContextItem);
    }

    public int getCooldownInSeconds() {
        return 20;
    }

    public int getDurationInSeconds() {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(int slotIndex) {
        return this.getAttributeModifiersForSlot(this.getUUIDForSlot(slotIndex));
    }

    private ImmutableMultimap<Attribute, AttributeModifier> getAttributeModifiersForSlot(UUID slot_uuid) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)AttributeRegistry.SUMMON_CAP.get(), (Object)new AttributeModifier(slot_uuid, "Artifact modifier", 3.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public float getActivationCost(ItemStack stack) {
        return 50.0f;
    }
}

