/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.interfaces;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraftforge.common.BiomeDictionary;

public enum BiomeSpecificRaider {
    MOUNTAINEER((EntityType<? extends AbstractRaiderEntity>)((EntityType)ModEntityTypes.MOUNTAINEER.get()), (EntityType<? extends AbstractRaiderEntity>)EntityType.field_200758_ax, (List)DungeonsMobsConfig.COMMON.MOUNTAINEER_BIOME_TYPES.get()),
    ICEOLOGER((EntityType<? extends AbstractRaiderEntity>)((EntityType)ModEntityTypes.ICEOLOGER.get()), (EntityType<? extends AbstractRaiderEntity>)EntityType.field_200806_t, (List)DungeonsMobsConfig.COMMON.ICEOLOGER_BIOME_TYPES.get()),
    WINDCALLER((EntityType<? extends AbstractRaiderEntity>)((EntityType)ModEntityTypes.WINDCALLER.get()), (EntityType<? extends AbstractRaiderEntity>)EntityType.field_200806_t, (List)DungeonsMobsConfig.COMMON.WINDCALLER_BIOME_TYPES.get()),
    SQUALL_GOLEM((EntityType<? extends AbstractRaiderEntity>)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()), (EntityType<? extends AbstractRaiderEntity>)EntityType.field_220352_aU, (List)DungeonsMobsConfig.COMMON.SQUALL_GOLEM_BIOME_TYPES.get());

    private final EntityType<? extends AbstractRaiderEntity> entityType;
    private final EntityType<? extends AbstractRaiderEntity> equivalentType;
    private final Set<BiomeDictionary.Type> biomeTypes = new HashSet<BiomeDictionary.Type>();

    private BiomeSpecificRaider(EntityType<? extends AbstractRaiderEntity> entityTypeIn, EntityType<? extends AbstractRaiderEntity> equivalentTypeIn, List<? extends String> biomeTypesList) {
        this.entityType = entityTypeIn;
        this.equivalentType = equivalentTypeIn;
        List filteredBiomesList = biomeTypesList.stream().filter(type -> !type.startsWith("!")).collect(Collectors.toList());
        for (BiomeDictionary.Type type2 : BiomeDictionary.Type.getAll()) {
            if (!filteredBiomesList.contains(type2.getName())) continue;
            this.biomeTypes.add(type2);
        }
    }

    public EntityType<? extends AbstractRaiderEntity> getType() {
        return this.entityType;
    }

    public EntityType<? extends AbstractRaiderEntity> getEquivalentType() {
        return this.equivalentType;
    }

    public Set<BiomeDictionary.Type> getBiomeTypeSet() {
        return this.biomeTypes;
    }
}

