/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.network.NetworkHandler;
import com.infamous.dungeons_mobs.network.message.AnimatedPropsMessage;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ReplacedModdedAttackGoal<T extends MobEntity>
extends Goal {
    public T mob;
    @Nullable
    public LivingEntity target;
    private SoundEvent soundEvent;
    private int cooldown;
    private long lastUseTime;

    public ReplacedModdedAttackGoal(T mob, SoundEvent soundEvent, int cooldown) {
        this.soundEvent = soundEvent;
        this.cooldown = cooldown;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        this.mob = mob;
        this.target = mob.func_70638_az();
    }

    public boolean func_220685_C_() {
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean func_75250_a() {
        long i = ((MobEntity)this.mob).field_70170_p.func_82737_E();
        if (i - this.lastUseTime < (long)this.cooldown) {
            return false;
        }
        this.target = this.mob.func_70638_az();
        return this.target != null && !this.mob.func_184585_cz() && (double)this.mob.func_70032_d((Entity)this.target) <= this.getAttackReachSqr(this.target) && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target);
    }

    public boolean func_75253_b() {
        return this.target != null && !this.animationsUseable();
    }

    public void func_75249_e() {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        cap.setAttackAnimationTick(cap.getAttackAnimationLength());
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.mob), (Object)new AnimatedPropsMessage(this.mob.func_145782_y(), cap));
        this.lastUseTime = ((MobEntity)this.mob).field_70170_p.func_82737_E();
        ((MobEntity)this.mob).field_70170_p.func_72960_a(this.mob, (byte)4);
    }

    public void func_75246_d() {
        this.target = this.mob.func_70638_az();
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        if (cap.getAttackAnimationTick() == cap.getAttackAnimationActionPoint() && this.soundEvent != null) {
            this.mob.func_184185_a(this.soundEvent, 1.0f, 1.0f);
        }
        if (this.target != null && this.mob.func_70032_d((Entity)this.target) < 4.0f && cap.getAttackAnimationTick() == cap.getAttackAnimationActionPoint()) {
            this.mob.func_70652_k((Entity)this.target);
        }
    }

    public void func_75251_c() {
        if (this.target != null && !this.isShieldDisabled((MobEntity)this.mob) && this.shouldBlockForTarget(this.target) && this.mob.func_184592_cb().func_77973_b().isShield(this.mob.func_184592_cb(), this.mob) && this.mob.func_70681_au().nextInt(4) == 0) {
            this.mob.func_184598_c(Hand.OFF_HAND);
        }
    }

    public boolean isShieldDisabled(MobEntity shieldUser) {
        return shieldUser instanceof IShieldUser && ((IShieldUser)shieldUser).isShieldDisabled();
    }

    public boolean shouldBlockForTarget(LivingEntity target) {
        return !(target instanceof MobEntity) || ((MobEntity)target).func_70638_az() == this.mob;
    }

    public boolean animationsUseable() {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(this.mob);
        return cap.getAttackAnimationTick() <= 0;
    }

    public double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.func_213311_cf() * 2.0f * this.mob.func_213311_cf() * 2.0f + p_179512_1_.func_213311_cf();
    }
}

