/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.projectiles.DrownedNecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.projectiles.NecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.entities.summonables.TridentStormEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DrownedNecromancerEntity
extends DrownedEntity
implements IAnimatable,
SpawnArmoredMob {
    public int landShootAnimationTick;
    public int landShootAnimationLength = 20;
    public int landShootAnimationActionPoint = 7;
    public int landSummonAnimationTick;
    public int landSummonAnimationLength = 45;
    public int landSummonAnimationActionPoint1 = this.landSummonAnimationLength - 20;
    public int landSummonAnimationActionPoint2 = this.landSummonAnimationLength - 23;
    public int landSummonAnimationActionPoint3 = this.landSummonAnimationLength - 26;
    public int landSummonAnimationActionPoint4 = this.landSummonAnimationLength - 32;
    public int landSummonAnimationActionPoint5 = this.landSummonAnimationLength - 38;
    public int rainTridentStormAnimationTick;
    public int rainTridentStormAnimationLength = 45;
    public int rainShootAnimationTick;
    public int rainShootAnimationLength = 40;
    public int rainShootAnimationActionPoint = 23;
    public int summonAnimationTick;
    public int summonAnimationLength = 45;
    public int summonAnimationActionPoint = 23;
    public int shootAnimationTick;
    public int shootAnimationLength = 40;
    public int shootAnimationActionPoint = 23;
    public int tridentStormAnimationTick;
    public int tridentStormAnimationLength = 45;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public DrownedNecromancerEntity(EntityType<? extends DrownedNecromancerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return DrownedEntity.func_234342_eQ_().func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.5).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 75.0).func_233815_a_(Attributes.field_233826_i_, 12.5).func_233815_a_(Attributes.field_233820_c_, 0.6).func_233815_a_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 4.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new LandSummonGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SummonGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TridentStormGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RainTridentStormGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RainShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LandShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ApproachTargetGoal((CreatureEntity)this, 7.5, 1.1, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new GoToBeachGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    public boolean isSpellcasting() {
        return this.shootAnimationTick > 0 || this.rainShootAnimationTick > 0 || this.landShootAnimationTick > 0 || this.tridentStormAnimationTick > 0 || this.rainTridentStormAnimationTick > 0 || this.summonAnimationTick > 0 || this.landSummonAnimationTick > 0;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223223_b_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.4f;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.landShootAnimationTick > 0) {
            --this.landShootAnimationTick;
        }
        if (this.landSummonAnimationTick > 0) {
            --this.landSummonAnimationTick;
        }
        if (this.rainTridentStormAnimationTick > 0) {
            --this.rainTridentStormAnimationTick;
        }
        if (this.rainShootAnimationTick > 0) {
            --this.rainShootAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.tridentStormAnimationTick > 0) {
            --this.tridentStormAnimationTick;
        }
    }

    public boolean func_184638_cS() {
        return false;
    }

    public boolean func_70631_g_() {
        return false;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 11) {
            this.landShootAnimationTick = this.landShootAnimationLength;
        } else if (p_28844_ == 9) {
            this.landSummonAnimationTick = this.landSummonAnimationLength;
        } else if (p_28844_ == 4) {
            this.rainTridentStormAnimationTick = this.rainTridentStormAnimationLength;
        } else if (p_28844_ == 8) {
            this.rainShootAnimationTick = this.rainShootAnimationLength;
        } else if (p_28844_ == 7) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else if (p_28844_ == 6) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 5) {
            this.tridentStormAnimationTick = this.tridentStormAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    protected boolean func_190730_o() {
        return false;
    }

    protected float func_70647_i() {
        return !this.func_70090_H() ? super.func_70647_i() / 1.5f : super.func_70647_i();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_IDLE.get() : SoundEvents.field_204774_aY;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.func_70090_H() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_HURT.get() : SoundEvents.field_204778_bc;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70090_H() ? (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_DEATH.get() : SoundEvents.field_204776_ba;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_204781_bf;
    }

    protected SoundEvent func_184184_Z() {
        return (SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SWIM.get();
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.NECROMANCER_TRIDENT.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.DROWNED_NECROMANCER_ARMOR, (MobEntity)this);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.tridentStormAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_trident_storm", Boolean.valueOf(true)));
        } else if (this.rainTridentStormAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_trident_storm_land", Boolean.valueOf(true)));
        } else if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_summon", Boolean.valueOf(true)));
        } else if (this.landSummonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_summon", Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_shoot", Boolean.valueOf(true)));
        } else if (this.rainShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_shoot_land", Boolean.valueOf(true)));
        } else if (this.landShootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_shoot", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.func_70090_H()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_swim", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_walk", Boolean.valueOf(true)));
            }
        } else if (this.func_70090_H()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("drowned_necromancer_idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private boolean isInRain() {
        BlockPos blockpos = this.func_233580_cy_();
        return this.field_70170_p.func_175727_C(blockpos) || this.field_70170_p.func_175727_C(new BlockPos((double)blockpos.func_177958_n(), this.func_174813_aQ().field_72337_e, (double)blockpos.func_177952_p()));
    }

    public ArmorSet getArmorSet() {
        return ModItems.DROWNED_NECROMANCER_ARMOR;
    }

    class TridentStormGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int tridentSummonRange = 20;

        public TridentStormGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.func_203005_aq();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.tridentStormAnimationTick = this.mob.tridentStormAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)5);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.tridentStormAnimationTick == 30) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_PREPARE_TRIDENT_STORM.get(), 3.0f, 1.0f);
            }
            if (this.target != null && this.mob.tridentStormAnimationTick <= 30 && this.mob.tridentStormAnimationTick >= 10) {
                TridentStormEntity tridentStorm = (TridentStormEntity)((EntityType)ModEntityTypes.TRIDENT_STORM.get()).func_200721_a(this.mob.field_70170_p);
                tridentStorm.owner = this.mob;
                tridentStorm.func_174828_a(new BlockPos(this.mob.func_226277_ct_() - (double)this.tridentSummonRange + (double)this.mob.field_70146_Z.nextInt(this.tridentSummonRange * 2), this.mob.func_226278_cu_(), this.mob.func_226281_cx_() - (double)this.tridentSummonRange + (double)this.mob.field_70146_Z.nextInt(this.tridentSummonRange * 2)), 0.0f, 0.0f);
                tridentStorm.field_70177_z = this.mob.field_70146_Z.nextInt(360);
                this.mob.field_70170_p.func_217376_c((Entity)tridentStorm);
                PositionUtils.moveToCorrectHeight(tridentStorm);
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (100 + this.mob.field_70146_Z.nextInt(300));
        }

        public boolean animationsUseable() {
            return this.mob.tridentStormAnimationTick <= 0;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public ShootAttackGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 14.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable() && this.mob.func_203005_aq();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)6);
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_STEAM_MISSILE.get(), 1.5f, 1.0f);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_ATTACK.get(), 1.5f, 1.0f);
            }
            if (this.target != null && (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 2 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 4 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 6 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 8 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 10)) {
                Vector3d pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.field_70177_z);
                double d1 = this.target.func_226277_ct_() - pos.field_72450_a;
                double d2 = this.target.func_226283_e_(0.6) - pos.field_72448_b;
                double d3 = this.target.func_226281_cx_() - pos.field_72449_c;
                DrownedNecromancerOrbEntity necromancerOrb = new DrownedNecromancerOrbEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1 + this.mob.field_70146_Z.nextGaussian() * 1.25, d2 + this.mob.field_70146_Z.nextGaussian() * 0.5, d3 + this.mob.field_70146_Z.nextGaussian() * 1.25);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                this.mob.field_70170_p.func_217376_c((Entity)necromancerOrb);
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + 20;
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class SummonGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 6;
        public int closeMobSummonRange = 3;

        public SummonGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.func_203005_aq();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_STRONG_ATTACK.get(), 1.0f, 1.0f);
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)7);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint) {
                for (int i = 0; i < 6; ++i) {
                    SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                    mobSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                    mobSummonSpot.setSummonType(2);
                    BlockPos summonPos = this.mob.func_233580_cy_().func_177982_a(-this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1));
                    mobSummonSpot.func_174828_a(summonPos, 0.0f, 0.0f);
                    if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.func_233580_cy_().func_177982_a(-this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1));
                    }
                    if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                        summonPos = this.mob.func_233580_cy_();
                    }
                    ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)mobSummonSpot);
                    EntityType<?> entityType = this.getEntityType();
                    MobEntity summonedMob = null;
                    Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.func_233580_cy_(), entityType);
                    if (entity == null) {
                        mobSummonSpot.func_70106_y();
                        return;
                    }
                    if (entity instanceof MobEntity) {
                        summonedMob = (MobEntity)entity;
                    }
                    summonedMob.func_70624_b(this.target);
                    summonedMob.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(summonPos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                    mobSummonSpot.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                    if (this.mob.func_96124_cp() != null) {
                        Scoreboard scoreboard = this.mob.field_70170_p.func_96441_U();
                        scoreboard.func_197901_a(summonedMob.func_195047_I_(), scoreboard.func_96508_e(this.mob.func_96124_cp().func_96661_b()));
                    }
                    mobSummonSpot.summonedEntity = summonedMob;
                }
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.DROWNED_NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.func_70681_au().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.field_204724_o;
            }
            return entityType;
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (200 + this.mob.field_70146_Z.nextInt(250));
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vector3d vector3d = new Vector3d(entitySeeing.func_226277_ct_(), entitySeeing.func_226280_cw_(), entitySeeing.func_226281_cx_());
            Vector3d vector3d1 = new Vector3d(p_70685_1_.func_226277_ct_(), p_70685_1_.func_226280_cw_(), p_70685_1_.func_226281_cx_());
            if (p_70685_1_.field_70170_p != entitySeeing.field_70170_p || vector3d1.func_72436_e(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entitySeeing)).func_216346_c() == RayTraceResult.Type.MISS;
        }
    }

    class RainShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public RainShootAttackGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable() && !this.mob.func_203005_aq() && this.mob.isInRain();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.rainShootAnimationTick = this.mob.rainShootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)8);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_SHOOT.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 3 || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 6 || this.mob.rainShootAnimationTick == this.mob.rainShootAnimationActionPoint - 9)) {
                Vector3d pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.field_70177_z);
                double d1 = this.target.func_226277_ct_() - pos.field_72450_a;
                double d2 = this.target.func_226283_e_(0.6) - pos.field_72448_b;
                double d3 = this.target.func_226281_cx_() - pos.field_72449_c;
                DrownedNecromancerOrbEntity necromancerOrb = new DrownedNecromancerOrbEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1 + this.mob.field_70146_Z.nextGaussian() * 1.0, d2 + this.mob.field_70146_Z.nextGaussian() * 0.25, d3 + this.mob.field_70146_Z.nextGaussian() * 1.0);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                this.mob.field_70170_p.func_217376_c((Entity)necromancerOrb);
            }
        }

        public boolean animationsUseable() {
            return this.mob.rainShootAnimationTick <= 0;
        }
    }

    class RainTridentStormGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int tridentSummonRange = 15;

        public RainTridentStormGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 13.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && !this.mob.func_203005_aq() && this.mob.isInRain();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.rainTridentStormAnimationTick = this.mob.rainTridentStormAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.rainTridentStormAnimationTick == 30) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.DROWNED_NECROMANCER_PREPARE_TRIDENT_STORM.get(), 3.0f, 1.0f);
            }
            if (this.target != null && this.mob.rainTridentStormAnimationTick <= 30 && this.mob.rainTridentStormAnimationTick >= 10 && this.mob.field_70146_Z.nextBoolean()) {
                TridentStormEntity tridentStorm = (TridentStormEntity)((EntityType)ModEntityTypes.TRIDENT_STORM.get()).func_200721_a(this.mob.field_70170_p);
                tridentStorm.owner = this.mob;
                tridentStorm.func_174828_a(new BlockPos(this.mob.func_226277_ct_() - (double)this.tridentSummonRange + (double)this.mob.field_70146_Z.nextInt(this.tridentSummonRange * 2), this.mob.func_226278_cu_(), this.mob.func_226281_cx_() - (double)this.tridentSummonRange + (double)this.mob.field_70146_Z.nextInt(this.tridentSummonRange * 2)), 0.0f, 0.0f);
                tridentStorm.field_70177_z = this.mob.field_70146_Z.nextInt(360);
                this.mob.field_70170_p.func_217376_c((Entity)tridentStorm);
                PositionUtils.moveToCorrectHeight(tridentStorm);
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (100 + this.mob.field_70146_Z.nextInt(300));
        }

        public boolean animationsUseable() {
            return this.mob.rainTridentStormAnimationTick <= 0;
        }
    }

    class LandShootAttackGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public LandShootAttackGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable() && !this.mob.func_203008_ap();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.landShootAnimationTick = this.mob.landShootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.landShootAnimationTick == this.mob.landShootAnimationActionPoint) {
                Vector3d pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.field_70177_z);
                double d1 = this.target.func_226277_ct_() - pos.field_72450_a;
                double d2 = this.target.func_226283_e_(0.6) - pos.field_72448_b;
                double d3 = this.target.func_226281_cx_() - pos.field_72449_c;
                NecromancerOrbEntity necromancerOrb = new NecromancerOrbEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1, d2, d3);
                necromancerOrb.setDelayedForm(true);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                this.mob.field_70170_p.func_217376_c((Entity)necromancerOrb);
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.landShootAnimationTick <= 0;
        }
    }

    class LandSummonGoal
    extends Goal {
        public DrownedNecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 5;
        public int closeMobSummonRange = 2;

        public LandSummonGoal(DrownedNecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && !this.mob.func_203005_aq();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), 1.0f, 1.0f);
            this.mob.landSummonAnimationTick = this.mob.landSummonAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && (this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint1 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint2 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint3 || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint4 && this.mob.field_70146_Z.nextBoolean() || this.mob.landSummonAnimationTick == this.mob.landSummonAnimationActionPoint5 && this.mob.field_70146_Z.nextBoolean())) {
                SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                mobSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                mobSummonSpot.setSummonType(2);
                BlockPos summonPos = this.mob.func_233580_cy_().func_177982_a(-this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1));
                mobSummonSpot.func_174828_a(summonPos, 0.0f, 0.0f);
                if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.func_233580_cy_().func_177982_a(-this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1));
                }
                if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.func_233580_cy_();
                }
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)mobSummonSpot);
                PositionUtils.moveToCorrectHeight(mobSummonSpot);
                EntityType<?> entityType = this.getEntityType();
                MobEntity summonedMob = null;
                Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.func_233580_cy_(), entityType);
                if (entity == null) {
                    mobSummonSpot.func_70106_y();
                    return;
                }
                if (entity instanceof MobEntity) {
                    summonedMob = (MobEntity)entity;
                }
                summonedMob.func_70624_b(this.target);
                summonedMob.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(summonPos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                mobSummonSpot.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                if (this.mob.func_96124_cp() != null) {
                    Scoreboard scoreboard = this.mob.field_70170_p.func_96441_U();
                    scoreboard.func_197901_a(summonedMob.func_195047_I_(), scoreboard.func_96508_e(this.mob.func_96124_cp().func_96661_b()));
                }
                mobSummonSpot.summonedEntity = summonedMob;
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.DROWNED_NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.func_70681_au().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.field_204724_o;
            }
            return entityType;
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (200 + this.mob.field_70146_Z.nextInt(200));
        }

        public boolean animationsUseable() {
            return this.mob.landSummonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vector3d vector3d = new Vector3d(entitySeeing.func_226277_ct_(), entitySeeing.func_226280_cw_(), entitySeeing.func_226281_cx_());
            Vector3d vector3d1 = new Vector3d(p_70685_1_.func_226277_ct_(), p_70685_1_.func_226280_cw_(), p_70685_1_.func_226281_cx_());
            if (p_70685_1_.field_70170_p != entitySeeing.field_70170_p || vector3d1.func_72436_e(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entitySeeing)).func_216346_c() == RayTraceResult.Type.MISS;
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final DrownedNecromancerEntity drowned;

        public GoToBeachGoal(DrownedNecromancerEntity p_i48911_1_, double p_i48911_2_) {
            super((CreatureEntity)p_i48911_1_, p_i48911_2_, 8, 2);
            this.drowned = p_i48911_1_;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.drowned.field_70170_p.func_72935_r() && this.drowned.field_70170_p.func_72896_J() && this.drowned.func_70090_H() && this.drowned.func_226278_cu_() >= (double)(this.drowned.field_70170_p.func_181545_F() - 7);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            BlockPos blockpos = p_179488_2_.func_177984_a();
            return p_179488_1_.func_175623_d(blockpos) && p_179488_1_.func_175623_d(blockpos.func_177984_a()) ? p_179488_1_.func_180495_p(p_179488_2_).func_235719_a_((IBlockReader)p_179488_1_, p_179488_2_, (Entity)this.drowned) : false;
        }

        public void func_75249_e() {
            this.drowned.func_204713_s(false);
            this.drowned.field_70699_by = (PathNavigator)this.drowned.field_204717_b;
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final CreatureEntity mob;
        private final double speedModifier;
        private final World level;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public GoToWaterGoal(CreatureEntity p_i48910_1_, double p_i48910_2_) {
            this.mob = p_i48910_1_;
            this.speedModifier = p_i48910_2_;
            this.level = p_i48910_1_.field_70170_p;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.level.func_72935_r()) {
                return false;
            }
            if (this.mob.func_70026_G()) {
                return false;
            }
            Vector3d vector3d = this.getWaterPos();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.field_72450_a;
            this.wantedY = vector3d.field_72448_b;
            this.wantedZ = vector3d.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !this.mob.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            this.mob.func_70661_as().func_75492_a(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vector3d getWaterPos() {
            Random random = this.mob.func_70681_au();
            BlockPos blockpos = this.mob.func_233580_cy_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (!this.level.func_180495_p(blockpos1).func_203425_a(Blocks.field_150355_j)) continue;
                return Vector3d.func_237492_c_((Vector3i)blockpos1);
            }
            return null;
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final DrownedNecromancerEntity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(DrownedNecromancerEntity p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean func_75250_a() {
            return !this.drowned.field_70170_p.func_72935_r() && this.drowned.func_70090_H() && this.drowned.func_226278_cu_() < (double)(this.seaLevel - 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !this.stuck;
        }

        public void func_75246_d() {
            if (this.drowned.func_226278_cu_() < (double)(this.seaLevel - 1) && (this.drowned.func_70661_as().func_75500_f() || this.drowned.func_204710_dB())) {
                Vector3d vector3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.drowned, (int)4, (int)8, (Vector3d)new Vector3d(this.drowned.func_226277_ct_(), (double)(this.seaLevel - 1), this.drowned.func_226281_cx_()));
                if (vector3d == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.func_70661_as().func_75492_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, this.speedModifier);
            }
        }

        public void func_75249_e() {
            this.drowned.func_204713_s(true);
            this.stuck = false;
        }

        public void func_75251_c() {
            this.drowned.func_204713_s(false);
        }
    }
}

