/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.entities.summonables.WraithFireEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WraithEntity
extends MonsterEntity
implements IAnimatable {
    public int summonFireAttackAnimationTick;
    public int summonFireAttackAnimationLength = 40;
    public int summonFireAttackAnimationActionPoint = 20;
    public int teleportAnimationTick;
    public int teleportAnimationLength = 40;
    public int teleportAnimationActionPoint = 18;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public WraithEntity(EntityType<? extends WraithEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TeleportGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonFireAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ApproachTargetGoal((CreatureEntity)this, 8.0, 1.2, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx).func_190882_b(300));
    }

    public boolean isSpellcasting() {
        return this.summonFireAttackAnimationTick > 0;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.teleportAnimationTick = this.teleportAnimationLength;
        } else if (p_28844_ == 11) {
            this.summonFireAttackAnimationTick = this.summonFireAttackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223223_b_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.teleportAnimationTick > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, this.func_226282_d_(1.0), this.func_226278_cu_(), this.func_226287_g_(1.0), this.field_70146_Z.nextGaussian() * 0.01, 0.1, this.field_70146_Z.nextGaussian() * 0.01);
        }
    }

    public void tickDownAnimTimers() {
        if (this.summonFireAttackAnimationTick > 0) {
            --this.summonFireAttackAnimationTick;
        }
        if (this.teleportAnimationTick > 0) {
            --this.teleportAnimationTick;
        }
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.75, 1.0));
        }
        if (this.func_70089_S()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.func_204609_dp();
            if (flag) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean isSunSensitive() {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.WRAITH_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.WRAITH_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.WRAITH_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.WRAITH_FLY.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.5f, 1.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonFireAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.teleportAnimationTick > 10) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_teleport", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wraith_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected boolean teleport() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, (SoundEvent)ModSoundEvents.WRAITH_TELEPORT.get(), this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a((SoundEvent)ModSoundEvents.WRAITH_TELEPORT.get(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    class SummonFireAttackGoal
    extends Goal {
        public WraithEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime = 0;

        public SummonFireAttackGoal(WraithEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 14.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WRAITH_ATTACK.get(), 1.0f, this.mob.func_70647_i());
            this.mob.summonFireAttackAnimationTick = this.mob.summonFireAttackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.summonFireAttackAnimationTick == this.mob.summonFireAttackAnimationActionPoint) {
                WraithFireEntity wraithFire = (WraithFireEntity)((EntityType)ModEntityTypes.WRAITH_FIRE.get()).func_200721_a(this.mob.field_70170_p);
                wraithFire.owner = this.mob;
                wraithFire.func_233576_c_(this.target.func_213303_ch());
                this.mob.field_70170_p.func_217376_c((Entity)wraithFire);
                PositionUtils.moveToCorrectHeight(wraithFire);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.nextUseTime = this.mob.field_70173_aa + 60 + this.mob.field_70146_Z.nextInt(60);
        }

        public boolean animationsUseable() {
            return this.mob.summonFireAttackAnimationTick <= 0;
        }
    }

    class TeleportGoal
    extends Goal {
        public WraithEntity mob;
        @Nullable
        public LivingEntity target;

        public TeleportGoal(WraithEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (this.mob.func_70032_d((Entity)this.target) <= 4.0f || this.mob.func_70032_d((Entity)this.target) >= 16.0f) && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WRAITH_IDLE.get(), 1.0f, this.mob.func_70647_i());
            this.mob.teleportAnimationTick = this.mob.teleportAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            block5: {
                this.target = this.mob.func_70638_az();
                if (this.target != null) {
                    this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
                }
                int teleportAwayRange = 20;
                int teleportToRange = 10;
                if (this.target == null || this.mob.teleportAnimationTick != this.mob.teleportAnimationActionPoint) break block5;
                if (this.mob.func_70032_d((Entity)this.target) >= 16.0f) {
                    for (int i = 0; i < 10; ++i) {
                        this.mob.teleport(this.target.func_226277_ct_() - (double)teleportToRange + (double)this.mob.field_70146_Z.nextInt(teleportToRange * 2), this.target.func_226278_cu_(), this.target.func_226281_cx_() - (double)teleportToRange + (double)this.mob.field_70146_Z.nextInt(teleportToRange * 2));
                    }
                } else {
                    for (int i = 0; i < 10; ++i) {
                        this.mob.teleport(this.target.func_226277_ct_() - (double)teleportAwayRange + (double)this.mob.field_70146_Z.nextInt(teleportAwayRange * 2), this.target.func_226278_cu_(), this.target.func_226281_cx_() - (double)teleportAwayRange + (double)this.mob.field_70146_Z.nextInt(teleportAwayRange * 2));
                    }
                }
            }
        }

        public boolean animationsUseable() {
            return this.mob.teleportAnimationTick <= 0;
        }
    }
}

