/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.AnimatableMeleeAttackMob;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.BasicModdedAttackGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.UseShieldGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SkeletonVanguardEntity
extends SkeletonEntity
implements IShieldUser,
IAnimatable,
SpawnArmoredMob,
AnimatableMeleeAttackMob {
    private static final UUID SPEED_MODIFIER_BLOCKING_UUID = UUID.fromString("e4c96392-42f5-4028-ac44-cad469c10d51");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_UUID, "Blocking speed decrease", -0.05, AttributeModifier.Operation.ADDITION);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int shieldCooldownTime;
    public int attackAnimationTick;
    public int attackAnimationLength = 22;
    public int attackAnimationActionPoint = 10;

    public SkeletonVanguardEntity(World worldIn) {
        super((EntityType)ModEntityTypes.SKELETON_VANGUARD.get(), worldIn);
    }

    public SkeletonVanguardEntity(EntityType<? extends SkeletonVanguardEntity> p_i48555_1_, World p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
        this.shieldCooldownTime = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new UseShieldGoal((CreatureEntity)this, 10.0, 60, 120, 10, 60, true));
        this.field_70714_bg.func_75776_a(1, new BasicModdedAttackGoal<SkeletonVanguardEntity>(this, (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_ATTACK.get(), 20));
        this.field_70714_bg.func_75776_a(2, (Goal)new ApproachTargetGoal((CreatureEntity)this, 0.0, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WolfEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    protected boolean func_204609_dp() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return SkeletonEntity.func_234275_m_().func_233815_a_(Attributes.field_233819_b_, 26.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233824_g_, 1.5).func_233815_a_(Attributes.field_233820_c_, 0.3);
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        SpawnArmoredHelper.equipArmorSet(ModItems.VANGUARD_ARMOR, (MobEntity)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item GLAIVE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "glaive"));
            ItemStack glaive = new ItemStack((IItemProvider)GLAIVE);
            this.func_184201_a(EquipmentSlotType.MAINHAND, glaive);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        }
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModItems.VANGUARD_SHIELD.get()));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityDataIn, @Nullable CompoundNBT compoundNBT) {
        livingEntityDataIn = super.func_213386_a(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        return livingEntityDataIn;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_DEATH.get();
    }

    protected SoundEvent func_190727_o() {
        return (SoundEvent)ModSoundEvents.SKELETON_VANGUARD_STEP.get();
    }

    public boolean func_184638_cS() {
        return true;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (this.func_184585_cz()) {
            if (!modifiableattributeinstance.func_180374_a(SPEED_MODIFIER_BLOCKING)) {
                modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_BLOCKING);
            }
        } else {
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_BLOCKING);
        }
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_attack", Boolean.valueOf(true)));
        } else if (this.func_184585_cz()) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_walk_blocking", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_blocking", Boolean.valueOf(true)));
            }
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("skeleton_vanguard_new_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    protected void func_184581_c(DamageSource damageSource) {
        if (this.shieldCooldownTime == 100) {
            this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else if (this.func_184585_cz()) {
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else {
            super.func_184581_c(damageSource);
        }
    }

    public void func_190629_c(LivingEntity livingEntity) {
        super.func_190629_c(livingEntity);
        if (livingEntity.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void func_184590_k(float amount) {
        if (this.field_184627_bm.isShield((LivingEntity)this) && amount >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)amount);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, skeletonVanguardEntity -> skeletonVanguardEntity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public void setAttackAnimationTick(int attackAnimationTick) {
        this.attackAnimationTick = attackAnimationTick;
    }

    @Override
    public int getAttackAnimationLength() {
        return this.attackAnimationLength;
    }

    @Override
    public int getAttackAnimationActionPoint() {
        return this.attackAnimationActionPoint;
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.shieldCooldownTime = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    public ArmorSet getArmorSet() {
        return ModItems.VANGUARD_ARMOR;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof PlayerEntity && livingEntity.func_184585_cz()) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184586_b(livingEntity.func_184600_cs()).func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }
}

