/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.projectiles.NecromancerOrbEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class NecromancerEntity
extends SkeletonEntity
implements IAnimatable,
SpawnArmoredMob {
    public int shootAnimationTick;
    public int shootAnimationLength = 20;
    public int shootAnimationActionPoint = 7;
    public int summonAnimationTick;
    public int summonAnimationLength = 45;
    public int summonAnimationActionPoint1 = this.summonAnimationLength - 20;
    public int summonAnimationActionPoint2 = this.summonAnimationLength - 23;
    public int summonAnimationActionPoint3 = this.summonAnimationLength - 26;
    public int summonAnimationActionPoint4 = this.summonAnimationLength - 32;
    public int summonAnimationActionPoint5 = this.summonAnimationLength - 38;
    public int specialAnimationTick;
    public int specialAnimationLength = 48;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public NecromancerEntity(World worldIn) {
        super((EntityType)ModEntityTypes.NECROMANCER.get(), worldIn);
    }

    public NecromancerEntity(EntityType<? extends NecromancerEntity> p_i48555_1_, World p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return SkeletonEntity.func_234275_m_().func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.4).func_233815_a_((Attribute)AttributeRegistry.SUMMON_CAP.get(), 4.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SummonGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ApproachTargetGoal((CreatureEntity)this, 10.0, 1.2, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 5.0f, 1.2, 1.6));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 5.0f, 1.2, 1.6));
        this.field_70714_bg.func_75776_a(4, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public boolean isSpellcasting() {
        return this.shootAnimationTick > 0 || this.summonAnimationTick > 0;
    }

    public void func_85036_m() {
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223223_b_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.25f;
    }

    protected boolean func_204609_dp() {
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.NECROMANCER_STAFF.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.NECROMANCER_ARMOR, (MobEntity)this);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityDataIn, @Nullable CompoundNBT compoundNBT) {
        livingEntityDataIn = super.func_213386_a(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        return livingEntityDataIn;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.NECROMANCER_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_DEATH.get();
    }

    protected SoundEvent func_190727_o() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_STEP.get();
    }

    public boolean func_184638_cS() {
        return false;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.specialAnimationTick = this.specialAnimationLength;
        } else if (p_28844_ == 11) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 9) {
            this.summonAnimationTick = this.summonAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.field_70146_Z.nextInt(300) == 0) {
            this.specialAnimationTick = this.specialAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            this.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_LAUGH.get(), this.func_70599_aP(), this.func_70647_i());
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() == null || this.field_70146_Z.nextInt(100) != 0 && this.func_70638_az().field_70725_aQ <= 0)) {
            this.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_LAUGH.get(), this.func_70599_aP(), this.func_70647_i());
            this.field_70757_a = -this.func_70627_aG() / 2;
        }
    }

    public void tickDownAnimTimers() {
        if (this.specialAnimationTick > 0) {
            --this.specialAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.summonAnimationTick > 0) {
            --this.summonAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_summon", Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_shoot", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_walk", Boolean.valueOf(true)));
        } else if (this.specialAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_rare_idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ArmorSet getArmorSet() {
        return ModItems.NECROMANCER_ARMOR;
    }

    class ShootAttackGoal
    extends Goal {
        public NecromancerEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(NecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.mob.func_70032_d((Entity)this.target) > 5.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                Vector3d pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.3, 1.5, 0.5, this.mob.field_70761_aq);
                double d1 = this.target.func_226277_ct_() - pos.field_72450_a;
                double d2 = this.target.func_226283_e_(0.6) - pos.field_72448_b;
                double d3 = this.target.func_226281_cx_() - pos.field_72449_c;
                NecromancerOrbEntity necromancerOrb = new NecromancerOrbEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1, d2, d3);
                necromancerOrb.setDelayedForm(true);
                necromancerOrb.rotateToMatchMovement();
                necromancerOrb.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                this.mob.field_70170_p.func_217376_c((Entity)necromancerOrb);
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_SHOOT.get(), 1.0f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class SummonGoal
    extends Goal {
        public NecromancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int mobSummonRange = 3;
        public int closeMobSummonRange = 1;

        public SummonGoal(NecromancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) > 5.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target);
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), 1.0f, 1.0f);
            this.mob.summonAnimationTick = this.mob.summonAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && (this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint1 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint2 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint3 || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint4 && this.mob.field_70146_Z.nextBoolean() || this.mob.summonAnimationTick == this.mob.summonAnimationActionPoint5 && this.mob.field_70146_Z.nextBoolean())) {
                SummonSpotEntity mobSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                mobSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                mobSummonSpot.setSummonType(2);
                BlockPos summonPos = this.mob.func_233580_cy_().func_177982_a(-this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1), 0, -this.mobSummonRange + this.mob.field_70146_Z.nextInt(this.mobSummonRange * 2 + 1));
                mobSummonSpot.func_174828_a(summonPos, 0.0f, 0.0f);
                if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.func_233580_cy_().func_177982_a(-this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1), 0, -this.closeMobSummonRange + this.mob.field_70146_Z.nextInt(this.closeMobSummonRange * 2 + 1));
                }
                if (mobSummonSpot.func_70094_T() || !this.canSee(mobSummonSpot, (Entity)this.target)) {
                    summonPos = this.mob.func_233580_cy_();
                }
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)mobSummonSpot);
                PositionUtils.moveToCorrectHeight(mobSummonSpot);
                EntityType<?> entityType = this.getEntityType();
                MobEntity summonedMob = null;
                Entity entity = SummonHelper.summonEntity((LivingEntity)this.mob, (BlockPos)mobSummonSpot.func_233580_cy_(), entityType);
                if (entity == null) {
                    mobSummonSpot.func_70106_y();
                    return;
                }
                if (entity instanceof MobEntity) {
                    summonedMob = (MobEntity)entity;
                }
                summonedMob.func_70624_b(this.target);
                summonedMob.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(summonPos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                mobSummonSpot.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_SUMMON.get(), 1.0f, 1.0f);
                if (this.mob.func_96124_cp() != null) {
                    Scoreboard scoreboard = this.mob.field_70170_p.func_96441_U();
                    scoreboard.func_197901_a(summonedMob.func_195047_I_(), scoreboard.func_96508_e(this.mob.func_96124_cp().func_96661_b()));
                }
                mobSummonSpot.summonedEntity = summonedMob;
            }
        }

        private EntityType<?> getEntityType() {
            EntityType entityType = null;
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.NECROMANCER_MOB_SUMMONS.get();
            if (!necromancerMobSummons.isEmpty()) {
                Collections.shuffle(necromancerMobSummons);
                int randomIndex = this.mob.func_70681_au().nextInt(necromancerMobSummons.size());
                String randomMobID = (String)necromancerMobSummons.get(randomIndex);
                entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            }
            if (entityType == null) {
                entityType = EntityType.field_200725_aD;
            }
            return entityType;
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (200 + this.mob.field_70146_Z.nextInt(200));
        }

        public boolean animationsUseable() {
            return this.mob.summonAnimationTick <= 0;
        }

        public boolean canSee(Entity entitySeeing, Entity p_70685_1_) {
            Vector3d vector3d = new Vector3d(entitySeeing.func_226277_ct_(), entitySeeing.func_226280_cw_(), entitySeeing.func_226281_cx_());
            Vector3d vector3d1 = new Vector3d(p_70685_1_.func_226277_ct_(), p_70685_1_.func_226280_cw_(), p_70685_1_.func_226281_cx_());
            if (p_70685_1_.field_70170_p != entitySeeing.field_70170_p || vector3d1.func_72436_e(vector3d) > 16384.0) {
                return false;
            }
            return entitySeeing.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entitySeeing)).func_216346_c() == RayTraceResult.Type.MISS;
        }
    }
}

