/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class MossySkeletonEntity
extends AbstractSkeletonEntity {
    public MossySkeletonEntity(World worldIn) {
        super((EntityType)ModEntityTypes.MOSSY_SKELETON.get(), worldIn);
    }

    public MossySkeletonEntity(EntityType<? extends MossySkeletonEntity> entityType, World world) {
        super(entityType, world);
    }

    public static boolean canMossySkeletonSpawn(EntityType<MossySkeletonEntity> entityType, IServerWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random rand) {
        return MossySkeletonEntity.func_223325_c(entityType, (IServerWorld)iWorld, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)rand) && (spawnReason == SpawnReason.SPAWNER || iWorld.func_226660_f_(blockPos));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return AbstractSkeletonEntity.func_234275_m_();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, 0.25f, this.func_70647_i());
        }
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_DEATH.get();
    }

    protected SoundEvent func_190727_o() {
        return (SoundEvent)ModSoundEvents.MOSSY_SKELETON_STEP.get();
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrowEntity abstractarrowentity = this.func_213624_b(itemstack, p_82196_2_);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_82196_1_.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a((SoundEvent)ModSoundEvents.MOSSY_SKELETON_SHOOT.get(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public boolean func_70652_k(Entity targetEntity) {
        if (super.func_70652_k(targetEntity)) {
            if (targetEntity instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 4;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 8;
                }
                if (i > 0) {
                    ((LivingEntity)targetEntity).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected AbstractArrowEntity func_213624_b(ItemStack stack, float damageMultiplier) {
        AbstractArrowEntity abstractArrowEntity = super.func_213624_b(stack, damageMultiplier);
        int i = 0;
        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
            i = 4;
        } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            i = 8;
        }
        if (abstractArrowEntity instanceof ArrowEntity && i > 0) {
            ((ArrowEntity)abstractArrowEntity).func_184558_a(new EffectInstance(Effects.field_76436_u, i * 20));
        }
        return abstractArrowEntity;
    }
}

