/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AbstractTrapEntity;
import com.infamous.dungeons_mobs.tags.CustomTags;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SimpleTrapEntity
extends AbstractTrapEntity {
    private static final DataParameter<Integer> TRAP_TYPE = EntityDataManager.func_187226_a(SimpleTrapEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SimpleTrapEntity(EntityType<? extends SimpleTrapEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TRAP_TYPE, (Object)0);
    }

    @Override
    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.setTrapType(p_70037_1_.func_74762_e("TrapType"));
    }

    @Override
    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74768_a("TrapType", this.getTrapType());
    }

    public int getTrapType() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(TRAP_TYPE)), (int)0, (int)1);
    }

    public void setTrapType(int attached) {
        this.field_70180_af.func_187227_b(TRAP_TYPE, (Object)attached);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getTrapType() == 0) {
            if (this.spawnAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("web_trap_spawn", Boolean.valueOf(true)));
            } else if (this.decayAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", Boolean.valueOf(true)));
            }
        } else if (this.getTrapType() == 1) {
            if (this.spawnAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_spawn", Boolean.valueOf(true)));
            } else if (this.decayAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getSpawnAnimationLength() {
        return this.getTrapType() == 1 ? 8 : 7;
    }

    @Override
    public int getDecayAnimationLength() {
        return 25;
    }

    @Override
    public boolean canTrapEntity(LivingEntity entity) {
        if (this.getTrapType() == 0) {
            return super.canTrapEntity(entity) && entity.func_70668_bt() != CreatureAttribute.field_223224_c_;
        }
        if (this.getTrapType() == 1) {
            return super.canTrapEntity(entity) && !entity.func_200600_R().func_220341_a(CustomTags.PLANT_MOBS);
        }
        return super.canTrapEntity(entity);
    }
}

