/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AbstractTrapEntity;
import com.infamous.dungeons_mobs.tags.CustomTags;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class KelpTrapEntity
extends AbstractTrapEntity {
    private static final DataParameter<Boolean> PULLING = EntityDataManager.func_187226_a(KelpTrapEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int ensnareAnimationTick;
    public int ensnareAnimationLength = 5;
    public int trappedMobTime;
    public int bubbleAudioInterval;

    public KelpTrapEntity(EntityType<? extends KelpTrapEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.ensnareAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_ensnare", Boolean.valueOf(true)));
        } else if (this.spawnAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_spawn", Boolean.valueOf(true)));
        } else if (this.decayAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_decay", Boolean.valueOf(true)));
        } else if (this.isPulling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("kelp_trap_idle_pulling", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("vine_trap_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getSpawnAnimationLength() {
        return 10;
    }

    @Override
    public int getDecayAnimationLength() {
        return 25;
    }

    @Override
    public boolean canTrapEntity(LivingEntity entity) {
        return super.canTrapEntity(entity) && !entity.func_200600_R().func_220341_a(CustomTags.PLANT_MOBS);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PULLING, (Object)true);
    }

    @Override
    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.setPulling(p_70037_1_.func_74767_n("Pulling"));
    }

    @Override
    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74757_a("Pulling", this.isPulling());
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(PULLING);
    }

    public void setPulling(boolean attached) {
        this.field_70180_af.func_187227_b(PULLING, (Object)attached);
    }

    @Override
    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.lifeTime == 0) {
            this.setPulling(true);
        }
        if (this.bubbleAudioInterval > 0) {
            --this.bubbleAudioInterval;
        }
        if (!this.field_70170_p.field_72995_K && this.isPulling()) {
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.0, this.waterBlocksAbove(), 0.0), null);
            int i = 0;
            while ((double)i < this.waterBlocksAbove()) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_203218_U, this.func_226282_d_(0.25), this.func_226278_cu_() + (double)i + 0.8, this.func_226287_g_(0.25) - 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ++i;
            }
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity.func_226278_cu_() > this.func_226278_cu_()) || (!(entity instanceof LivingEntity) || !this.canTrapEntity((LivingEntity)entity)) && entity instanceof LivingEntity) continue;
                    if (this.bubbleAudioInterval <= 0) {
                        this.func_184185_a(SoundEvents.field_203283_jd, 1.25f, 1.0f);
                        this.bubbleAudioInterval = 40;
                    }
                    entity.func_70024_g(0.0, -0.1, 0.0);
                    entity.field_70133_I = true;
                }
            }
        }
        super.func_70030_z();
    }

    @Override
    public void tickDownAnimTimers() {
        super.tickDownAnimTimers();
        if (this.ensnareAnimationTick > 0) {
            --this.ensnareAnimationTick;
        }
    }

    public double waterBlocksAbove() {
        double waterBlocksAbove = 0.0;
        for (int i = 0; i < 256; ++i) {
            waterBlocksAbove = i;
            if (this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177981_b(i)).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return waterBlocksAbove;
        }
        return waterBlocksAbove;
    }

    @Override
    public void increaseLifeTime() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isTrappingMob) {
                ++this.trappedMobTime;
                if (this.isPulling() && this.ensnareAnimationTick <= 0) {
                    this.setPulling(false);
                    this.ensnareAnimationTick = this.ensnareAnimationLength;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                }
            } else {
                ++this.lifeTime;
            }
            if (this.trappedMobTime == this.timeToDecay()) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            }
            if (this.isPulling()) {
                if (this.lifeTime == 200) {
                    this.ensnareAnimationTick = this.ensnareAnimationLength;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                }
                if (this.lifeTime == 200 + this.ensnareAnimationLength) {
                    this.decayAnimationTick = this.getDecayAnimationLength();
                    this.field_70170_p.func_72960_a((Entity)this, (byte)2);
                }
            } else if (this.trappedMobTime == 100) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            }
            if (this.decayAnimationTick == 2) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean canTrap() {
        return true;
    }

    @Override
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 3) {
            this.ensnareAnimationTick = this.ensnareAnimationLength;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }
}

