/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModDamageSources;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class IceCloudEntity
extends Entity
implements IAnimatable {
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.func_70089_S();
    public LivingEntity target;
    public Entity owner;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int formAnimationTick;
    public int formAnimationLength = 40;
    public int fallAnimationTick;
    public int fallAnimationLength = 17;
    public int landAnimationTick;
    public int landAnimationLength = 22;
    public int lifeTime;
    public boolean falling;
    public boolean hasFormed;
    public int soundLoopTick;

    public IceCloudEntity(World world) {
        super((EntityType)ModEntityTypes.ICE_CLOUD.get(), world);
        this.field_70156_m = true;
    }

    public IceCloudEntity(EntityType<? extends IceCloudEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.field_70156_m = true;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected float getRandomPitch() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 1) {
            this.formAnimationTick = this.formAnimationLength;
        } else if (p_28844_ == 2) {
            this.fallAnimationTick = this.fallAnimationLength;
        } else if (p_28844_ == 3) {
            this.landAnimationTick = this.landAnimationLength;
        } else if (p_28844_ == 4) {
            this.falling = true;
        } else if (p_28844_ == 5) {
            for (int i = 0; i < 50; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.3;
                double d1 = this.field_70146_Z.nextGaussian() * 0.2;
                double d2 = this.field_70146_Z.nextGaussian() * 0.3;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), d0, d1, d2);
            }
        } else if (p_28844_ == 6) {
            this.hasFormed = true;
        } else if (p_28844_ == 7) {
            this.target = null;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public static void spawn(Entity summoningEntity, LivingEntity target) {
        IceCloudEntity iceChunk = (IceCloudEntity)((EntityType)ModEntityTypes.ICE_CLOUD.get()).func_200721_a(summoningEntity.field_70170_p);
        iceChunk.func_225653_b_(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_213302_cg() + 3.0, target.func_226281_cx_());
        iceChunk.target = target;
        iceChunk.owner = summoningEntity;
        iceChunk.func_184185_a((SoundEvent)ModSoundEvents.ICE_CHUNK_SUMMONED.get(), 1.0f, iceChunk.getRandomPitch());
        summoningEntity.field_70170_p.func_217376_c((Entity)iceChunk);
    }

    public void moveToTarget() {
        if (this.target != null && !this.target.func_233643_dh_() && this.distanceToIgnoringY((Entity)this.target) > 1.0f) {
            this.func_213293_j(0.0, 0.0, 0.0);
            double x = this.target.func_226277_ct_() - this.func_226277_ct_();
            double y = this.target.func_226278_cu_() + (double)this.target.func_213302_cg() + 3.0 - this.func_226278_cu_();
            double z = this.target.func_226281_cx_() - this.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.func_213317_d(this.func_213322_ci().func_72441_c(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).func_186678_a(1.0));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    public float distanceToIgnoringY(Entity p_70032_1_) {
        float f = (float)(this.func_226277_ct_() - p_70032_1_.func_226277_ct_());
        float f2 = (float)(this.func_226281_cx_() - p_70032_1_.func_226281_cx_());
        return MathHelper.func_76129_c((float)(f * f + f2 * f2));
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        if (this.field_70170_p.field_72995_K && this.landAnimationTick <= 0) {
            if (this.hasFormed) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.SNOWFLAKE.get(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.SNOWFLAKE.get(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), -(this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.field_70146_Z.nextDouble(), -(this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            }
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::canHitEntity);
        boolean flag = false;
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
                flag = true;
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                    ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                }
                flag = true;
            }
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        this.func_145775_I();
        this.tickDownAnimTimers();
        if (this.hasFormed) {
            ++this.soundLoopTick;
            ++this.lifeTime;
        }
        if (this.soundLoopTick % 80 == 0 && this.hasFormed && !this.falling && this.fallAnimationTick <= 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.ICE_CHUNK_IDLE_LOOP.get(), 0.5f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.target != null && !this.canHitEntity((Entity)this.target)) {
                this.target = null;
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            }
            if (!this.hasFormed && this.formAnimationTick <= 0) {
                this.formAnimationTick = this.formAnimationLength;
                this.field_70170_p.func_72960_a((Entity)this, (byte)1);
            }
            if (this.formAnimationTick == 1) {
                this.func_184185_a((SoundEvent)ModSoundEvents.ICE_CHUNK_IDLE_LOOP.get(), 0.5f, 1.0f);
                this.hasFormed = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            if (this.target != null && this.lifeTime > 100 && this.fallAnimationTick <= 0 && !this.falling || this.target == null || this.target.func_233643_dh_()) {
                this.func_184185_a((SoundEvent)ModSoundEvents.ICE_CHUNK_FALL.get(), 1.0f, this.getRandomPitch());
                this.fallAnimationTick = this.fallAnimationLength;
                this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            }
            if (this.fallAnimationTick == 1) {
                this.falling = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            }
            if (this.landAnimationTick == 1 || this.lifeTime > 150) {
                this.func_70106_y();
            }
        }
        if (this.hasFormed && this.landAnimationTick <= 0 && !this.falling && this.fallAnimationTick <= 0) {
            this.moveToTarget();
        }
        if (this.falling && this.landAnimationTick <= 0) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -1.25, 0.0));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        return !p_230298_1_.func_175149_v() && p_230298_1_.func_70089_S() && p_230298_1_.func_70067_L();
    }

    protected void onHit(RayTraceResult p_70227_1_) {
        RayTraceResult.Type raytraceresult$type = p_70227_1_.func_216346_c();
        if (!this.field_70170_p.field_72995_K && this.landAnimationTick <= 0) {
            this.landAnimationTick = this.landAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.land();
            this.func_225653_b_(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            this.func_184185_a((SoundEvent)ModSoundEvents.ICE_CHUNK_LAND.get(), 1.5f, this.getRandomPitch());
        }
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onHitEntity((EntityRayTraceResult)p_70227_1_);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.onHitBlock((BlockRayTraceResult)p_70227_1_);
        }
    }

    protected void onHitEntity(EntityRayTraceResult p_213868_1_) {
    }

    protected void onHitBlock(BlockRayTraceResult p_230299_1_) {
    }

    private void land() {
        if (this.func_70089_S()) {
            for (LivingEntity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(2.5), ALIVE)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 2));
                entity.func_70097_a(ModDamageSources.iceChunk(this, this.owner), 15.0f);
                this.strongKnockback((Entity)entity);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        }
    }

    private void strongKnockback(Entity p_213688_1_) {
        p_213688_1_.func_70024_g(this.field_70146_Z.nextGaussian() * 1.0, 0.1, this.field_70146_Z.nextGaussian() * 1.0);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public void tickDownAnimTimers() {
        if (this.formAnimationTick > 0) {
            --this.formAnimationTick;
        }
        if (this.fallAnimationTick > 0) {
            --this.fallAnimationTick;
        }
        if (this.landAnimationTick > 0) {
            --this.landAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.formAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_form", Boolean.valueOf(true)));
        } else if (this.landAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_land", Boolean.valueOf(true)));
        } else if (this.fallAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_fall", Boolean.valueOf(true)));
        } else if (this.hasFormed) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ice_chunk_idle_unformed", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

