/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GeomancerWallEntity
extends ConstructEntity
implements IAnimatable {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public GeomancerWallEntity(World world) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), world);
    }

    public GeomancerWallEntity(EntityType<? extends GeomancerWallEntity> entityType, World world) {
        super(entityType, world);
    }

    public GeomancerWallEntity(World worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        super((EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), worldIn, x, y, z, casterIn, lifeTicksIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 0.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233823_f_, 0.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.getLifeTicks() == 100) {
            this.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_WALL_SPAWN.get(), 1.0f, 1.0f);
        }
        if (this.getLifeTicks() == 40) {
            this.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_WALL_DESPAWN.get(), 1.0f, 1.0f);
        }
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLifeTicks() <= 100) {
            if (this.getLifeTicks() < 40) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_disappear", Boolean.valueOf(false)));
            } else if (this.getLifeTicks() > 75) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_appear", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_pillar_idle", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

