/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class ConstructEntity
extends CreatureEntity {
    public static final DataParameter<Integer> LIFE_TICKS = EntityDataManager.func_187226_a(ConstructEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public Direction directionToFace = null;
    private LivingEntity caster;
    private UUID casterUuid;

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, World worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        this(entityTypeIn, worldIn);
        this.setLifeTicks(lifeTicksIn);
        this.setCaster(casterIn);
        this.func_70107_b(x, y, z);
    }

    public static boolean canVehicleCollide(Entity p_242378_0_, Entity p_242378_1_) {
        return (p_242378_1_.func_241845_aY() || p_242378_1_.func_70104_M()) && !p_242378_0_.func_184223_x(p_242378_1_);
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
    }

    public boolean func_241849_j(Entity p_241849_1_) {
        return ConstructEntity.canVehicleCollide((Entity)this, p_241849_1_);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_ == DamageSource.field_76380_i) {
            return super.func_70097_a(p_70097_1_, p_70097_2_);
        }
        return false;
    }

    public void faceDirection(Direction directionToFace) {
        float rotationAmount = 0.0f;
        if (directionToFace == Direction.NORTH) {
            rotationAmount = 90.0f;
        }
        if (directionToFace == Direction.SOUTH) {
            rotationAmount = -90.0f;
        }
        if (directionToFace == Direction.EAST) {
            rotationAmount = 0.0f;
        }
        if (directionToFace == Direction.WEST) {
            rotationAmount = 180.0f;
        }
        this.field_70177_z = rotationAmount;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setLifeTicks(compound.func_74762_e("LifeTicks"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TICKS);
    }

    public void setLifeTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(LIFE_TICKS, (Object)p_189794_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIFE_TICKS, (Object)0);
    }

    public void handleExistence() {
        this.func_233566_aG_();
    }

    public void handleExpiration() {
        this.func_70106_y();
    }

    public void func_70030_z() {
        if (this.getLifeTicks() > 100) {
            List v = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
            for (Entity entity : v) {
                if (entity == this || !(entity instanceof ConstructEntity)) continue;
                this.func_70106_y();
                break;
            }
        }
        this.setLifeTicks(this.getLifeTicks() - 1);
        if (!this.field_70170_p.func_201670_d() && this.getLifeTicks() <= 0) {
            this.handleExpiration();
        } else {
            this.handleExistence();
        }
    }

    public void spawnAreaDamage() {
        AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.field_70170_p, this.func_213303_ch(), (LivingEntity)this, 2.5f, DamageSource.func_76358_a((LivingEntity)this), 0.0f, 1.25f, 0.25f, 0.25f, 5, false, false, 0.75, 0.25, false, 0, 1);
        this.field_70170_p.func_217376_c((Entity)areaDamage);
    }
}

