/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class AreaDamageEntity
extends Entity {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SIZE_TO_REACH = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GROW_SPEED = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> Y_SIZE = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> PARTICLE_TYPE = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EXTRA_TIME = EntityDataManager.func_187226_a(AreaDamageEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float damage;
    public DamageSource damageSource = DamageSource.field_76377_j;
    public LivingEntity owner;
    public boolean constantDamage;
    public List<Entity> damagedEntities = Lists.newArrayList();
    public boolean friendlyFire;
    public double knockbackAmount;
    public double knockbackAmountY;
    public boolean disableShields;
    public int disableShieldTime;
    public int extraTimeTick;
    public List<AreaDamageEntity> connectedAreaDamages = Lists.newArrayList();

    public AreaDamageEntity(World world) {
        super((EntityType)ModEntityTypes.AREA_DAMAGE.get(), world);
    }

    public AreaDamageEntity(EntityType<? extends AreaDamageEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return EntitySize.func_220314_b((float)this.getSize(), (float)this.getYSize());
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public boolean canEntityBeDamaged(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (this.owner != null && entity == this.owner) {
            return false;
        }
        if (this.owner != null && this.owner.func_184191_r(entity) && !this.friendlyFire) {
            return false;
        }
        if (!this.damagedEntities.isEmpty() && !this.constantDamage && this.damagedEntities.contains(entity)) {
            return false;
        }
        if (!this.connectedAreaDamages.isEmpty()) {
            boolean canConnectedAreaDamagesHarm = true;
            for (AreaDamageEntity areaDamage : this.connectedAreaDamages) {
                if (areaDamage.damagedEntities.isEmpty() || areaDamage.constantDamage || !areaDamage.damagedEntities.contains(entity)) continue;
                canConnectedAreaDamagesHarm = false;
            }
            return canConnectedAreaDamagesHarm;
        }
        return true;
    }

    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            for (int particleAmount = 0; particleAmount < 25; ++particleAmount) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
                BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
                BlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.isAir((IBlockReader)this.field_70170_p, pos)) continue;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < 60; ++i) {
                Vector3d vector3d = this.func_213303_ch();
                double d0 = this.field_70146_Z.nextGaussian() * 15.0;
                double d1 = (double)this.field_70146_Z.nextFloat() * 1.75;
                double d2 = this.field_70146_Z.nextGaussian() * 15.0;
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.DUST.get(), vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, d0, d1, d2);
            }
        } else if (p_70103_1_ == 2) {
            for (int particleAmount = 0; particleAmount < 25; ++particleAmount) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
                BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
                BlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.isAir((IBlockReader)this.field_70170_p, pos)) continue;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < 50; ++i) {
                Vector3d vector3d = this.func_213303_ch();
                double d0 = this.field_70146_Z.nextGaussian() * 0.5;
                double d1 = (double)this.field_70146_Z.nextFloat() * 2.0;
                double d2 = this.field_70146_Z.nextGaussian() * 0.5;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, d0, d1, d2);
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public static AreaDamageEntity spawnAreaDamage(World level, Vector3d pos, LivingEntity owner, float damage, DamageSource damageSource, float size, float sizeToReach, float growSpeed, float ySize, int extraTime, boolean constantDamage, boolean friendlyFire, double knockbackAmount, double knockbackAmountY, boolean disableShields, int disableShieldTime, int particleVariant) {
        AreaDamageEntity areaDamage = (AreaDamageEntity)((EntityType)ModEntityTypes.AREA_DAMAGE.get()).func_200721_a(level);
        areaDamage.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        areaDamage.owner = owner;
        areaDamage.damage = damage;
        areaDamage.damageSource = damageSource;
        areaDamage.setSize(size);
        areaDamage.setSizeToReach(sizeToReach);
        areaDamage.setGrowSpeed(growSpeed);
        areaDamage.setYSize(ySize);
        areaDamage.constantDamage = constantDamage;
        areaDamage.friendlyFire = friendlyFire;
        areaDamage.knockbackAmount = knockbackAmount;
        areaDamage.knockbackAmountY = knockbackAmountY;
        areaDamage.disableShields = disableShields;
        areaDamage.disableShieldTime = disableShieldTime;
        areaDamage.setParticleType(particleVariant);
        areaDamage.setExtraTime(extraTime);
        return areaDamage;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.func_213323_x_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (this.field_70170_p.field_72995_K || !this.canEntityBeDamaged(entity)) continue;
                entity.func_70097_a(this.damageSource, this.damage);
                if ((double)this.func_70032_d(entity) >= 0.5) {
                    double d0 = entity.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = entity.func_226281_cx_() - this.func_226281_cx_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    entity.func_70024_g(d0 / d2 * this.knockbackAmount, this.knockbackAmountY, d1 / d2 * this.knockbackAmount);
                }
                if (entity instanceof LivingEntity && this.disableShields) {
                    this.disableShield((LivingEntity)entity, this.disableShieldTime);
                }
                this.damagedEntities.add(entity);
            }
        }
        if (this.getParticleType() > 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)this.getParticleType());
            this.setParticleType(0);
        }
        if (this.getSize() < this.getSizeToReach()) {
            this.setSize(this.getSize() + this.getGrowSpeed());
        }
        if (this.getSize() >= this.getSizeToReach()) {
            ++this.extraTimeTick;
        }
        if (!this.field_70170_p.field_72995_K && (this.getExtraTime() > 0 && this.extraTimeTick >= this.getExtraTime() || this.getExtraTime() <= 0 && this.getSize() >= this.getSizeToReach())) {
            this.func_70106_y();
        }
    }

    public void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof PlayerEntity && livingEntity.func_184585_cz()) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184586_b(livingEntity.func_184600_cs()).func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SIZE_TO_REACH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(Y_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(GROW_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARTICLE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(EXTRA_TIME, (Object)0);
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setSize(float attached) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(attached));
    }

    public float getSizeToReach() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_TO_REACH)).floatValue();
    }

    public void setSizeToReach(float attached) {
        this.field_70180_af.func_187227_b(SIZE_TO_REACH, (Object)Float.valueOf(attached));
    }

    public float getYSize() {
        return ((Float)this.field_70180_af.func_187225_a(Y_SIZE)).floatValue();
    }

    public void setYSize(float attached) {
        this.field_70180_af.func_187227_b(Y_SIZE, (Object)Float.valueOf(attached));
    }

    public float getGrowSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(GROW_SPEED)).floatValue();
    }

    public void setGrowSpeed(float attached) {
        this.field_70180_af.func_187227_b(GROW_SPEED, (Object)Float.valueOf(attached));
    }

    public int getParticleType() {
        return (Integer)this.field_70180_af.func_187225_a(PARTICLE_TYPE);
    }

    public void setParticleType(int attached) {
        this.field_70180_af.func_187227_b(PARTICLE_TYPE, (Object)attached);
    }

    public int getExtraTime() {
        return (Integer)this.field_70180_af.func_187225_a(EXTRA_TIME);
    }

    public void setExtraTime(int attached) {
        this.field_70180_af.func_187227_b(EXTRA_TIME, (Object)attached);
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.setSize(p_70037_1_.func_74760_g("Size"));
        this.setSizeToReach(p_70037_1_.func_74760_g("SizeToReach"));
        this.setYSize(p_70037_1_.func_74760_g("YSize"));
        this.setGrowSpeed(p_70037_1_.func_74760_g("GrowSpeed"));
        this.setParticleType(p_70037_1_.func_74762_e("ParticleType"));
        this.setExtraTime(p_70037_1_.func_74762_e("ExtraTime"));
        this.damage = p_70037_1_.func_74760_g("Damage");
        this.constantDamage = p_70037_1_.func_74767_n("ConstantDamage");
        this.knockbackAmount = p_70037_1_.func_74769_h("KnockbackAmount");
        this.knockbackAmountY = p_70037_1_.func_74769_h("KnockbackAmountY");
        this.disableShieldTime = p_70037_1_.func_74762_e("DisableShieldTime");
        this.disableShields = p_70037_1_.func_74767_n("DisableShields");
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74776_a("Size", this.getSize());
        p_213281_1_.func_74776_a("SizeToReach", this.getSizeToReach());
        p_213281_1_.func_74776_a("YSize", this.getYSize());
        p_213281_1_.func_74776_a("GrowSpeed", this.getGrowSpeed());
        p_213281_1_.func_74768_a("ParticleType", this.getParticleType());
        p_213281_1_.func_74776_a("Damage", this.damage);
        p_213281_1_.func_74757_a("ConstantDamage", this.constantDamage);
        p_213281_1_.func_74780_a("KnockbackAmount", this.knockbackAmount);
        p_213281_1_.func_74780_a("KnockbackAmountY", this.knockbackAmountY);
        p_213281_1_.func_74768_a("DisableShieldTime", this.disableShieldTime);
        p_213281_1_.func_74757_a("DisableShields", this.disableShields);
        p_213281_1_.func_74768_a("ExtraTime", this.getExtraTime());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

