/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.infamous.dungeons_mobs.interfaces.ITrapsTarget;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractTrapEntity
extends Entity
implements IAnimatable {
    public int spawnAnimationTick = this.getSpawnAnimationLength();
    public int decayAnimationTick;
    public int lifeTime;
    public Entity owner;
    public boolean isTrappingMob;
    public List<Entity> trappedEntities = Lists.newArrayList();
    public List<Vector3d> trappedEntityPositions = Lists.newArrayList();

    public AbstractTrapEntity(EntityType<? extends AbstractTrapEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        this.increaseLifeTime();
        this.performBasicTrapFunctions();
    }

    public void increaseLifeTime() {
        ++this.lifeTime;
        if (!this.field_70170_p.field_72995_K) {
            if (this.lifeTime == this.timeToDecay()) {
                this.decayAnimationTick = this.getDecayAnimationLength();
                this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            }
            if (this.decayAnimationTick == 2) {
                this.func_70106_y();
            }
        }
    }

    public void performBasicTrapFunctions() {
        if (!this.field_70170_p.field_72995_K) {
            List list;
            boolean isTrapping = false;
            if (this.canTrap() && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null)).isEmpty()) {
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity) || !this.canTrapEntity((LivingEntity)entity)) continue;
                    if (!this.trappedEntities.contains(entity)) {
                        this.trappedEntities.add(entity);
                        this.trappedEntityPositions.add(entity.func_213303_ch());
                    }
                    if (this.owner != null && this.owner instanceof MobEntity && ((MobEntity)this.owner).func_70638_az() != null && ((MobEntity)this.owner).func_70638_az().func_70089_S() && ((MobEntity)this.owner).func_70638_az() == entity && this.owner instanceof ITrapsTarget) {
                        ((ITrapsTarget)this.owner).setTargetTrapped(true, true);
                    }
                    isTrapping = true;
                }
            }
            for (Entity entity : this.trappedEntities) {
                int entityIndex = this.trappedEntities.indexOf(entity);
                Vector3d entityTrappedPosition = this.trappedEntityPositions.get(entityIndex);
                entity.field_70143_R = 0.0f;
                if (!((double)this.distanceBetweenVector3ds(entity.func_213303_ch(), entityTrappedPosition) > 0.1)) continue;
                entity.func_70634_a(entityTrappedPosition.field_72450_a, entityTrappedPosition.field_72448_b, entityTrappedPosition.field_72449_c);
            }
            this.isTrappingMob = isTrapping;
        }
    }

    public float distanceBetweenVector3ds(Vector3d position, Vector3d positionToGetDistanceTo) {
        float f = (float)(position.field_72450_a - positionToGetDistanceTo.field_72450_a);
        float f1 = (float)(position.field_72448_b - positionToGetDistanceTo.field_72448_b);
        float f2 = (float)(position.field_72449_c - positionToGetDistanceTo.field_72449_c);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void tickDownAnimTimers() {
        if (this.spawnAnimationTick > 0) {
            --this.spawnAnimationTick;
        }
        if (this.decayAnimationTick > 0) {
            --this.decayAnimationTick;
        }
    }

    public abstract int getSpawnAnimationLength();

    public abstract int getDecayAnimationLength();

    public int timeToDecay() {
        return 80;
    }

    public boolean canTrap() {
        return this.spawnAnimationTick <= 0;
    }

    public boolean canTrapEntity(LivingEntity entity) {
        return !entity.func_175149_v();
    }

    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 1) {
            this.spawnAnimationTick = this.getSpawnAnimationLength();
        } else if (p_70103_1_ == 2) {
            this.decayAnimationTick = this.getDecayAnimationLength();
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

