/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RedstoneMineEntity
extends Entity
implements IAnimatable {
    public static final DataParameter<Integer> LIFE_TICKS = EntityDataManager.func_187226_a(ConstructEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity caster;
    private UUID casterUuid;
    private float explosionRadius = 1.0f;
    public static final int LIFE_TIME = 250;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public RedstoneMineEntity(World worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_MINE.get(), worldIn);
    }

    public RedstoneMineEntity(EntityType<? extends RedstoneMineEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public RedstoneMineEntity(World worldIn, double x, double y, double z, int delay, LivingEntity casterIn) {
        this((EntityType<? extends RedstoneMineEntity>)((EntityType)ModEntityTypes.REDSTONE_MINE.get()), worldIn);
        this.setLifeTicks(delay);
        this.setCaster(casterIn);
        this.func_70107_b(x, y, z);
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getLifeTicks() == 6) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.deactive", Boolean.valueOf(true)));
        }
        if (this.getLifeTicks() == 250) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.activate", Boolean.valueOf(true)));
        }
        if (this.getLifeTicks() < 247 && this.getLifeTicks() > 4) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_mine.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void setCaster(@Nullable LivingEntity livingEntity) {
        this.caster = livingEntity;
        this.casterUuid = livingEntity == null ? null : livingEntity.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected float getRandomPitch() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.REDSTONE_SPARK.get(), this.func_226282_d_(1.1), this.func_226279_cv_(), this.func_226287_g_(1.1), -0.05 + this.field_70146_Z.nextDouble() * 0.05, -0.05 + this.field_70146_Z.nextDouble() * 0.05, -0.05 + this.field_70146_Z.nextDouble() * 0.05);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(20) == 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SPARK.get(), 0.1f, this.getRandomPitch());
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
        this.setLifeTicks(this.getLifeTicks() - 1);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getLifeTicks() <= 0) {
                this.func_70106_y();
            } else if (this.getLifeTicks() < 247 && this.getLifeTicks() > 6) {
                for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.3, 0.3, 0.3))) {
                    this.explode(livingentity);
                }
            }
        }
    }

    private void explode(LivingEntity livingentity) {
        LivingEntity Caster = this.getCaster();
        if (livingentity.func_70089_S() && !livingentity.func_190530_aW()) {
            if (Caster != null) {
                if (!Caster.func_184191_r((Entity)livingentity) || livingentity != Caster) {
                    this.field_70170_p.func_217385_a((Entity)Caster, this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), this.explosionRadius, Explosion.Mode.NONE);
                    this.func_70106_y();
                }
            } else {
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), this.explosionRadius, Explosion.Mode.NONE);
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE_TICKS, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLifeTicks(compound.func_74762_e("LifeTicks"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE_TICKS);
    }

    public void setLifeTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(LIFE_TICKS, (Object)p_189794_1_);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

