/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneMineEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RedstoneGolemEntity
extends AbstractRaiderEntity
implements IAnimatable {
    private int attackTimer;
    private int mineAttackCooldown;
    private int attackID;
    public static final byte MELEE_ATTACK = 1;
    public static final byte MINE_ATTACK = 2;
    private static final DataParameter<Boolean> SUMMONING_MINES = EntityDataManager.func_187226_a(RedstoneGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELEEATTACKING = EntityDataManager.func_187226_a(RedstoneGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int soundLoopTick;

    public RedstoneGolemEntity(World worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_GOLEM.get(), worldIn);
    }

    public RedstoneGolemEntity(EntityType<? extends RedstoneGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.25f;
        this.field_70728_aV = 40;
        this.mineAttackCooldown = 200;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONING_MINES, (Object)false);
        this.field_70180_af.func_187214_a(MELEEATTACKING, (Object)false);
    }

    public boolean isSummoningMines() {
        return (Boolean)this.field_70180_af.func_187225_a(SUMMONING_MINES);
    }

    public void setSummoningMines(boolean summoningMines) {
        this.field_70180_af.func_187227_b(SUMMONING_MINES, (Object)summoningMines);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(MELEEATTACKING);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(MELEEATTACKING, (Object)attacking);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        Vector3d velocity = this.func_213322_ci();
        float groundSpeed = MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
        if (this.isSummoningMines()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.summon", Boolean.valueOf(false)));
        } else if (this.isMeleeAttacking()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.attack", Boolean.valueOf(false)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)(groundSpeed * 10.0f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.redstone_golem.general", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackGoal((CreatureEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonRedstoneMinesGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_IDLE.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.REDSTONE_GOLEM_DEATH.get();
    }

    public void func_70030_z() {
        super.func_70030_z();
        ++this.soundLoopTick;
        if (this.soundLoopTick % 30 == 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_IDLE_PULSE_LOOP.get(), 0.75f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(100) == 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SPARK.get(), 0.25f, this.func_70647_i());
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackID != 0) {
            ++this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.mineAttackCooldown > 0) {
            --this.mineAttackCooldown;
        }
        this.handleLeafCollision();
        this.handleSteppingOnBlocks();
    }

    private void handleSteppingOnBlocks() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (RedstoneGolemEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    private void handleLeafCollision() {
        if (this.func_70089_S() && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean destroyedLeafBlock = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block instanceof LeavesBlock)) continue;
                destroyedLeafBlock = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || destroyedLeafBlock;
            }
            if (!destroyedLeafBlock && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 16.0).func_233815_a_(Attributes.field_233824_g_, 3.0).func_233815_a_(Attributes.field_233819_b_, 25.0);
    }

    private float getAttackKnockback() {
        return (float)this.func_233637_b_(Attributes.field_233824_g_);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        BlockPos golemPos = this.func_233580_cy_();
        BlockPos posBeneathGolem = golemPos.func_177977_b();
        BlockState blockstateBeneathGolem = worldIn.func_180495_p(posBeneathGolem);
        if (!blockstateBeneathGolem.func_235719_a_((IBlockReader)worldIn, posBeneathGolem, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            BlockState blockstateAboveGolem;
            BlockPos posAboveGolem = golemPos.func_177981_b(i);
            if (WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)posAboveGolem, (BlockState)(blockstateAboveGolem = worldIn.func_180495_p(posAboveGolem)), (FluidState)blockstateAboveGolem.func_204520_s(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get()))) continue;
            return false;
        }
        return WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)golemPos, (BlockState)worldIn.func_180495_p(golemPos), (FluidState)Fluids.field_204541_a.func_207188_f(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get())) && worldIn.func_226668_i_((Entity)this);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTimer = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)(-id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTimer = 0;
        } else if (id == 4) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.REDSTONE_SPARK.get(), this.func_226282_d_(1.1), this.func_226279_cv_(), this.func_226287_g_(1.1), -0.15 + this.field_70146_Z.nextDouble() * 0.15, -0.15 + this.field_70146_Z.nextDouble() * 0.15, -0.15 + this.field_70146_Z.nextDouble() * 0.15);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.875f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)this, worldIn);
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_226143_fP_;
    }

    public boolean func_213637_dY() {
        return false;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_ || entityIn instanceof AbstractRaiderEntity) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    private boolean canSummonMines() {
        return this.mineAttackCooldown <= 0 && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_233570_aj_() && this.attackID == 0;
    }

    private void createSpellEntity(double x, double z, double minY, double maxY, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            this.field_70170_p.func_217376_c((Entity)new RedstoneMineEntity(this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, delay, (LivingEntity)this));
        }
    }

    class SummonRedstoneMinesGoal
    extends Goal {
        static final int MINE_ATTACK_COOLDOWN = 200;

        SummonRedstoneMinesGoal() {
        }

        public boolean func_75250_a() {
            return RedstoneGolemEntity.this.canSummonMines();
        }

        public boolean func_75253_b() {
            return RedstoneGolemEntity.this.attackTimer < 100;
        }

        public void func_75249_e() {
            RedstoneGolemEntity.this.setSummoningMines(true);
            RedstoneGolemEntity.this.setAttackID(2);
            RedstoneGolemEntity.this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_SUMMON_MINES.get(), 1.5f, 1.0f);
        }

        public void func_75246_d() {
            RedstoneGolemEntity.this.func_70661_as().func_75499_g();
            if (RedstoneGolemEntity.this.attackTimer == 12) {
                BlockPos centerPos = RedstoneGolemEntity.this.func_233580_cy_();
                for (int i = 0; i < 14; ++i) {
                    double randomNearbyX = (double)centerPos.func_177958_n() + RedstoneGolemEntity.this.field_70146_Z.nextGaussian() * 10.0;
                    double randomNearbyZ = (double)centerPos.func_177952_p() + RedstoneGolemEntity.this.field_70146_Z.nextGaussian() * 10.0;
                    int j = 250 + 4 * i;
                    BlockPos randomBlockPos = new BlockPos(randomNearbyX, (double)centerPos.func_177956_o(), randomNearbyZ);
                    RedstoneGolemEntity.this.createSpellEntity(randomBlockPos.func_177958_n(), randomBlockPos.func_177952_p(), randomBlockPos.func_177956_o(), randomBlockPos.func_177956_o() + 1, j);
                }
            }
        }

        public void func_75251_c() {
            RedstoneGolemEntity.this.setAttackID(0);
            RedstoneGolemEntity.this.mineAttackCooldown = 200;
            RedstoneGolemEntity.this.setSummoningMines(false);
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return RedstoneGolemEntity.this.func_70638_az() != null && RedstoneGolemEntity.this.attackID == 1;
        }

        public boolean func_75253_b() {
            return RedstoneGolemEntity.this.attackTimer < 15;
        }

        public void func_75249_e() {
            RedstoneGolemEntity.this.setAttackID(1);
            RedstoneGolemEntity.this.setMeleeAttacking(true);
        }

        public void func_75246_d() {
            if (RedstoneGolemEntity.this.func_70638_az() != null && RedstoneGolemEntity.this.func_70638_az().func_70089_S()) {
                RedstoneGolemEntity.this.func_70671_ap().func_75651_a((Entity)RedstoneGolemEntity.this.func_70638_az(), 30.0f, 30.0f);
                if (RedstoneGolemEntity.this.attackTimer == 8) {
                    RedstoneGolemEntity.this.func_184185_a((SoundEvent)ModSoundEvents.REDSTONE_GOLEM_ATTACK.get(), 1.0f, 1.0f);
                }
                if (RedstoneGolemEntity.this.attackTimer == 9) {
                    float attackKnockback = RedstoneGolemEntity.this.getAttackKnockback();
                    LivingEntity attackTarget = RedstoneGolemEntity.this.func_70638_az();
                    double ratioX = MathHelper.func_76126_a((float)(RedstoneGolemEntity.this.field_70177_z * ((float)Math.PI / 180)));
                    double ratioZ = -MathHelper.func_76134_b((float)(RedstoneGolemEntity.this.field_70177_z * ((float)Math.PI / 180)));
                    double knockbackReduction = 0.5;
                    attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)RedstoneGolemEntity.this), (float)RedstoneGolemEntity.this.func_233637_b_(Attributes.field_233823_f_));
                    this.forceKnockback(attackTarget, attackKnockback * 0.5f, ratioX, ratioZ, knockbackReduction);
                    RedstoneGolemEntity.this.func_213317_d(RedstoneGolemEntity.this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                }
            }
        }

        private void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
            if (event.isCanceled()) {
                return;
            }
            strength = event.getStrength();
            ratioX = event.getRatioX();
            ratioZ = event.getRatioZ();
            if (!((strength = (float)((double)strength * (1.0 - attackTarget.func_233637_b_(Attributes.field_233820_c_) * knockbackResistanceReduction))) <= 0.0f)) {
                attackTarget.field_70160_al = true;
                Vector3d vector3d = attackTarget.func_213322_ci();
                Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)strength);
                attackTarget.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, attackTarget.func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)strength) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
            }
        }

        public void func_75251_c() {
            RedstoneGolemEntity.this.setMeleeAttacking(false);
            RedstoneGolemEntity.this.setAttackID(0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private int maxAttackTimer;
        private final double moveSpeed;
        private int delayCounter;
        private int attackTimer;

        public AttackGoal(CreatureEntity creatureEntity, double moveSpeed) {
            super(creatureEntity, moveSpeed, true);
            this.maxAttackTimer = 20;
            this.moveSpeed = moveSpeed;
        }

        public boolean func_75250_a() {
            return RedstoneGolemEntity.this.func_70638_az() != null && RedstoneGolemEntity.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            RedstoneGolemEntity.this.func_213395_q(true);
            this.delayCounter = 0;
        }

        public void func_75246_d() {
            LivingEntity livingentity = RedstoneGolemEntity.this.func_70638_az();
            if (livingentity == null) {
                return;
            }
            RedstoneGolemEntity.this.field_70749_g.func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            if (--this.delayCounter <= 0) {
                this.delayCounter = 4 + RedstoneGolemEntity.this.func_70681_au().nextInt(7);
                RedstoneGolemEntity.this.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeed);
            }
            this.attackTimer = Math.max(this.attackTimer - 1, 0);
            this.func_190102_a(livingentity, RedstoneGolemEntity.this.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_()));
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            if ((distToEnemySqr <= this.func_179512_a(enemy) || RedstoneGolemEntity.this.func_174813_aQ().func_72326_a(enemy.func_174813_aQ())) && this.attackTimer <= 0) {
                this.attackTimer = this.maxAttackTimer;
                RedstoneGolemEntity.this.func_70652_k((Entity)enemy);
            }
        }

        public void func_75251_c() {
            RedstoneGolemEntity.this.func_70661_as().func_75499_g();
            if (RedstoneGolemEntity.this.func_70638_az() == null) {
                RedstoneGolemEntity.this.func_213395_q(false);
            }
        }

        public AttackGoal setMaxAttackTick(int max) {
            this.maxAttackTimer = max;
            return this;
        }
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        protected PathNodeType func_215744_a(IBlockReader blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, PathNodeType pathNodeType) {
            return pathNodeType == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity mobEntity, World world) {
            super(mobEntity, world);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }
    }
}

