/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class StraightMovingProjectileEntity
extends ProjectileEntity {
    public double xPower;
    public double yPower;
    public double zPower;
    public boolean stuckInBlock;
    private final Predicate<Entity> CAN_HIT = entity -> this.func_230298_a_((Entity)entity);
    public int lifeTime;
    public float lockedXRot;
    public float lockedYRot;

    protected StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50173_1_, World p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50174_1_, double p_i50174_2_, double p_i50174_4_, double p_i50174_6_, double p_i50174_8_, double p_i50174_10_, double p_i50174_12_, World p_i50174_14_) {
        this(p_i50174_1_, p_i50174_14_);
        this.func_70012_b(p_i50174_2_, p_i50174_4_, p_i50174_6_, this.field_70177_z, this.field_70125_A);
        this.func_226264_Z_();
        double d0 = MathHelper.func_76133_a((double)(p_i50174_8_ * p_i50174_8_ + p_i50174_10_ * p_i50174_10_ + p_i50174_12_ * p_i50174_12_));
        if (d0 != 0.0) {
            this.xPower = p_i50174_8_ / d0 * 0.1;
            this.yPower = p_i50174_10_ / d0 * 0.1;
            this.zPower = p_i50174_12_ / d0 * 0.1;
        }
    }

    public StraightMovingProjectileEntity(EntityType<? extends StraightMovingProjectileEntity> p_i50175_1_, LivingEntity p_i50175_2_, double p_i50175_3_, double p_i50175_5_, double p_i50175_7_, World p_i50175_9_) {
        this(p_i50175_1_, p_i50175_2_.func_226277_ct_(), p_i50175_2_.func_226278_cu_(), p_i50175_2_.func_226281_cx_(), p_i50175_3_, p_i50175_5_, p_i50175_7_, p_i50175_9_);
        this.func_212361_a((Entity)p_i50175_2_);
        this.func_70101_b(p_i50175_2_.field_70177_z, p_i50175_2_.field_70125_A);
    }

    protected void func_70088_a() {
    }

    public void setPower(double powerX, double powerY, double powerZ) {
        double d0 = MathHelper.func_76133_a((double)(powerX * powerX + powerY * powerY + powerZ * powerZ));
        if (d0 != 0.0) {
            this.xPower = powerX / d0 * 0.1;
            this.yPower = powerY / d0 * 0.1;
            this.zPower = powerZ / d0 * 0.1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    public void tryToDealDamage() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), this.CAN_HIT);
        if (!list.isEmpty() && !this.field_70170_p.field_72995_K) {
            for (Entity entity : list) {
                this.onHitEntity(entity);
            }
        }
    }

    public void rotateToMatchMovement() {
        this.func_234617_x_();
    }

    public boolean shouldUpdateRotation() {
        return true;
    }

    protected void func_234617_x_() {
        if (this.stuckInBlock) {
            this.field_70125_A = this.lockedXRot;
            this.field_70177_z = this.lockedYRot;
        } else {
            super.func_234617_x_();
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.shouldUpdateRotation()) {
            this.func_234617_x_();
        }
        if (!this.field_70170_p.field_72995_K && this.vanishesAfterTime()) {
            if (this.lifeTime < this.vanishAfterTime() + this.getVanishAnimationLength()) {
                ++this.lifeTime;
            } else {
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.field_72995_K && this.lifeTime < this.vanishAfterTime() + this.getVanishAnimationLength()) {
            ++this.lifeTime;
        }
        this.tryToDealDamage();
    }

    public void func_70071_h_() {
        Entity entity = this.func_234616_v_();
        if (this.stuckInBlock) {
            this.field_70145_X = false;
        }
        if (this.field_70170_p.field_72995_K || (entity == null || !entity.field_70128_L) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            RayTraceResult raytraceresult;
            super.func_70071_h_();
            if (this.shouldBurn()) {
                this.func_70015_d(1);
            }
            if ((raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_)).func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.func_145775_I();
            Vector3d vector3d = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
            float f = this.getInertia();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.getUnderWaterTrailParticle() == null || !this.shouldSpawnParticles()) continue;
                    this.spawnUnderWaterTrailParticle();
                }
                if (this.slowedDownInWater()) {
                    f = 0.8f;
                }
            }
            this.func_213317_d(vector3d.func_72441_c(this.xPower, this.yPower, this.zPower).func_186678_a((double)f));
            if (this.getTrailParticle() != null && this.shouldSpawnParticles()) {
                this.spawnTrailParticle();
            }
            this.func_70107_b(d0, d1, d2);
        } else {
            this.func_70106_y();
        }
    }

    public boolean vanishesAfterTime() {
        return true;
    }

    public int vanishAfterTime() {
        return 200;
    }

    public int getVanishAnimationLength() {
        return 0;
    }

    public void onHitEntity(Entity entity) {
        this.playImpactSound();
    }

    public boolean getsStuckInBlocks() {
        return false;
    }

    public boolean keepsHittingAfterStuck() {
        return false;
    }

    public abstract SoundEvent getImpactSound();

    public void playImpactSound() {
        if (this.getImpactSound() != null) {
            this.func_184185_a(this.getImpactSound(), 1.0f, 1.0f);
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        if (!this.stuckInBlock) {
            this.playImpactSound();
        }
        if (!this.getsStuckInBlocks()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.lockedXRot = this.field_70125_A;
            this.lockedYRot = this.field_70177_z;
            this.stuckInBlock = true;
            this.setPower(0.0, 0.0, 0.0);
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    public boolean slowedDownInWater() {
        return true;
    }

    public void spawnTrailParticle() {
        this.field_70170_p.func_195594_a(this.getTrailParticle(), this.func_226277_ct_(), this.func_226278_cu_() + this.getSpawnParticlesY(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    public void spawnUnderWaterTrailParticle() {
        this.field_70170_p.func_195594_a(this.getUnderWaterTrailParticle(), this.func_226277_ct_(), this.func_226278_cu_() + this.getSpawnParticlesY(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    public double getSpawnParticlesY() {
        return 0.5;
    }

    public boolean shouldSpawnParticles() {
        return true;
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        boolean foundOwnerPartInEntity = false;
        if (this.func_234616_v_() != null && this.func_234616_v_().isMultipartEntity()) {
            for (PartEntity entity : this.func_234616_v_().getParts()) {
                if (p_230298_1_ != entity) continue;
                foundOwnerPartInEntity = true;
            }
        }
        return super.func_230298_a_(p_230298_1_) && (this.keepsHittingAfterStuck() && this.stuckInBlock || !this.stuckInBlock) && !p_230298_1_.field_70145_X && !foundOwnerPartInEntity;
    }

    protected boolean shouldBurn() {
        return true;
    }

    protected IParticleData getTrailParticle() {
        return ParticleTypes.field_197601_L;
    }

    protected IParticleData getUnderWaterTrailParticle() {
        return ParticleTypes.field_197612_e;
    }

    protected float getInertia() {
        return 0.95f;
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_218657_a("power", (INBT)this.func_70087_a(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        ListNBT listnbt;
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("power", 9) && (listnbt = p_70037_1_.func_150295_c("power", 6)).size() == 3) {
            this.xPower = listnbt.func_150309_d(0);
            this.yPower = listnbt.func_150309_d(1);
            this.zPower = listnbt.func_150309_d(2);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        this.func_70018_K();
        Entity entity = p_70097_1_.func_76346_g();
        if (entity != null) {
            Vector3d vector3d = entity.func_70040_Z();
            this.func_213317_d(vector3d);
            this.xPower = vector3d.field_72450_a * 0.1;
            this.yPower = vector3d.field_72448_b * 0.1;
            this.zPower = vector3d.field_72449_c * 0.1;
            this.func_212361_a(entity);
            return true;
        }
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

