/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.projectiles.StraightMovingProjectileEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class NecromancerOrbEntity
extends StraightMovingProjectileEntity
implements IAnimatable {
    private static final DataParameter<Boolean> DELAYED_FORM = EntityDataManager.func_187226_a(NecromancerOrbEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int formAnimationTick;
    public int formAnimationLength = 20;
    public int vanishAnimationTick;
    public int textureChange = 0;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public NecromancerOrbEntity(World worldIn) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), worldIn);
    }

    public NecromancerOrbEntity(EntityType<? extends NecromancerOrbEntity> p_i50147_1_, World p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
    }

    public NecromancerOrbEntity(World p_i1794_1_, LivingEntity p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_, p_i1794_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public NecromancerOrbEntity(World p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super((EntityType<? extends StraightMovingProjectileEntity>)((EntityType)ModEntityTypes.NECROMANCER_ORB.get()), p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 1) {
            this.vanishAnimationTick = this.getVanishAnimationLength();
        } else if (p_28844_ == 2) {
            this.formAnimationTick = this.formAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    @Override
    protected IParticleData getTrailParticle() {
        return (IParticleData)ModParticleTypes.NECROMANCY.get();
    }

    @Override
    public double getSpawnParticlesY() {
        return 0.2;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return this.vanishAnimationTick <= 0;
    }

    @Override
    protected float getInertia() {
        return 0.8f;
    }

    public void startForming() {
        if (!this.field_70170_p.field_72995_K) {
            this.formAnimationTick = this.formAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)2);
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.field_70173_aa % 5 == 0) {
            ++this.textureChange;
        }
        if (!this.field_70170_p.field_72995_K && this.lifeTime >= this.vanishAfterTime() && this.vanishAnimationTick <= 0) {
            this.vanishAnimationTick = this.getVanishAnimationLength();
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
        if (!this.field_70170_p.field_72995_K && this.hasDelayedForm()) {
            this.startForming();
            this.setDelayedForm(false);
        }
        if (!this.field_70170_p.field_72995_K && this.vanishAnimationTick > 0) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.vanishAnimationTick == 2) {
            this.func_70106_y();
        }
    }

    public void tickDownAnimTimers() {
        if (this.formAnimationTick > 0) {
            --this.formAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_vanish", Boolean.valueOf(true)));
        } else if (this.formAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_form", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("necromancer_orb_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DELAYED_FORM, (Object)false);
    }

    public boolean hasDelayedForm() {
        return (Boolean)this.field_70180_af.func_187225_a(DELAYED_FORM);
    }

    public void setDelayedForm(boolean attached) {
        this.field_70180_af.func_187227_b(DELAYED_FORM, (Object)attached);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_70027_ad() {
        return false;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
    }

    @Override
    public void onHitEntity(Entity entity) {
        if (!(entity instanceof MobEntity && ((MobEntity)entity).func_70668_bt() == CreatureAttribute.field_223223_b_ || this.field_70170_p.field_72995_K)) {
            super.onHitEntity(entity);
            Entity entity1 = this.func_234616_v_();
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                boolean flag = entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)livingentity), 6.0f);
                if (flag && entity.func_70089_S()) {
                    this.func_174815_a(livingentity, entity);
                }
            } else {
                boolean flag = entity.func_70097_a(DamageSource.field_76376_m, 6.0f);
            }
            entity.func_184208_bv().func_184226_ay();
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(this.func_213322_ci().func_186678_a(2.0)));
            this.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_ORB_IMPACT.get(), 1.0f, 1.0f);
            this.vanishAnimationTick = this.getVanishAnimationLength();
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public SoundEvent getImpactSound() {
        return (SoundEvent)ModSoundEvents.NECROMANCER_ORB_IMPACT.get();
    }

    @Override
    public int getVanishAnimationLength() {
        return 40;
    }
}

