/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.summonables.KelpTrapEntity;
import com.infamous.dungeons_mobs.entities.summonables.SimpleTrapEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.AquaticMoveHelperController;
import com.infamous.dungeons_mobs.goals.GoToWaterGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.SwimUpGoal;
import com.infamous.dungeons_mobs.interfaces.IAquaticMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.tags.CustomTags;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WhispererEntity
extends MonsterEntity
implements IAnimatable,
IAquaticMob {
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(WhispererEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int summonQGVAnimationTick;
    public int summonQGVAnimationLength = 40;
    public int summonQGVAnimationActionPoint = 20;
    public int summonPQVAnimationTick;
    public int summonPQVAnimationLength = 70;
    public int summonPQVAnimationActionPoint1 = 53;
    public int summonPQVAnimationActionPoint2 = 30;
    public int grappleAnimationTick;
    public int grappleAnimationLength = 65;
    public int grappleAnimationActionPoint = 23;
    public int underwaterGrappleAnimationActionPoint = 20;
    public int attackAnimationTick;
    public int attackAnimationLength = 30;
    public int attackAnimationActionPoint = 18;
    public int underwaterAttackAnimationActionPoint = 16;
    protected final SwimmerPathNavigator waterNavigation;
    protected final GroundPathNavigator groundNavigation;
    protected final GroundPathNavigator climberNavigation;

    public WhispererEntity(EntityType<? extends WhispererEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
        if (this.isWavewhisperer()) {
            this.field_70765_h = new AquaticMoveHelperController<WhispererEntity>(this);
            this.func_184644_a(PathNodeType.WATER, 0.0f);
        }
        this.waterNavigation = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigation = new GroundPathNavigator((MobEntity)this, world);
        this.climberNavigation = new ClimberPathNavigator((MobEntity)this, world);
        if (!this.isWavewhisperer()) {
            // empty if block
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        if (this.isWavewhisperer()) {
            this.registerWavewhispererGoals();
        } else {
            this.registerWhispererGoals();
        }
    }

    public void registerWhispererGoals() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BasicAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GrappleGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SummonPQVAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonQGVGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 4.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 4.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new ApproachTargetGoal((CreatureEntity)this, 7.0, 1.1, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public boolean isSpellcasting() {
        return this.summonPQVAnimationTick > 0 || this.summonQGVAnimationTick > 0 || this.grappleAnimationTick > 0;
    }

    public void registerWavewhispererGoals() {
        this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal((CreatureEntity)this, 1.25){

            @Override
            public boolean func_75250_a() {
                if (this.mob.func_70090_H()) {
                    return false;
                }
                Vector3d vector3d = this.getWaterPos();
                if (vector3d == null) {
                    return false;
                }
                this.wantedX = vector3d.field_72450_a;
                this.wantedY = vector3d.field_72448_b;
                this.wantedZ = vector3d.field_72449_c;
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new BasicAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GrappleGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SummonPQVAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonQGVGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 4.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 4.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new ApproachTargetGoal((CreatureEntity)this, 7.0, 1.1, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, new SwimUpGoal<WhispererEntity>(this, 1.2, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isWavewhisperer() && !this.field_70170_p.field_72995_K) {
            this.setClimbing(this.field_70123_F);
        }
        if (this.isClimbing()) {
            this.field_70761_aq = this.field_70759_as;
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_70839_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)b0);
    }

    public boolean func_70617_f_() {
        return !this.isWavewhisperer() && this.isClimbing();
    }

    public boolean isWavewhisperer() {
        return this.func_200600_R() == ModEntityTypes.WAVEWHISPERER.get();
    }

    public boolean isInWrongHabitat() {
        return this.isWavewhisperer() && !this.func_203005_aq();
    }

    protected int func_70682_h(int p_70682_1_) {
        return this.isWavewhisperer() ? p_70682_1_ : super.func_70682_h(p_70682_1_);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233819_b_, 17.5).func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233820_c_, 0.25);
    }

    public void func_70642_aH() {
        SoundEvent soundeventVocal = this.func_184639_G();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_184581_c(DamageSource p_184581_1_) {
        this.field_70757_a = -this.func_70627_aG();
        SoundEvent soundeventVocal = this.func_184601_bQ(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 0.5f, 1.0f);
        this.func_184185_a(this.getStepSoundFoley(), 0.5f, 1.0f);
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.func_174814_R()) {
            if (vocalSound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vocalSound, this.func_184176_by(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), foleySound, this.func_184176_by(), foleyVolume, foleyPitch);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_IDLE.get() : (SoundEvent)ModSoundEvents.WHISPERER_IDLE_VOCAL.get();
    }

    protected SoundEvent getAmbientSoundFoley() {
        return this.isWavewhisperer() ? null : (SoundEvent)ModSoundEvents.WHISPERER_IDLE_FOLEY.get();
    }

    public int func_70627_aG() {
        return 150;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_HURT.get() : (SoundEvent)ModSoundEvents.WHISPERER_HURT_VOCAL.get();
    }

    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return this.isWavewhisperer() ? null : (SoundEvent)ModSoundEvents.WHISPERER_HURT_FOLEY.get();
    }

    protected SoundEvent func_184615_bR() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_DEATH.get() : (SoundEvent)ModSoundEvents.WHISPERER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.WHISPERER_STEP_VOCAL.get();
    }

    protected SoundEvent getStepSoundFoley() {
        return (SoundEvent)ModSoundEvents.WHISPERER_STEP_FOLEY.get();
    }

    protected void func_203006_d(float p_203006_1_) {
        this.func_184185_a(this.func_184184_Z(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    public void func_184185_a(SoundEvent p_184185_1_, float p_184185_2_, float p_184185_3_) {
        if (p_184185_1_ == this.func_184615_bR()) {
            super.func_184185_a(p_184185_1_, p_184185_2_, p_184185_3_ / 2.0f);
            super.func_184185_a((SoundEvent)ModSoundEvents.WHISPERER_STEP_FOLEY.get(), p_184185_2_, p_184185_3_);
            super.func_184185_a((SoundEvent)ModSoundEvents.WHISPERER_HURT_FOLEY.get(), p_184185_2_, p_184185_3_);
        } else {
            super.func_184185_a(p_184185_1_, p_184185_2_, p_184185_3_);
        }
    }

    protected SoundEvent func_184184_Z() {
        return this.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_STEP.get() : null;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (!this.field_70170_p.field_72995_K && this.isInWrongHabitat() && this.field_70146_Z.nextInt(200) == 0) {
            this.func_174812_G();
        }
    }

    public void tickDownAnimTimers() {
        if (this.summonQGVAnimationTick > 0) {
            --this.summonQGVAnimationTick;
        }
        if (this.summonPQVAnimationTick > 0) {
            --this.summonPQVAnimationTick;
        }
        if (this.grappleAnimationTick > 0) {
            --this.grappleAnimationTick;
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.summonQGVAnimationTick = this.summonQGVAnimationLength;
        } else if (p_70103_1_ == 5) {
            this.summonPQVAnimationTick = this.summonPQVAnimationLength;
        } else if (p_70103_1_ == 6) {
            this.grappleAnimationTick = this.grappleAnimationLength;
        } else if (p_70103_1_ == 7) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            if (this.field_241335_O_ == FluidTags.field_206959_a && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_attack", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_attack", Boolean.valueOf(true)));
            }
        } else if (this.summonPQVAnimationTick > 0) {
            if (this.field_241335_O_ == FluidTags.field_206959_a && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_summon_pa", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_summon_pqv", Boolean.valueOf(true)));
            }
        } else if (this.summonQGVAnimationTick > 0) {
            if (this.field_241335_O_ == FluidTags.field_206959_a && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_summon_qgk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_summon_qgv", Boolean.valueOf(true)));
            }
        } else if (this.grappleAnimationTick > 0) {
            if (this.field_241335_O_ == FluidTags.field_206959_a && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_grapple", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_grapple", Boolean.valueOf(true)));
            }
        } else if (this.isClimbing()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_climb", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.field_241335_O_ == FluidTags.field_206959_a && this.isWavewhisperer()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_swim", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_walk", Boolean.valueOf(true)));
            }
        } else if (this.func_70090_H() && this.isWavewhisperer()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("wavewhisperer_idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("whisperer_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (super.func_184191_r(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).func_200600_R().func_220341_a(CustomTags.PLANT_MOBS)) {
            return this.func_96124_cp() == null && p_184191_1_.func_96124_cp() == null;
        }
        return false;
    }

    public boolean func_96092_aw() {
        return this.isWavewhisperer() ? !this.func_203007_ba() : super.func_96092_aw();
    }

    public void func_213352_e(Vector3d travelVec) {
        if (this.isWavewhisperer()) {
            this.checkAquaticTravel((MobEntity)this, travelVec);
        } else {
            this.normalTravel(travelVec);
        }
    }

    @Override
    public void normalTravel(Vector3d travelVec) {
        super.func_213352_e(travelVec);
    }

    public void func_205343_av() {
        if (this.isWavewhisperer()) {
            this.updateNavigation((MobEntity)this);
        } else {
            super.func_205343_av();
        }
    }

    @Override
    public boolean isSearchingForLand() {
        return false;
    }

    @Override
    public void setNavigation(PathNavigator navigation) {
        this.field_70699_by = navigation;
    }

    @Override
    public GroundPathNavigator getGroundNavigation() {
        return this.groundNavigation;
    }

    @Override
    public SwimmerPathNavigator getWaterNavigation() {
        return this.waterNavigation;
    }

    @Override
    public void setSearchingForLand(boolean searchingForLand) {
    }

    @Override
    public <T extends MobEntity> boolean wantsToSwim(T aquaticMob) {
        return this.isWavewhisperer() ? this.func_70638_az() != null : false;
    }

    @Override
    public <T extends LivingEntity> boolean okTarget(T aquaticMob, LivingEntity target) {
        return true;
    }

    public boolean canUseGoals() {
        return this.isWavewhisperer() && this.func_203005_aq() || !this.isWavewhisperer();
    }

    class GrappleGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public GrappleGoal(WhispererEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_70032_d((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.canUseGoals() && this.mob.field_70173_aa >= this.nextUseTime;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.grappleAnimationTick = this.mob.grappleAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)6);
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WHISPERER_GRAPPLE_FOLEY.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            int actionPoint;
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.mob.grappleAnimationTick == this.mob.grappleAnimationLength - 30) {
                this.mob.func_184185_a(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_GRAPPLE.get() : (SoundEvent)ModSoundEvents.WHISPERER_GRAPPLE_VOCAL.get(), 1.25f, 1.0f);
            }
            int n = actionPoint = this.mob.isWavewhisperer() ? this.mob.underwaterGrappleAnimationActionPoint : this.mob.grappleAnimationActionPoint;
            if (this.target != null && this.mob.grappleAnimationTick == actionPoint) {
                if (this.mob.isWavewhisperer()) {
                    KelpTrapEntity trap = (KelpTrapEntity)((EntityType)ModEntityTypes.KELP_TRAP.get()).func_200721_a(this.mob.field_70170_p);
                    trap.func_225653_b_(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
                    PositionUtils.moveToCorrectHeight(trap);
                    trap.owner = this.mob;
                    this.mob.field_70170_p.func_217376_c((Entity)trap);
                } else {
                    SimpleTrapEntity trap = (SimpleTrapEntity)((EntityType)ModEntityTypes.SIMPLE_TRAP.get()).func_200721_a(this.mob.field_70170_p);
                    trap.func_225653_b_(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
                    trap.setTrapType(1);
                    PositionUtils.moveToCorrectHeight(trap);
                    trap.owner = this.mob;
                    this.mob.field_70170_p.func_217376_c((Entity)trap);
                }
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (200 + this.mob.field_70146_Z.nextInt(400));
        }

        public boolean animationsUseable() {
            return this.mob.grappleAnimationTick <= 0;
        }
    }

    class SummonPQVAttackGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public SummonPQVAttackGoal(WhispererEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.canUseGoals() && this.mob.field_70173_aa >= this.nextUseTime;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.summonPQVAnimationTick = this.mob.summonPQVAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)5);
            this.mob.func_184185_a(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_PA_FOLEY.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_PQV_FOLEY.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationLength - 12) {
                this.mob.func_184185_a(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_PA_VOCAL.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_PQV_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationActionPoint1 || this.mob.summonPQVAnimationTick == this.mob.summonPQVAnimationActionPoint2)) {
                boolean movingOnX = this.mob.field_70146_Z.nextBoolean();
                GeomancyHelper.summonOffensiveVine((LivingEntity)this.mob, (LivingEntity)this.mob, (EntityType<? extends AbstractVineEntity>)(this.mob.isWavewhisperer() ? (EntityType)ModEntityTypes.POISON_ANEMONE.get() : (EntityType)ModEntityTypes.POISON_QUILL_VINE.get()), movingOnX ? (this.mob.field_70146_Z.nextBoolean() ? 3 : -3) : 0, !movingOnX ? (this.mob.field_70146_Z.nextBoolean() ? 3 : -3) : 0);
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (350 + this.mob.field_70146_Z.nextInt(150));
        }

        public boolean animationsUseable() {
            return this.mob.summonPQVAnimationTick <= 0;
        }
    }

    class SummonQGVGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public SummonQGVGoal(WhispererEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_70032_d((Entity)this.target) <= 15.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.canUseGoals() && this.mob.field_70173_aa >= this.nextUseTime;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.summonQGVAnimationTick = this.mob.summonQGVAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WHISPERER_SUMMON_QGV_FOLEY.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.mob.summonQGVAnimationTick == this.mob.summonQGVAnimationLength - 5) {
                this.mob.func_184185_a(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_SUMMON_QGK.get() : (SoundEvent)ModSoundEvents.WHISPERER_SUMMON_QGV_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && this.mob.summonQGVAnimationTick == this.mob.summonQGVAnimationActionPoint) {
                int[] rowToRemove = (int[])Util.func_240989_a_((Object[])GeomancyHelper.CONFIG_1_ROWS, (Random)WhispererEntity.this.func_70681_au());
                GeomancyHelper.summonAreaDenialVineTrap((LivingEntity)this.mob, this.target, (EntityType<? extends AbstractVineEntity>)(this.mob.isWavewhisperer() ? (EntityType)ModEntityTypes.QUICK_GROWING_KELP.get() : (EntityType)ModEntityTypes.QUICK_GROWING_VINE.get()), rowToRemove);
            }
        }

        public void func_75251_c() {
            this.nextUseTime = this.mob.field_70173_aa + (150 + this.mob.field_70146_Z.nextInt(50));
        }

        public boolean animationsUseable() {
            return this.mob.summonQGVAnimationTick <= 0;
        }
    }

    class BasicAttackGoal
    extends Goal {
        public WhispererEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(WhispererEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_70032_d((Entity)this.target) <= 3.0f && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.canUseGoals() && this.mob.field_70146_Z.nextInt(20) == 0;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)7);
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WHISPERER_ATTACK_FOLEY.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            int actionPoint;
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            int n = actionPoint = this.mob.isWavewhisperer() ? this.mob.underwaterAttackAnimationActionPoint : this.mob.attackAnimationActionPoint;
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint + 5) {
                this.mob.func_184185_a(this.mob.isWavewhisperer() ? (SoundEvent)ModSoundEvents.WAVEWHISPERER_ATTACK.get() : (SoundEvent)ModSoundEvents.WHISPERER_ATTACK_VOCAL.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (double)this.mob.func_70032_d((Entity)this.target) < 3.5 && this.mob.attackAnimationTick == actionPoint) {
                this.mob.func_70652_k((Entity)this.target);
            }
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }
}

