/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.projectiles.PoisonQuillEntity;
import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PoisonQuillVineEntity
extends AbstractVineEntity {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int delayedBehaviourTime;
    public int shootAnimationTick;
    public int shootAnimationLength = 18;
    public int shootAnimationActionPoint = 8;
    public boolean open;

    public PoisonQuillVineEntity(EntityType<? extends PoisonQuillVineEntity> p_i50147_1_, World p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new CloseGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return this.isOut() ? this.func_213302_cg() - 0.75f : super.func_213348_b(p_213348_1_, p_213348_2_);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController((MobEntity)this);
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233819_b_, 25.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", (float)this.getAnimationTransitionTime(), this::predicate));
    }

    @Override
    public int getAnimationTransitionTime() {
        return 5;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_retract", Boolean.valueOf(true)));
        } else if (this.burstAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_burst", Boolean.valueOf(true)));
        } else if (this.retractAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_retract", Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_shoot", Boolean.valueOf(true)));
        } else if (this.isOut() || this.burstAnimationTick > 0) {
            if (this.open) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle_open", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("poison_quill_vine_idle_underground", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getBurstAnimationLength() {
        return 20;
    }

    @Override
    public int getRetractAnimationLength() {
        return 15;
    }

    @Override
    protected SoundEvent getAmbientSoundFoley() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_IDLE.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_HURT_VOCAL.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_DEATH.get();
    }

    @Override
    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_HURT_FOLEY.get();
    }

    @Override
    public SoundEvent getBurstSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_BURST.get();
    }

    @Override
    public SoundEvent getRetractSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_BURST.get();
    }

    public SoundEvent getShootSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_SHOOT.get();
    }

    public SoundEvent getOpenSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_OPEN.get();
    }

    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSoundEvents.POISON_QUILL_VINE_CLOSE.get();
    }

    @Override
    public SoundEvent getBurstSoundFoley() {
        return null;
    }

    @Override
    public SoundEvent getRetractSoundFoley() {
        return null;
    }

    @Override
    public boolean isKelp() {
        return false;
    }

    @Override
    public boolean shouldDieInWrongHabitat() {
        return true;
    }

    @Override
    public int wrongHabitatDieChance() {
        return 100;
    }

    @Override
    public int getLengthInSegments() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(LENGTH)), (int)2, (int)26);
    }

    @Override
    public void spawnAreaDamage() {
        AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.field_70170_p, this.func_213303_ch(), (LivingEntity)this, 5.0f, DamageSource.func_76358_a((LivingEntity)this), 0.0f, 1.5f, 0.25f, 0.25f, 10, false, false, 0.75, 0.25, false, 0, 1);
        this.field_70170_p.func_217376_c((Entity)areaDamage);
    }

    @Override
    public void setDefaultFeatures() {
        this.setLengthInSegments(2 + this.field_70146_Z.nextInt(3));
        this.setVanishes(false);
        this.setAlwaysOut(false);
        this.setDetectionDistance(7.5f);
    }

    @Override
    public float getExtraHitboxY() {
        return 1.625f;
    }

    @Override
    public void burst() {
        super.burst();
        this.delayedBehaviourTime = 10;
    }

    @Override
    public void retract() {
        super.retract();
        this.delayedBehaviourTime = 20;
    }

    @Override
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 7) {
            this.open = true;
        } else if (p_70103_1_ == 8) {
            this.open = false;
        } else if (p_70103_1_ == 9) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.delayedBehaviourTime > 0) {
            --this.delayedBehaviourTime;
        }
    }

    @Override
    public void tickDownAnimTimers() {
        super.tickDownAnimTimers();
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
    }

    public float func_70032_d(Entity p_70032_1_) {
        float f = (float)(this.func_226277_ct_() - p_70032_1_.func_226277_ct_());
        float f1 = (float)(this.func_226280_cw_() - p_70032_1_.func_226278_cu_());
        float f2 = (float)(this.func_226281_cx_() - p_70032_1_.func_226281_cx_());
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    class ShootAttackGoal
    extends Goal {
        public PoisonQuillVineEntity mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(PoisonQuillVineEntity mob) {
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.mob.open && this.mob.delayedBehaviourTime <= 0 && this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.mob.open && this.mob.delayedBehaviourTime <= 0 && this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                Vector3d pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, this.mob.func_213348_b(this.mob.func_213283_Z(), this.mob.func_213305_a(this.mob.func_213283_Z())), 1.0, PoisonQuillVineEntity.this.field_70759_as);
                double d1 = this.target.func_226277_ct_() - pos.field_72450_a;
                double d2 = this.target.func_226283_e_(0.6) - pos.field_72448_b;
                double d3 = this.target.func_226281_cx_() - pos.field_72449_c;
                PoisonQuillEntity poisonQuill = new PoisonQuillEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1, d2, d3);
                poisonQuill.setKelp(this.mob.isKelp());
                poisonQuill.rotateToMatchMovement();
                poisonQuill.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                this.mob.field_70170_p.func_217376_c((Entity)poisonQuill);
                this.mob.func_184185_a(this.mob.getShootSound(), 1.25f, 1.0f);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class CloseGoal
    extends Goal {
        public boolean func_75250_a() {
            return PoisonQuillVineEntity.this.isOut() && PoisonQuillVineEntity.this.delayedBehaviourTime <= 0 && PoisonQuillVineEntity.this.open && (PoisonQuillVineEntity.this.func_70638_az() == null || (double)PoisonQuillVineEntity.this.func_70032_d((Entity)PoisonQuillVineEntity.this.func_70638_az()) > 17.5);
        }

        public void func_75249_e() {
            super.func_75249_e();
            PoisonQuillVineEntity.this.open = false;
            PoisonQuillVineEntity.this.field_70170_p.func_72960_a((Entity)PoisonQuillVineEntity.this, (byte)8);
            PoisonQuillVineEntity.this.delayedBehaviourTime = 40;
            PoisonQuillVineEntity.this.func_184185_a(PoisonQuillVineEntity.this.getCloseSound(), 1.0f, 1.0f);
        }
    }

    class OpenGoal
    extends Goal {
        public boolean func_75250_a() {
            return PoisonQuillVineEntity.this.isOut() && PoisonQuillVineEntity.this.delayedBehaviourTime <= 0 && PoisonQuillVineEntity.this.func_70638_az() != null && !PoisonQuillVineEntity.this.open && PoisonQuillVineEntity.this.func_70032_d((Entity)PoisonQuillVineEntity.this.func_70638_az()) <= 15.0f;
        }

        public void func_75249_e() {
            super.func_75249_e();
            PoisonQuillVineEntity.this.open = true;
            PoisonQuillVineEntity.this.field_70170_p.func_72960_a((Entity)PoisonQuillVineEntity.this, (byte)7);
            PoisonQuillVineEntity.this.delayedBehaviourTime = 10;
            PoisonQuillVineEntity.this.func_184185_a(PoisonQuillVineEntity.this.getOpenSound(), 1.0f, 1.0f);
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity p_i50612_2_) {
            super(p_i50612_2_);
        }

        public void func_75664_a() {
        }
    }
}

