/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.summonables.AreaDamageEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.tags.CustomTags;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LeapleafEntity
extends MonsterEntity
implements IAnimatable {
    private static final UUID SPEED_MODIFIER_CHARGING_UUID = UUID.fromString("b380d5fd-85cb-4ac3-9450-d9092a09e0c9");
    private static final AttributeModifier SPEED_MODIFIER_CHARGING = new AttributeModifier(SPEED_MODIFIER_CHARGING_UUID, "Charging speed increase", 0.1, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Integer> TIMES_LEAPT = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CAN_LEAP = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEAPING = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int strafeTick;
    public int strafeLength = 40;
    public int restTick;
    public int restLength = 100;
    public int attackAnimationTick;
    public int attackAnimationLength = 30;
    public int attackAnimationActionPoint = 15;
    public int prepareLeapAnimationTick;
    public int prepareLeapAnimationLength = 30;
    public int leapAnimationTick;
    public int leapAnimationLength = 9;
    public int smashAnimationTick;
    public int smashAnimationLength = 25;
    public int smashAnimationActionPoint = 18;
    public int leapCooldown;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public LeapleafEntity(World world) {
        super((EntityType)ModEntityTypes.LEAPLEAF.get(), world);
    }

    public LeapleafEntity(EntityType<? extends LeapleafEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new RemainStationaryGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new StrafeGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new PrepareLeapGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new BasicAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ApproachTargetGoal((CreatureEntity)this, 0.0, 1.2, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.275).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233818_a_, 75.0).func_233815_a_(Attributes.field_233826_i_, 15.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public boolean shouldBeStationary() {
        return this.restTick > 0;
    }

    public void func_70642_aH() {
        SoundEvent soundeventVocal = this.func_184639_G();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_184581_c(DamageSource p_184581_1_) {
        this.field_70757_a = -this.func_70627_aG();
        SoundEvent soundeventVocal = this.func_184601_bQ(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 0.5f, 1.0f);
        this.func_184185_a(this.getStepSoundFoley(), 0.5f, 1.0f);
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.func_174814_R()) {
            if (vocalSound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vocalSound, this.func_184176_by(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), foleySound, this.func_184176_by(), foleyVolume, foleyPitch);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_IDLE_VOCAL.get();
    }

    protected SoundEvent getAmbientSoundFoley() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_IDLE_FOLEY.get();
    }

    public int func_70627_aG() {
        return 250;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_HURT_VOCAL.get();
    }

    protected SoundEvent getHurtSoundFoley(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_HURT_FOLEY.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_STEP_VOCAL.get();
    }

    protected SoundEvent getStepSoundFoley() {
        return (SoundEvent)ModSoundEvents.LEAPLEAF_STEP_FOLEY.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TIMES_LEAPT, (Object)0);
        this.field_70180_af.func_187214_a(CAN_LEAP, (Object)false);
        this.field_70180_af.func_187214_a(LEAPING, (Object)false);
    }

    public int getTimesLeapt() {
        return (Integer)this.field_70180_af.func_187225_a(TIMES_LEAPT);
    }

    public void setTimesLeapt(int attached) {
        this.field_70180_af.func_187227_b(TIMES_LEAPT, (Object)attached);
    }

    public boolean canLeap() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_LEAP);
    }

    public void setCanLeap(boolean attached) {
        this.field_70180_af.func_187227_b(CAN_LEAP, (Object)attached);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(LEAPING);
    }

    public void setLeaping(boolean attached) {
        this.field_70180_af.func_187227_b(LEAPING, (Object)attached);
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else if (p_28844_ == 8) {
            this.prepareLeapAnimationTick = this.prepareLeapAnimationLength;
        } else if (p_28844_ == 9) {
            this.leapAnimationTick = this.leapAnimationLength;
        } else if (p_28844_ == 11) {
            this.smashAnimationTick = this.smashAnimationLength;
        } else if (p_28844_ == 7) {
            this.restTick = this.restLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        super.func_70030_z();
        this.tickDownAnimTimers();
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (!this.field_70170_p.field_72995_K && this.canLeap() && (this.func_70638_az() == null || this.func_70638_az().func_233643_dh_())) {
            this.restTick = this.restLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.setCanLeap(false);
            this.setTimesLeapt(0);
        }
        if (this.canLeap()) {
            if (!modifiableattributeinstance.func_180374_a(SPEED_MODIFIER_CHARGING)) {
                modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_CHARGING);
            }
        } else {
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_CHARGING);
        }
        if (LeapleafEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(3) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.DUST.get(), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), (double)this.field_70146_Z.nextFloat() * 0.5, this.field_70146_Z.nextGaussian() * 1.0, this.field_70146_Z.nextGaussian() * 1.0);
        }
        if (this.restTick > 0) {
            --this.restTick;
        }
        if (this.strafeTick > 0) {
            --this.strafeTick;
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.prepareLeapAnimationTick > 0) {
            --this.prepareLeapAnimationTick;
        }
        if (this.leapAnimationTick > 0) {
            --this.leapAnimationTick;
        }
        if (this.smashAnimationTick > 0) {
            --this.smashAnimationTick;
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.smashAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_smash", Boolean.valueOf(true)));
        } else if (this.leapAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_leap", Boolean.valueOf(true)));
        } else if (this.prepareLeapAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_prepare_leap", Boolean.valueOf(true)));
        } else if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_attack", Boolean.valueOf(true)));
        } else if (this.restTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_rest", Boolean.valueOf(true)));
        } else if (this.isLeaping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_leaping", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("leapleaf_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (super.func_184191_r(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).func_200600_R().func_220341_a(CustomTags.PLANT_MOBS)) {
            return this.func_96124_cp() == null && p_184191_1_.func_96124_cp() == null;
        }
        return false;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return LeapleafEntity.this.shouldBeStationary();
        }
    }

    class StrafeGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;
        private boolean strafingLeft;

        public StrafeGoal(LeapleafEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.strafeTick > 0;
        }

        public boolean func_75253_b() {
            return this.target != null && this.mob.strafeTick > 0;
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch());
                if (this.mob.field_70146_Z.nextInt(30) == 0) {
                    boolean bl = this.strafingLeft = !this.strafingLeft;
                }
                if (this.mob.func_70032_d((Entity)this.target) < 4.0f) {
                    this.mob.func_213317_d(this.mob.func_213322_ci().func_178787_e(PositionUtils.getOffsetMotion((Entity)this.mob, 0.0, 0.0, -0.1, this.mob.field_70761_aq)));
                }
                if (this.strafingLeft) {
                    this.mob.func_213317_d(this.mob.func_213322_ci().func_178787_e(PositionUtils.getOffsetMotion((Entity)this.mob, 0.05, 0.0, 0.0, this.mob.field_70761_aq)));
                } else {
                    this.mob.func_213317_d(this.mob.func_213322_ci().func_178787_e(PositionUtils.getOffsetMotion((Entity)this.mob, -0.05, 0.0, 0.0, this.mob.field_70761_aq)));
                }
            }
        }
    }

    class LeapGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;
        public int leapTime;

        public LeapGoal(LeapleafEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_70032_d((Entity)this.target) <= 10.0f && this.mob.canLeap() && this.mob.field_70146_Z.nextInt(5) == 0 && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target);
        }

        public boolean func_75253_b() {
            return this.target != null && (!this.animationsUseable() || this.mob.isLeaping() || this.mob.smashAnimationTick > 0);
        }

        public void func_75249_e() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_LEAP_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_LEAP_FOLEY.get(), 1.5f, 1.0f, 1.5f, 1.0f);
            this.mob.leapAnimationTick = this.mob.leapAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null && this.mob.leapAnimationTick == 1) {
                double d0 = this.target.func_226277_ct_() - this.mob.func_226277_ct_();
                double d1 = this.target.func_226278_cu_() - this.mob.func_226278_cu_();
                double d2 = this.target.func_226281_cx_() - this.mob.func_226281_cx_();
                this.mob.func_213293_j(d0 * 0.15, 0.75 + MathHelper.func_151237_a((double)(d1 * 0.05), (double)0.0, (double)10.0), d2 * 0.15);
                this.mob.setLeaping(true);
                this.mob.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch());
                this.leapTime = 0;
            }
            if (this.mob.isLeaping()) {
                ++this.leapTime;
            }
            if (this.mob.isLeaping() && this.mob.func_233570_aj_() && this.leapTime > 10) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.LEAPLEAF_LAND.get(), 2.0f, 1.0f);
                this.mob.setLeaping(false);
                this.mob.smashAnimationTick = this.mob.smashAnimationLength;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
            }
            if (this.mob.smashAnimationTick == this.mob.smashAnimationActionPoint) {
                Vector3d areaDamagePos = PositionUtils.getOffsetPos((Entity)this.mob, -1.5, 0.0, 2.0, this.mob.field_70761_aq);
                AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.mob.field_70170_p, areaDamagePos, (LivingEntity)this.mob, 25.0f, DamageSource.func_76358_a((LivingEntity)this.mob), 0.0f, 6.0f, 1.0f, 0.75f, 10, false, false, 2.0, 0.4, true, 120, 1);
                Vector3d areaDamagePos2 = PositionUtils.getOffsetPos((Entity)this.mob, 1.5, 0.0, 2.0, this.mob.field_70761_aq);
                AreaDamageEntity areaDamage2 = AreaDamageEntity.spawnAreaDamage(this.mob.field_70170_p, areaDamagePos2, (LivingEntity)this.mob, 25.0f, DamageSource.func_76358_a((LivingEntity)this.mob), 0.0f, 6.0f, 1.0f, 0.75f, 10, false, false, 2.0, 0.4, true, 120, 1);
                areaDamage.connectedAreaDamages.add(areaDamage2);
                areaDamage2.connectedAreaDamages.add(areaDamage);
                this.mob.field_70170_p.func_217376_c((Entity)areaDamage);
                this.mob.field_70170_p.func_217376_c((Entity)areaDamage2);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.leapTime = 0;
            this.mob.setCanLeap(false);
            this.mob.setLeaping(false);
            this.mob.setTimesLeapt(this.mob.getTimesLeapt() + 1);
            this.mob.leapCooldown = 60;
            int leapTimesByDifficulty = this.mob.field_70170_p.func_175649_E(this.mob.func_233580_cy_()).func_203095_a().func_151525_a();
            if (this.mob.getTimesLeapt() >= leapTimesByDifficulty) {
                this.mob.restTick = this.mob.restLength;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)7);
                this.mob.setTimesLeapt(0);
                this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_REST_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_REST_FOLEY.get(), 1.0f, this.mob.func_70647_i(), 1.0f, this.mob.func_70647_i());
            } else {
                this.mob.strafeTick = this.mob.strafeLength;
            }
        }

        public boolean animationsUseable() {
            return this.mob.leapAnimationTick <= 0;
        }
    }

    class PrepareLeapGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;

        public PrepareLeapGoal(LeapleafEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.func_70032_d((Entity)this.target) <= 15.0f && !this.mob.canLeap() && this.mob.field_70146_Z.nextInt(30) == 0 && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target) && this.mob.leapCooldown <= 0;
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_PREPARE_LEAP_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_PREPARE_LEAP_FOLEY.get(), 1.25f, 1.0f, 1.25f, 1.0f);
            this.mob.prepareLeapAnimationTick = this.mob.prepareLeapAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)8);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.mob.prepareLeapAnimationTick == 1) {
                this.mob.setCanLeap(true);
            }
        }

        public boolean animationsUseable() {
            return this.mob.prepareLeapAnimationTick <= 0;
        }
    }

    class BasicAttackGoal
    extends Goal {
        public LeapleafEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(LeapleafEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 3.25 && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target);
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.playSound((SoundEvent)ModSoundEvents.LEAPLEAF_ATTACK_VOCAL.get(), (SoundEvent)ModSoundEvents.LEAPLEAF_ATTACK_FOLEY.get(), 1.25f, 1.0f, 1.25f, 1.0f);
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                Vector3d areaDamagePos = PositionUtils.getOffsetPos((Entity)this.mob, -1.0, 0.0, 1.5, this.mob.field_70761_aq);
                AreaDamageEntity areaDamage = AreaDamageEntity.spawnAreaDamage(this.mob.field_70170_p, areaDamagePos, (LivingEntity)this.mob, 15.0f, DamageSource.func_76358_a((LivingEntity)this.mob), 0.0f, 4.5f, 1.0f, 0.5f, 0, false, false, 1.0, 0.2, false, 0, 1);
                this.mob.field_70170_p.func_217376_c((Entity)areaDamage);
            }
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }
}

