/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.VinePartEntity;
import com.infamous.dungeons_mobs.tags.CustomTags;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.entity.PartEntity;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractVineEntity
extends CreatureEntity
implements IMob,
IAnimatable {
    public static final DataParameter<Integer> LENGTH = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> VANISHES = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> STAY_TIME = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> ALWAYS_OUT = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SHOULD_RETRACT = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Float> DETECTION_DISTANCE = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> OUT = EntityDataManager.func_187226_a(AbstractVineEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int lifeTime;
    public int burstAnimationTick;
    public int retractAnimationTick;
    private final Predicate<Entity> SHOULD_BURST_FOR = entity -> this.shouldBurstFor((Entity)entity);
    public VinePartEntity[] subEntities = new VinePartEntity[27];

    protected AbstractVineEntity(EntityType<? extends AbstractVineEntity> entityType, World level) {
        super(entityType, level);
        int adjustedLength = 27;
        for (int i = 0; i < adjustedLength; ++i) {
            VinePartEntity newPart;
            this.subEntities[i] = newPart = new VinePartEntity(this, 26 - i);
        }
    }

    protected void updateParts() {
        for (VinePartEntity part : this.subEntities) {
            part.func_213323_x_();
            this.movePart(part, 0.0, part.getYOffsetForSegment(), 0.0);
        }
    }

    protected void movePart(VinePartEntity part, double dX, double dY, double dZ) {
        Vector3d lastPos = new Vector3d(part.func_226277_ct_(), part.func_226278_cu_(), part.func_226281_cx_());
        part.func_70107_b(this.func_226277_ct_() + dX, this.func_226278_cu_() + dY, this.func_226281_cx_() + dZ);
        part.field_70169_q = lastPos.field_72450_a;
        part.field_70167_r = lastPos.field_72448_b;
        part.field_70166_s = lastPos.field_72449_c;
        part.field_70142_S = lastPos.field_72450_a;
        part.field_70137_T = lastPos.field_72448_b;
        part.field_70136_U = lastPos.field_72449_c;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateParts();
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (super.func_184191_r(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).func_200600_R().func_220341_a(CustomTags.PLANT_MOBS)) {
            return this.func_96124_cp() == null && p_184191_1_.func_96124_cp() == null;
        }
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == this.getRetractAnimationLength()) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LENGTH, (Object)0);
        this.field_70180_af.func_187214_a(VANISHES, (Object)false);
        this.field_70180_af.func_187214_a(STAY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(ALWAYS_OUT, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_RETRACT, (Object)false);
        this.field_70180_af.func_187214_a(DETECTION_DISTANCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OUT, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLengthInSegments(compound.func_74762_e("Length"));
        this.setVanishes(compound.func_74767_n("Vanishes"));
        this.setStayTime(compound.func_74762_e("StayTime"));
        this.setAlwaysOut(compound.func_74767_n("AlwaysOut"));
        this.setShouldRetract(compound.func_74767_n("ShouldRetract"));
        this.setDetectionDistance(compound.func_74760_g("DetectionDistance"));
        this.setOut(compound.func_74767_n("Out"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Length", this.getLengthInSegments());
        compound.func_74757_a("Vanishes", this.getVanishes());
        compound.func_74768_a("StayTime", this.getStayTime());
        compound.func_74757_a("AlwaysOut", this.getAlwaysOut());
        compound.func_74757_a("ShouldRetract", this.getShouldRetract());
        compound.func_74776_a("DetectionDistance", this.getDetectionDistance());
        compound.func_74757_a("Out", this.isOut());
    }

    public int getLengthInSegments() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(LENGTH)), (int)1, (int)26);
    }

    public float getLengthInPixels() {
        return this.getLengthInSegments() * 22;
    }

    public float getLengthInBlocks() {
        return this.getLengthInPixels() / 16.0f;
    }

    public void setLengthInSegments(int setTo) {
        this.field_70180_af.func_187227_b(LENGTH, (Object)setTo);
    }

    public void setLengthInPixels(int setTo) {
        this.setLengthInSegments(setTo / 22);
    }

    public void setLengthInBlocks(float setTo) {
        this.setLengthInPixels(Math.round(setTo * 16.0f));
    }

    public boolean getVanishes() {
        return (Boolean)this.field_70180_af.func_187225_a(VANISHES);
    }

    public void setVanishes(boolean setTo) {
        this.field_70180_af.func_187227_b(VANISHES, (Object)setTo);
    }

    public int getStayTime() {
        return (Integer)this.field_70180_af.func_187225_a(STAY_TIME);
    }

    public void setStayTime(int setTo) {
        this.field_70180_af.func_187227_b(STAY_TIME, (Object)setTo);
    }

    public boolean getAlwaysOut() {
        return (Boolean)this.field_70180_af.func_187225_a(ALWAYS_OUT);
    }

    public void setAlwaysOut(boolean setTo) {
        this.field_70180_af.func_187227_b(ALWAYS_OUT, (Object)setTo);
    }

    public boolean getShouldRetract() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_RETRACT);
    }

    public void setShouldRetract(boolean setTo) {
        this.field_70180_af.func_187227_b(SHOULD_RETRACT, (Object)setTo);
    }

    public float getDetectionDistance() {
        return ((Float)this.field_70180_af.func_187225_a(DETECTION_DISTANCE)).floatValue();
    }

    public void setDetectionDistance(float setTo) {
        this.field_70180_af.func_187227_b(DETECTION_DISTANCE, (Object)Float.valueOf(setTo));
    }

    public boolean getOut() {
        return (Boolean)this.field_70180_af.func_187225_a(OUT);
    }

    public void setOut(boolean setTo) {
        this.field_70180_af.func_187227_b(OUT, (Object)setTo);
    }

    public abstract int getBurstAnimationLength();

    public abstract int getRetractAnimationLength();

    public float getExtraHitboxY() {
        return 0.0f;
    }

    public void func_70642_aH() {
        SoundEvent soundeventVocal = this.func_184639_G();
        SoundEvent soundeventFoley = this.getAmbientSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_184581_c(DamageSource p_184581_1_) {
        this.field_70757_a = -this.func_70627_aG();
        SoundEvent soundeventVocal = this.func_184601_bQ(p_184581_1_);
        SoundEvent soundeventFoley = this.getHurtSoundFoley(p_184581_1_);
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    public void playBurstSound() {
        SoundEvent soundeventVocal = this.getBurstSound();
        SoundEvent soundeventFoley = this.getBurstSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    public void playRetractSound() {
        SoundEvent soundeventVocal = this.getRetractSound();
        SoundEvent soundeventFoley = this.getRetractSoundFoley();
        this.playSound(soundeventVocal, soundeventFoley, this.func_70599_aP(), this.func_70647_i(), this.func_70599_aP(), this.func_70647_i());
    }

    public void playSound(SoundEvent vocalSound, SoundEvent foleySound, float vocalVolume, float vocalPitch, float foleyVolume, float foleyPitch) {
        if (!this.func_174814_R()) {
            if (vocalSound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vocalSound, this.func_184176_by(), vocalVolume, vocalPitch);
            }
            if (foleySound != null) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), foleySound, this.func_184176_by(), foleyVolume, foleyPitch);
            }
        }
    }

    protected abstract SoundEvent getAmbientSoundFoley();

    protected abstract SoundEvent getHurtSoundFoley(DamageSource var1);

    public abstract SoundEvent getBurstSound();

    public abstract SoundEvent getRetractSound();

    public abstract SoundEvent getBurstSoundFoley();

    public abstract SoundEvent getRetractSoundFoley();

    protected float func_70599_aP() {
        return super.func_70599_aP() + (float)((double)this.getLengthInSegments() * 0.5);
    }

    public abstract int getAnimationTransitionTime();

    public boolean isOut() {
        return this.getOut();
    }

    public boolean canBurst() {
        return !this.isOut() && this.retractAnimationTick <= 0 && this.burstAnimationTick <= 0;
    }

    public boolean canRetract() {
        return this.isOut() && !this.getAlwaysOut() && this.retractAnimationTick <= 0 && this.burstAnimationTick <= 0;
    }

    public boolean shouldBurstFor(Entity entity) {
        return entity instanceof LivingEntity && !entity.func_200600_R().func_220341_a(CustomTags.PLANT_MOBS) && entity.func_70089_S() && !entity.func_175149_v() && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_());
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_94059_bO() {
        return this.isOut();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_ == DamageSource.field_76380_i || this.isOut() && p_70097_1_ != DamageSource.field_76368_d) {
            return super.func_70097_a(p_70097_1_, p_70097_2_);
        }
        return false;
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public void func_70108_f(Entity p_70108_1_) {
    }

    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    protected void func_85033_bc() {
    }

    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.burstAnimationTick = this.getBurstAnimationLength();
        } else if (p_70103_1_ == 11) {
            this.retractAnimationTick = this.getRetractAnimationLength();
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return !this.isOut() ? EntitySize.func_220314_b((float)1.0f, (float)0.1f) : EntitySize.func_220314_b((float)1.5f, (float)(this.getLengthInBlocks() + this.getExtraHitboxY()));
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public abstract void spawnAreaDamage();

    public abstract void setDefaultFeatures();

    public abstract boolean isKelp();

    public abstract boolean shouldDieInWrongHabitat();

    public abstract int wrongHabitatDieChance();

    public boolean isInWrongHabitat() {
        return this.isKelp() && !this.func_203005_aq() || !this.isKelp() && this.func_203005_aq();
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, ILivingEntityData p_213386_4_, CompoundNBT p_213386_5_) {
        this.setDefaultFeatures();
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.func_213323_x_();
        this.tickDownAnimTimers();
        ++this.lifeTime;
        int nearbyEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)this.getDetectionDistance()), this.SHOULD_BURST_FOR).size();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isInWrongHabitat() && this.field_70146_Z.nextInt(this.wrongHabitatDieChance()) == 0 && this.shouldDieInWrongHabitat() && this.isOut()) {
                this.func_174812_G();
            }
            if (this.burstAnimationTick == 1) {
                this.setOut(true);
            } else if (this.retractAnimationTick == 1) {
                this.setOut(false);
            }
            if (this.getAlwaysOut() && this.canBurst()) {
                this.burst();
            }
            if (nearbyEntities > 0) {
                if (this.canBurst()) {
                    this.burst();
                }
            } else if (this.canRetract() && this.getShouldRetract()) {
                this.retract();
            }
            if (this.getVanishes() && this.lifeTime > this.getStayTime()) {
                if (this.retractAnimationTick <= 0) {
                    this.retract();
                }
                if (this.retractAnimationTick == 1) {
                    this.func_70106_y();
                }
            }
        }
    }

    public void burst() {
        this.spawnAreaDamage();
        this.playBurstSound();
        this.burstAnimationTick = this.getBurstAnimationLength();
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
    }

    public void retract() {
        this.spawnAreaDamage();
        this.playRetractSound();
        this.retractAnimationTick = this.getRetractAnimationLength();
        this.field_70170_p.func_72960_a((Entity)this, (byte)11);
    }

    public void tickDownAnimTimers() {
        if (this.burstAnimationTick > 0) {
            --this.burstAnimationTick;
        }
        if (this.retractAnimationTick > 0) {
            --this.retractAnimationTick;
        }
    }

    public void func_145769_d(int p_145769_1_) {
        super.func_145769_d(p_145769_1_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].func_145769_d(p_145769_1_ + i + 1);
        }
    }
}

