/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.client.particle.ModParticleTypes;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.projectiles.WindcallerBlastProjectileEntity;
import com.infamous.dungeons_mobs.entities.summonables.WindcallerTornadoEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class WindcallerEntity
extends AbstractIllagerEntity
implements IAnimatable,
SpawnArmoredMob {
    public int liftAttackAnimationTick;
    public int liftAttackAnimationLength = 25;
    public int liftAttackAnimationActionPoint = 15;
    public int blastAttackAnimationTick;
    public int blastAttackAnimationLength = 32;
    public int blastAttackAnimationActionPoint = 20;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int soundLoopTick;

    public WindcallerEntity(World world) {
        super((EntityType)ModEntityTypes.WINDCALLER.get(), world);
    }

    public WindcallerEntity(EntityType<? extends WindcallerEntity> type, World world) {
        super(type, world);
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BlastAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LiftAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 5.0f, 1.2, 1.15));
        this.field_70714_bg.func_75776_a(3, (Goal)new ApproachTargetGoal((CreatureEntity)this, 6.0, 1.1, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(600));
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.liftAttackAnimationTick = this.liftAttackAnimationLength;
        } else if (p_28844_ == 11) {
            this.blastAttackAnimationTick = this.blastAttackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    boolean steepDropBelow() {
        boolean blockBeneath = false;
        for (int i = 0; i < 4; ++i) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o() - i, this.func_233580_cy_().func_177952_p())).func_196958_f()) continue;
            blockBeneath = true;
        }
        return !this.field_70170_p.field_72995_K && !blockBeneath;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && (!this.func_233570_aj_() && this.steepDropBelow() || (this.func_70638_az().func_226278_cu_() > this.func_226278_cu_() + 4.0 || this.func_226278_cu_() < this.func_70638_az().func_226278_cu_() - 2.0) && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f || this.func_70032_d((Entity)this.func_70638_az()) > 10.0f)) {
            if (this.func_226278_cu_() < this.func_70638_az().func_226278_cu_() + 4.0) {
                this.func_213293_j(0.0, 0.05, 0.0);
            } else {
                this.func_213293_j(0.0, -0.01, 0.0);
            }
            double x = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
            double y = this.func_70638_az().func_226278_cu_() - this.func_226278_cu_();
            double z = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.func_213317_d(this.func_213322_ci().func_72441_c(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).func_186678_a(1.5));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_70661_as().func_75499_g();
            this.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226280_cw_(), this.func_70638_az().func_226281_cx_()));
        }
        ++this.soundLoopTick;
        if (this.soundLoopTick % 40 == 0) {
            this.func_184185_a((SoundEvent)ModSoundEvents.WINDCALLER_FLY_LOOP.get(), 0.75f, 1.0f);
        }
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.WIND.get(), this.func_226282_d_(0.1), this.func_226278_cu_() + 0.05, this.func_226287_g_(0.1), (this.field_70146_Z.nextDouble() - 0.5) * 1.0, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 1.0);
        }
        super.func_70636_d();
    }

    public void tickDownAnimTimers() {
        if (this.liftAttackAnimationTick > 0) {
            --this.liftAttackAnimationTick;
        }
        if (this.blastAttackAnimationTick > 0) {
            --this.blastAttackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.liftAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_lift", Boolean.valueOf(true)));
        } else if (this.blastAttackAnimationTick > 10) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_blast", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_fly", Boolean.valueOf(true)));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("windcaller_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.WINDCALLER_STAFF.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.WINDCALLER_ARMOR, (MobEntity)this);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData iLivingEntityData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return iLivingEntityData;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 30.0);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.WINDCALLER_HURT.get();
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)ModSoundEvents.WINDCALLER_BLAST_VOCAL.get();
    }

    public ArmorSet getArmorSet() {
        return ModItems.WINDCALLER_ARMOR;
    }

    class BlastAttackGoal
    extends Goal {
        public WindcallerEntity mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> TORNADO = p_33346_ -> p_33346_ instanceof WindcallerTornadoEntity;

        public BlastAttackGoal(WindcallerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            int nearbyTornadoes = 1;
            if (this.target != null) {
                nearbyTornadoes = this.mob.field_70170_p.func_175674_a((Entity)this.mob, this.target.func_174813_aQ().func_186662_g(5.0), this.TORNADO).size();
            }
            return this.target != null && this.mob.field_70146_Z.nextInt(5) == 0 && (this.mob.func_70032_d((Entity)this.target) <= 4.0f || !this.target.func_233570_aj_() && this.mob.field_70146_Z.nextInt(10) == 0 && (double)this.mob.func_70032_d((Entity)this.target) < 7.5) && nearbyTornadoes <= 0 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WINDCALLER_BLAST_VOCAL.get(), 1.0f, this.mob.func_70647_i());
            this.mob.blastAttackAnimationTick = this.mob.blastAttackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.blastAttackAnimationTick == this.mob.blastAttackAnimationActionPoint) {
                double d1 = this.target.func_226277_ct_() - this.mob.func_226277_ct_();
                double d2 = this.target.func_226283_e_(0.5) - this.mob.func_226283_e_(0.5);
                double d3 = this.target.func_226281_cx_() - this.mob.func_226281_cx_();
                WindcallerBlastProjectileEntity smallfireballentity = new WindcallerBlastProjectileEntity(this.mob.field_70170_p, (LivingEntity)this.mob, d1, 0.0, d3);
                smallfireballentity.func_70107_b(this.mob.func_226277_ct_(), this.mob.func_226283_e_(0.25), this.mob.func_226281_cx_());
                this.mob.field_70170_p.func_217376_c((Entity)smallfireballentity);
                WindcallerTornadoEntity tornado = (WindcallerTornadoEntity)((EntityType)ModEntityTypes.TORNADO.get()).func_200721_a(this.mob.field_70170_p);
                tornado.func_174828_a(this.mob.func_233580_cy_(), 0.0f, 0.0f);
                tornado.func_184185_a((SoundEvent)ModSoundEvents.WINDCALLER_BLAST_WIND.get(), 1.5f, 1.0f);
                tornado.setBlast(true);
                tornado.field_70177_z = -this.mob.field_70759_as - 90.0f;
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)tornado);
            }
        }

        public boolean animationsUseable() {
            return this.mob.blastAttackAnimationTick <= 0;
        }
    }

    class LiftAttackGoal
    extends Goal {
        public WindcallerEntity mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> TORNADO = p_33346_ -> p_33346_ instanceof WindcallerTornadoEntity;

        public LiftAttackGoal(WindcallerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            int nearbyTornadoes = 1;
            if (this.target != null) {
                nearbyTornadoes = this.mob.field_70170_p.func_175674_a((Entity)this.mob, this.target.func_174813_aQ().func_186662_g(5.0), this.TORNADO).size();
            }
            return this.target != null && this.target.func_233570_aj_() && this.mob.field_70146_Z.nextInt(30) == 0 && this.mob.func_70032_d((Entity)this.target) <= 16.0f && this.mob.func_70032_d((Entity)this.target) > 3.0f && nearbyTornadoes <= 0 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.WINDCALLER_LIFT_VOCAL.get(), 1.0f, this.mob.func_70647_i());
            this.mob.liftAttackAnimationTick = this.mob.liftAttackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.liftAttackAnimationTick == this.mob.liftAttackAnimationActionPoint) {
                WindcallerTornadoEntity tornado = (WindcallerTornadoEntity)((EntityType)ModEntityTypes.TORNADO.get()).func_200721_a(this.mob.field_70170_p);
                tornado.func_174828_a(this.target.func_233580_cy_(), 0.0f, 0.0f);
                tornado.func_184185_a((SoundEvent)ModSoundEvents.WINDCALLER_LIFT_WIND.get(), 1.5f, 1.0f);
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)tornado);
            }
        }

        public boolean animationsUseable() {
            return this.mob.liftAttackAnimationTick <= 0;
        }
    }
}

