/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.goals.UseShieldGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RoyalGuardEntity
extends AbstractIllagerEntity
implements IAnimatable,
IShieldUser,
SpawnArmoredMob {
    private static final UUID SPEED_MODIFIER_BLOCKING_UUID = UUID.fromString("05cd371b-0ff4-4ded-8630-b380232ed7b1");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_BLOCKING_UUID, "Blocking speed decrease", -0.1, AttributeModifier.Operation.ADDITION);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int shieldCooldownTime = 0;
    public int attackAnimationTick;
    public int attackAnimationLength = 27;
    public int attackAnimationActionPoint = 15;

    public RoyalGuardEntity(World world) {
        super((EntityType)ModEntityTypes.ROYAL_GUARD.get(), world);
    }

    public RoyalGuardEntity(EntityType<? extends RoyalGuardEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new UseShieldGoal((CreatureEntity)this, 7.5, 60, 160, 15, 100, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new BasicAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ApproachTargetGoal((CreatureEntity)this, 0.0, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AbstractIllagerEntity.RaidOpenDoorGoal((AbstractIllagerEntity)this, (AbstractRaiderEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AbstractRaiderEntity.FindTargetGoal((AbstractRaiderEntity)this, (AbstractIllagerEntity)this, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData ilivingentitydata = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return ilivingentitydata;
    }

    public boolean func_184638_cS() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191269_hn;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191270_ho;
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219707_mP;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (this.func_184585_cz()) {
            if (!modifiableattributeinstance.func_180374_a(SPEED_MODIFIER_BLOCKING)) {
                modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_BLOCKING);
            }
        } else {
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_BLOCKING);
        }
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_attack", Boolean.valueOf(true)));
        } else if (this.func_184585_cz()) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_walk_blocking", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_blocking", Boolean.valueOf(true)));
            }
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_walk", Boolean.valueOf(true)));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("royal_guard_new_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)ModSoundEvents.ROYAL_GUARD_STEP.get(), 0.5f, 1.0f);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return VindicatorEntity.func_234322_eI_().func_233815_a_(Attributes.field_233820_c_, 0.6).func_233815_a_(Attributes.field_233821_d_, (double)0.325f).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233824_g_, 1.0);
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        SpawnArmoredHelper.equipArmorSet(ModItems.ROYAL_GUARD_ARMOR, (MobEntity)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            ItemStack mace = new ItemStack((IItemProvider)MACE);
            if (this.func_213663_ek() == null) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, mace);
            }
        } else if (this.func_213663_ek() == null) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151036_c));
        }
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModItems.ROYAL_GUARD_SHIELD.get()));
    }

    public void func_213660_a(int waveAmount, boolean b) {
        ItemStack mainhandWeapon = new ItemStack((IItemProvider)Items.field_151036_c);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            mainhandWeapon = new ItemStack((IItemProvider)MACE);
        }
        Raid raid = this.func_213663_ek();
        int enchantmentLevel = 1;
        if (raid != null && waveAmount > raid.func_221306_a(Difficulty.NORMAL)) {
            enchantmentLevel = 2;
        }
        boolean applyEnchant = false;
        if (raid != null) {
            boolean bl = applyEnchant = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        }
        if (applyEnchant) {
            HashMap enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.field_185302_k, enchantmentLevel);
            EnchantmentHelper.func_82782_a((Map)enchantmentIntegerMap, (ItemStack)mainhandWeapon);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.shieldCooldownTime = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    protected void func_184581_c(DamageSource damageSource) {
        if (this.shieldCooldownTime == 100) {
            this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else if (this.func_184585_cz()) {
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else {
            super.func_184581_c(damageSource);
        }
    }

    public void func_190629_c(LivingEntity livingEntity) {
        super.func_190629_c(livingEntity);
        if (livingEntity.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void func_184590_k(float amount) {
        if (this.field_184627_bm.isShield((LivingEntity)this) && amount >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)amount);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, royalGuardEntity -> royalGuardEntity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public ArmorSet getArmorSet() {
        return ModItems.ROYAL_GUARD_ARMOR;
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof PlayerEntity && livingEntity.func_184585_cz()) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184586_b(livingEntity.func_184600_cs()).func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }

    class BasicAttackGoal
    extends Goal {
        public RoyalGuardEntity mob;
        @Nullable
        public LivingEntity target;

        public BasicAttackGoal(RoyalGuardEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && !this.mob.func_184585_cz() && (double)this.mob.func_70032_d((Entity)this.target) <= 2.5 && this.animationsUseable() && this.mob.func_70685_l((Entity)this.target);
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            if (this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.ROYAL_GUARD_ATTACK.get(), 1.25f, 1.0f);
            }
            if (this.target != null && (double)this.mob.func_70032_d((Entity)this.target) < 3.5 && this.mob.attackAnimationTick == this.mob.attackAnimationActionPoint) {
                this.mob.func_70652_k((Entity)this.target);
                RoyalGuardEntity.disableShield(this.target, 60);
            }
        }

        public void func_75251_c() {
            if (this.target != null && !this.isShieldDisabled((CreatureEntity)this.mob) && this.shouldBlockForTarget(this.target) && this.mob.func_184592_cb().func_77973_b().isShield(this.mob.func_184592_cb(), (LivingEntity)this.mob) && this.mob.field_70146_Z.nextInt(6) == 0) {
                this.mob.func_184598_c(Hand.OFF_HAND);
            }
        }

        public boolean isShieldDisabled(CreatureEntity shieldUser) {
            return shieldUser instanceof IShieldUser && ((IShieldUser)shieldUser).isShieldDisabled();
        }

        public boolean shouldBlockForTarget(LivingEntity target) {
            return !(target instanceof MobEntity) || ((MobEntity)target).func_70638_az() == this.mob;
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }
}

