/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.utils.GoalUtils;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedProps;
import com.infamous.dungeons_mobs.capabilities.animatedprops.AnimatedPropsHelper;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.ReplacedModdedAttackGoal;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class ReplacedIllagerEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof VindicatorEntity) {
            VindicatorEntity vindicatorEntity = (VindicatorEntity)entity;
            GoalUtils.removeGoal((GoalSelector)vindicatorEntity.field_70714_bg, MeleeAttackGoal.class);
            vindicatorEntity.field_70714_bg.func_75776_a(4, new ReplacedModdedAttackGoal<VindicatorEntity>(vindicatorEntity, null, 20));
            vindicatorEntity.field_70714_bg.func_75776_a(5, (Goal)new ApproachTargetGoal((CreatureEntity)vindicatorEntity, 0.0, 1.0, true));
            AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability((MobEntity)vindicatorEntity);
            cap.setAttackAnimationLength(7);
            cap.setAttackAnimationActionPoint(6);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof VindicatorEntity) {
            ReplacedIllagerEvents.tickDownAnimTimers((MobEntity)livingEntity);
        }
    }

    public static void tickDownAnimTimers(MobEntity mobEntity) {
        AnimatedProps cap = AnimatedPropsHelper.getAnimatedPropsCapability(mobEntity);
        if (cap.getAttackAnimationTick() > 0) {
            cap.setAttackAnimationTick(cap.getAttackAnimationTick() - 1);
        }
    }
}

