/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_libraries.utils.GoalUtils;
import com.infamous.dungeons_mobs.entities.AnimatableMeleeAttackMob;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.BasicModdedAttackGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MountaineerEntity
extends VindicatorEntity
implements SpawnArmoredMob,
IAnimatable,
AnimatableMeleeAttackMob {
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(MountaineerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int attackAnimationTick;
    public int attackAnimationLength = 7;
    public int attackAnimationActionPoint = 6;

    public MountaineerEntity(World worldIn) {
        super((EntityType)ModEntityTypes.MOUNTAINEER.get(), worldIn);
    }

    public MountaineerEntity(EntityType<? extends MountaineerEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        GoalUtils.removeGoal((GoalSelector)this.field_70714_bg, MeleeAttackGoal.class);
        this.field_70714_bg.func_75776_a(4, new BasicModdedAttackGoal<MountaineerEntity>(this, null, 20));
        this.field_70714_bg.func_75776_a(5, (Goal)new ApproachTargetGoal((CreatureEntity)this, 0.0, 1.0, true));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233818_a_, 28.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new ClimberPathNavigator((MobEntity)this, p_175447_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setClimbing(this.field_70123_F);
        }
        this.tickDownAnimTimers();
    }

    public boolean func_70617_f_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_70839_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)b0);
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_IDLE.get();
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.MOUNTAINEER_HURT.get();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.MOUNTAINEER_AXE.get()));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.MOUNTAINEER_ARMOR.getHead().get()));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModItems.MOUNTAINEER_ARMOR.getChest().get()));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ModItems.MOUNTAINEER_ARMOR.getLegs().get()));
        this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)ModItems.MOUNTAINEER_ARMOR.getFeet().get()));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData iLivingEntityData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return iLivingEntityData;
    }

    public void func_213660_a(int waveNumber, boolean bool) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MOUNTAINEER_AXE.get());
        Raid raid = this.func_213663_ek();
        int i = 1;
        if (raid != null && waveNumber > raid.func_221306_a(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean flag = false;
        if (raid != null) {
            boolean bl = flag = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        }
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.field_185302_k, i);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemStack);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public boolean func_213637_dY() {
        return false;
    }

    public ArmorSet getArmorSet() {
        return ModItems.MOUNTAINEER_ARMOR;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public void setAttackAnimationTick(int attackAnimationTick) {
        this.attackAnimationTick = attackAnimationTick;
    }

    @Override
    public int getAttackAnimationLength() {
        return this.attackAnimationLength;
    }

    @Override
    public int getAttackAnimationActionPoint() {
        return this.attackAnimationActionPoint;
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String animation = "animation.vindicator";
        String handSide = "_right";
        if (this.func_184638_cS()) {
            handSide = "_left";
        }
        if (this.func_184614_ca().func_190926_b()) {
            handSide = handSide + "_both";
        }
        String crossed = "";
        if (IllagerArmsUtil.armorHasCrossedArms((AbstractIllagerEntity)this, this.func_184582_a(EquipmentSlotType.CHEST))) {
            crossed = "_crossed";
        }
        if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".attack" + handSide, Boolean.valueOf(true)));
        } else if (!(!this.func_213398_dR() || event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".run" + handSide, Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".walk" + crossed, Boolean.valueOf(true)));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".win", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(animation + ".idle" + crossed, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

