/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.illagers.MageCloneEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MageEntity
extends AbstractIllagerEntity
implements IAnimatable,
SpawnArmoredMob {
    public int attackAnimationTick;
    public int attackAnimationLength = 50;
    public int vanishAnimationTick;
    public int vanishAnimationLength = 23;
    public int appearAnimationTick;
    public int appearAnimationLength = 25;
    public int appearDelay = 0;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MageEntity(EntityType<? extends MageEntity> type, World world) {
        super(type, world);
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RemainStationaryGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new CreateIllusionsGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LevitateTargetAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractVillagerEntity.class, 5.0f, 1.2, 1.15));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 5.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 5.0f, 1.3, 1.15));
        this.field_70714_bg.func_75776_a(4, (Goal)new ApproachTargetGoal((CreatureEntity)this, 14.0, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(600));
    }

    public boolean shouldBeStationary() {
        return this.appearAnimationTick > 0 || this.appearDelay > 0;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = this.attackAnimationLength;
        } else if (p_28844_ == 6) {
            this.appearDelay = 11;
        } else if (p_28844_ == 7) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else if (p_28844_ == 8) {
            this.vanishAnimationTick = this.vanishAnimationLength;
        } else if (p_28844_ == 9) {
            this.appearAnimationTick = this.appearAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.appearDelay > 0) {
            --this.appearDelay;
        }
        if (!this.field_70170_p.field_72995_K && this.appearDelay == 1) {
            this.appearAnimationTick = this.appearAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
        }
    }

    public void tickDownAnimTimers() {
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
        if (this.appearAnimationTick > 0) {
            --this.appearAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.appearAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_appear", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_vanish", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.attackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_throw", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mage_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        SpawnArmoredHelper.equipArmorSet(ModItems.MAGE_ARMOR, (MobEntity)this);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData iLivingEntityData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return iLivingEntityData;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 40.0);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.ILLUSIONER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENCHANTER_HURT.get();
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    public ArmorSet getArmorSet() {
        return ModItems.MAGE_ARMOR;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return MageEntity.this.shouldBeStationary();
        }
    }

    class LevitateTargetAttackGoal
    extends Goal {
        public MageEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime = 0;
        public boolean slammedTarget = false;

        public LevitateTargetAttackGoal(MageEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && !this.mob.shouldBeStationary() && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 16.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.mob.shouldBeStationary() && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.slammedTarget = false;
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.NECROMANCER_PREPARE_SUMMON.get(), 1.0f, this.mob.func_70647_i());
            this.mob.attackAnimationTick = this.mob.attackAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null) {
                this.target.field_70133_I = true;
                if (this.mob.attackAnimationTick >= this.mob.attackAnimationLength - 32) {
                    if (this.target.func_226278_cu_() < this.mob.func_226278_cu_() + 7.0) {
                        this.target.func_70024_g(0.0, 0.1, 0.0);
                        if (this.target.field_70124_G && !this.target.func_233570_aj_()) {
                            this.target.func_70097_a(DamageSource.field_188406_j, 10.0f);
                        }
                    } else {
                        this.target.func_213293_j(this.target.func_213322_ci().field_72450_a * 0.5, 0.0, this.target.func_213322_ci().field_72449_c * 0.5);
                    }
                } else if (!this.slammedTarget) {
                    this.target.field_70143_R = 0.0f;
                    this.target.func_70024_g(0.0, -0.5, 0.0);
                    if (this.target.field_70124_G) {
                        this.slammedTarget = true;
                        this.target.func_70097_a(DamageSource.field_188406_j, 10.0f);
                    }
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.slammedTarget = false;
            this.nextUseTime = this.mob.field_70173_aa + 80 + this.mob.field_70146_Z.nextInt(120);
        }

        public boolean animationsUseable() {
            return this.mob.attackAnimationTick <= 0;
        }
    }

    class CreateIllusionsGoal
    extends Goal {
        public MageEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        private final Predicate<Entity> MAGE_CLONE = p_33346_ -> p_33346_ instanceof MageCloneEntity && ((MageCloneEntity)((Object)p_33346_)).getOwner() != null && ((MageCloneEntity)((Object)p_33346_)).getOwner() == this.mob;

        public CreateIllusionsGoal(MageEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            int nearbyClones = this.mob.field_70170_p.func_175674_a((Entity)this.mob, this.mob.func_174813_aQ().func_186662_g(30.0), this.MAGE_CLONE).size();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.field_70146_Z.nextInt(10) == 0 && this.mob.func_70685_l((Entity)this.target) && nearbyClones <= 0 && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a(SoundEvents.field_193790_di, 1.0f, 1.0f);
            this.mob.vanishAnimationTick = this.mob.vanishAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)8);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.vanishAnimationTick == 1) {
                SummonSpotEntity summonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                summonSpot.func_174828_a(this.target.func_233580_cy_().func_177963_a(-12.5 + (double)this.mob.field_70146_Z.nextInt(25), 0.0, -12.5 + (double)this.mob.field_70146_Z.nextInt(25)), 0.0f, 0.0f);
                summonSpot.setSummonType(3);
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)summonSpot);
                PositionUtils.moveToCorrectHeight(summonSpot);
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)7);
                this.mob.func_174828_a(summonSpot.func_233580_cy_(), 0.0f, 0.0f);
                this.mob.func_181013_g(this.mob.field_70146_Z.nextInt(360));
                this.mob.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_()));
                this.mob.appearDelay = 11;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)6);
                this.mob.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
                PositionUtils.moveToCorrectHeight((Entity)this.mob);
                if (this.target instanceof MobEntity) {
                    ((MobEntity)this.target).func_70624_b(null);
                    ((MobEntity)this.target).func_70604_c(null);
                    if (this.target instanceof IAngerable) {
                        ((IAngerable)this.target).func_241356_K__();
                        ((IAngerable)this.target).func_70604_c(null);
                        ((IAngerable)this.target).func_70624_b(null);
                        ((IAngerable)this.target).func_230259_a_(null);
                    }
                }
                int clonesByDifficulty = this.mob.field_70170_p.func_175649_E(this.mob.func_233580_cy_()).func_203095_a().func_151525_a();
                for (int i = 0; i < clonesByDifficulty * 4; ++i) {
                    SummonSpotEntity cloneSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                    cloneSummonSpot.func_174828_a(this.target.func_233580_cy_().func_177963_a(-12.5 + (double)this.mob.field_70146_Z.nextInt(25), 0.0, -12.5 + (double)this.mob.field_70146_Z.nextInt(25)), 0.0f, 0.0f);
                    cloneSummonSpot.setSummonType(3);
                    cloneSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                    ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)cloneSummonSpot);
                    PositionUtils.moveToCorrectHeight(cloneSummonSpot);
                    MageCloneEntity clone = (MageCloneEntity)((EntityType)ModEntityTypes.MAGE_CLONE.get()).func_200721_a(this.mob.field_70170_p);
                    clone.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(cloneSummonSpot.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                    clone.setOwner((MobEntity)this.mob);
                    clone.func_70606_j(this.mob.func_110143_aJ());
                    for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                        ItemStack itemstack = this.mob.func_184582_a(equipmentslottype);
                        if (itemstack.func_190926_b()) continue;
                        clone.func_184201_a(equipmentslottype, itemstack.func_77946_l());
                        clone.func_184642_a(equipmentslottype, 0.0f);
                    }
                    clone.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_()));
                    clone.setDelayedAppear(true);
                    cloneSummonSpot.summonedEntity = clone;
                    cloneSummonSpot.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
                }
            }
        }

        public boolean animationsUseable() {
            return this.mob.vanishAnimationTick <= 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.nextUseTime = this.mob.field_70173_aa + 50 + this.mob.field_70146_Z.nextInt(50);
        }
    }
}

