/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class IllusionerCloneEntity
extends AbstractIllagerEntity
implements IAnimatable,
SpawnArmoredMob {
    private static final DataParameter<Boolean> DELAYED_APPEAR = EntityDataManager.func_187226_a(IllusionerCloneEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int shootAnimationTick;
    public int shootAnimationLength = 38;
    public int shootAnimationActionPoint = 16;
    public int appearAnimationTick;
    public int appearAnimationLength = 20;
    public int lifeTime;
    private MobEntity owner;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public IllusionerCloneEntity(World world) {
        super((EntityType)ModEntityTypes.ILLUSIONER_CLONE.get(), world);
    }

    public IllusionerCloneEntity(EntityType<? extends IllusionerCloneEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RemainStationaryGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ApproachTargetGoal((CreatureEntity)this, 7.5, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new CopyOwnerTargetGoal((CreatureEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DELAYED_APPEAR, (Object)false);
    }

    public boolean hasDelayedAppear() {
        return (Boolean)this.field_70180_af.func_187225_a(DELAYED_APPEAR);
    }

    public void setDelayedAppear(boolean attached) {
        this.field_70180_af.func_187227_b(DELAYED_APPEAR, (Object)attached);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_.func_76346_g() != null && this.func_184191_r(p_70097_1_.func_76346_g()) && p_70097_1_ != DamageSource.field_76380_i) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public MobEntity getOwner() {
        return this.owner;
    }

    public void setOwner(MobEntity p_190658_1_) {
        this.owner = p_190658_1_;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 1) {
            this.func_70106_y();
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean shouldBeStationary() {
        return this.appearAnimationTick > 0;
    }

    public boolean func_184638_cS() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233818_a_, 50.0);
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 8) {
            this.appearAnimationTick = this.appearAnimationLength;
        } else if (p_28844_ == 11) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        ++this.lifeTime;
        if (!this.field_70170_p.field_72995_K && this.hasDelayedAppear()) {
            this.appearAnimationTick = this.appearAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            this.setDelayedAppear(false);
        }
        int lifeTimeByDifficulty = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_203095_a().func_151525_a();
        if (!this.field_70170_p.field_72995_K && (this.field_70737_aN > 0 || this.lifeTime >= lifeTimeByDifficulty * 100 || this.getOwner() != null && (this.getOwner().func_233643_dh_() || this.getOwner().field_70737_aN > 0 || this.getOwner().func_70638_az() == null))) {
            if (this.field_70737_aN > 0) {
                this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_184185_a(SoundEvents.field_193788_dg, this.func_70599_aP(), 1.0f);
            }
            this.func_70106_y();
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        }
        if (!this.field_70170_p.field_72995_K && this.getOwner() != null) {
            this.func_70606_j(this.getOwner().func_110143_aJ());
        }
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.appearAnimationTick > 0) {
            --this.appearAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String suffix = "_uncrossed";
        if (IllagerArmsUtil.armorHasCrossedArms(this, this.func_184582_a(EquipmentSlotType.CHEST))) {
            suffix = "";
        }
        if (this.appearAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_appear" + suffix, Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_clone_shoot" + suffix, Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_walk" + suffix, Boolean.valueOf(true)));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_idle" + suffix, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_193787_df;
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    public void shootArrow(LivingEntity target) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrowEntity abstractarrowentity = this.getArrow(itemstack, 0.0f);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity getArrow(ItemStack p_213624_1_, float p_213624_2_) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)p_213624_1_, (float)p_213624_2_);
    }

    public ArmorSet getArmorSet() {
        return ModItems.ILLUSIONER_ARMOR;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return IllusionerCloneEntity.this.shouldBeStationary();
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final EntityPredicate copyOwnerTargeting;

        public CopyOwnerTargetGoal(CreatureEntity p_i47231_2_) {
            super((MobEntity)p_i47231_2_, false);
            this.copyOwnerTargeting = new EntityPredicate().func_221014_c().func_221010_e();
        }

        public boolean func_75250_a() {
            return IllusionerCloneEntity.this.owner != null && IllusionerCloneEntity.this.owner.func_70638_az() != null && this.func_220777_a(IllusionerCloneEntity.this.owner.func_70638_az(), this.copyOwnerTargeting);
        }

        public void func_75249_e() {
            IllusionerCloneEntity.this.func_70624_b(IllusionerCloneEntity.this.owner.func_70638_az());
            super.func_75249_e();
        }
    }

    class ShootAttackGoal
    extends Goal {
        public IllusionerCloneEntity mob;
        @Nullable
        public LivingEntity target;
        public int cooldown;

        public ShootAttackGoal(IllusionerCloneEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.cooldown <= 0 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                this.mob.shootArrow(this.target);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.cooldown = 20 + this.mob.field_70146_Z.nextInt(40);
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }
}

