/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.AvoidBaseEntityGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GeomancerEntity
extends SpellcastingIllagerEntity
implements IAnimatable,
SpawnArmoredMob {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int summonBombsAttackAnimationTick;
    public int summonBombsAttackAnimationLength = 35;
    public int summonBombsAttackAnimationActionPoint = 15;
    public int summonWallsAnimationTick;
    public int summonWallsAnimationLength = 35;
    public int summonWallsAnimationActionPoint = 20;

    public GeomancerEntity(EntityType<? extends SpellcastingIllagerEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return EvokerEntity.func_234289_eI_().func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SummonPillarsGoal(this));
        this.field_70714_bg.func_75776_a(1, new AvoidBaseEntityGoal<ConstructEntity>((CreatureEntity)this, ConstructEntity.class, 5.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractVillagerEntity.class, 3.0f, 1.2, 1.15));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 3.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 3.0f, 1.3, 1.15));
        this.field_70714_bg.func_75776_a(3, (Goal)new ApproachTargetGoal((CreatureEntity)this, 15.0, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(600));
    }

    public boolean func_184638_cS() {
        return false;
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.summonWallsAnimationTick = this.summonWallsAnimationLength;
        } else if (p_28844_ == 11) {
            this.summonBombsAttackAnimationTick = this.summonBombsAttackAnimationLength;
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
    }

    public void tickDownAnimTimers() {
        if (this.summonWallsAnimationTick >= 0) {
            --this.summonWallsAnimationTick;
        }
        if (this.summonBombsAttackAnimationTick >= 0) {
            --this.summonBombsAttackAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.summonBombsAttackAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.summonWallsAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_celebrate", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("geomancer_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.GEOMANCER_STAFF.get()));
        SpawnArmoredHelper.equipArmorSet(ModItems.GEOMANCER_ARMOR, (MobEntity)this);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ArmorSet getArmorSet() {
        return ModItems.GEOMANCER_ARMOR;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GEOMANCER_HURT.get();
    }

    protected SoundEvent func_193086_dk() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get();
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)ModSoundEvents.GEOMANCER_IDLE.get();
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    class SummonPillarsGoal
    extends Goal {
        public GeomancerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime = 0;

        public SummonPillarsGoal(GeomancerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.func_70032_d((Entity)this.target) <= 20.0f && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && this.animationsNotUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_PRE_ATTACK.get(), 1.0f, this.mob.func_70647_i());
            if (this.mob.field_70146_Z.nextBoolean()) {
                this.mob.summonWallsAnimationTick = this.mob.summonWallsAnimationLength;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
            } else {
                this.mob.summonBombsAttackAnimationTick = this.mob.summonBombsAttackAnimationLength;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
            }
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.summonWallsAnimationTick == this.mob.summonWallsAnimationActionPoint) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get(), 1.0f, this.mob.func_70647_i());
                int randomInt = this.mob.field_70146_Z.nextInt(3);
                if (randomInt == 0) {
                    int[] rowToRemove = (int[])Util.func_240989_a_((Object[])GeomancyHelper.CONFIG_1_ROWS, (Random)this.mob.func_70681_au());
                    GeomancyHelper.summonAreaDenialTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()), rowToRemove);
                } else if (randomInt == 1) {
                    GeomancyHelper.summonWallTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()));
                } else {
                    GeomancyHelper.summonRandomPillarsTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_WALL.get()));
                }
            }
            if (this.target != null && this.mob.summonBombsAttackAnimationTick == this.mob.summonBombsAttackAnimationActionPoint) {
                this.mob.func_184185_a((SoundEvent)ModSoundEvents.GEOMANCER_ATTACK.get(), 1.0f, this.mob.func_70647_i());
                if (this.mob.func_70681_au().nextBoolean()) {
                    GeomancyHelper.summonQuadOffensiveTrap((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()));
                } else {
                    boolean movingOnX = this.mob.field_70146_Z.nextBoolean();
                    GeomancyHelper.summonOffensiveConstruct((LivingEntity)this.mob, (Entity)this.target, (EntityType<? extends ConstructEntity>)((EntityType)ModEntityTypes.GEOMANCER_BOMB.get()), movingOnX ? (double)(this.mob.field_70146_Z.nextBoolean() ? 2 : -2) : 0.0, !movingOnX ? (double)(this.mob.field_70146_Z.nextBoolean() ? 2 : -2) : 0.0, Direction.NORTH);
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.nextUseTime = this.mob.field_70173_aa + 100 + this.mob.field_70146_Z.nextInt(40);
        }

        public boolean animationsUseable() {
            return this.mob.summonWallsAnimationTick <= 0 || this.mob.summonBombsAttackAnimationTick <= 0;
        }

        public boolean animationsNotUseable() {
            return this.mob.summonWallsAnimationTick > 0 || this.mob.summonBombsAttackAnimationTick > 0;
        }
    }
}

