/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.network.datasync.ModDataSerializers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EnchanterEntity
extends SpellcastingIllagerEntity
implements IAnimatable {
    public static final DataParameter<Integer> ATTACK_TICKS = EntityDataManager.func_187226_a(EnchanterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ENCHANT_TICKS = EntityDataManager.func_187226_a(EnchanterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<List<UUID>> ENCHANTMENT_TARGETS = EntityDataManager.func_187226_a(EnchanterEntity.class, ModDataSerializers.UUID_LIST);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private MonsterEntity enchantmentTarget;
    private List<MonsterEntity> enchantmentTargets = new ArrayList<MonsterEntity>();

    public EnchanterEntity(World world) {
        super((EntityType)ModEntityTypes.GEOMANCER.get(), world);
    }

    public EnchanterEntity(EntityType<? extends SpellcastingIllagerEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 14.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(ENCHANT_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(ENCHANTMENT_TARGETS, new ArrayList());
    }

    public int getAttackTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TICKS);
    }

    public void setAttackTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACK_TICKS, (Object)p_189794_1_);
    }

    public int getEnchantTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ENCHANT_TICKS);
    }

    public void setEnchantTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ENCHANT_TICKS, (Object)p_189794_1_);
    }

    public void addEnchantmentTarget(MonsterEntity monsterEntity) {
        this.enchantmentTargets.add(monsterEntity);
        this.field_70180_af.func_187227_b(ENCHANTMENT_TARGETS, this.enchantmentTargets.stream().map(Entity::func_110124_au).collect(Collectors.toList()));
    }

    public void setEnchantmentTargets(List<MonsterEntity> monsterEntities) {
        this.enchantmentTargets = monsterEntities;
        this.field_70180_af.func_187227_b(ENCHANTMENT_TARGETS, this.enchantmentTargets.stream().map(Entity::func_110124_au).collect(Collectors.toList()));
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new AttackingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new EnchantSpellGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    @Nullable
    private MonsterEntity getEnchantmentTarget() {
        return this.enchantmentTarget;
    }

    private void setEnchantmentTarget(@Nullable MonsterEntity p_190748_1_) {
        this.enchantmentTarget = p_190748_1_;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.func_217362_a((Entity)this, 2.0) != null && this.func_70638_az() != null && this.field_70170_p.func_217362_a((Entity)this, 2.0) == this.func_70638_az()) {
            if (this.getAttackTicks() == 0 && this.field_70146_Z.nextInt(10) == 0) {
                this.setAttackTicks(40);
                this.func_184185_a((SoundEvent)ModSoundEvents.ENCHANTER_PRE_ATTACK.get(), this.func_70599_aP(), this.func_70647_i());
            } else if (this.getAttackTicks() == 12) {
                this.func_70652_k((Entity)this.field_70170_p.func_217362_a((Entity)this, 2.0));
                this.func_184185_a((SoundEvent)ModSoundEvents.ENCHANTER_ATTACK.get(), this.func_70599_aP(), this.func_70647_i());
            }
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        if (this.getEnchantTicks() > 0) {
            this.setEnchantTicks(this.getEnchantTicks() - 1);
        }
        List<MonsterEntity> validEnchantmentTargets = this.enchantmentTargets.stream().filter(this::isValidEnchantmentTarget).collect(Collectors.toList());
        this.enchantmentTargets.stream().filter(monsterEntity -> !validEnchantmentTargets.contains(monsterEntity)).filter(LivingEntity::func_70089_S).forEach(this::clearEntityMobEnchantments);
        this.setEnchantmentTargets(validEnchantmentTargets);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        this.enchantmentTargets.forEach(this::clearEntityMobEnchantments);
        this.setEnchantmentTargets(new ArrayList<MonsterEntity>());
    }

    private void clearEntityMobEnchantments(MonsterEntity entity) {
        entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(enchantableCapability -> {
            enchantableCapability.removeAllMobEnchant((LivingEntity)entity);
            entity.func_213323_x_();
        });
    }

    private boolean isValidEnchantmentTarget(MonsterEntity monsterEntity) {
        return monsterEntity.func_70089_S() && monsterEntity.func_70032_d((Entity)this) <= 30.0f;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getEnchantTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_enchant", Boolean.valueOf(true)));
        } else if (this.getAttackTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("enchanter_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENCHANTER_HURT.get();
    }

    protected SoundEvent func_193086_dk() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_BEAM.get();
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)ModSoundEvents.ENCHANTER_IDLE.get();
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    class AttackingGoal
    extends Goal {
        public AttackingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EnchanterEntity.this.getAttackTicks() > 0 && EnchanterEntity.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            EnchanterEntity.this.func_70661_as().func_75499_g();
            EnchanterEntity.this.func_70671_ap().func_220679_a(EnchanterEntity.this.func_70638_az().func_226277_ct_(), EnchanterEntity.this.func_70638_az().func_226280_cw_(), EnchanterEntity.this.func_70638_az().func_226281_cx_());
        }
    }

    public class EnchantSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        public EnchantSpellGoal() {
            super((SpellcastingIllagerEntity)EnchanterEntity.this);
        }

        public boolean func_75250_a() {
            if (EnchanterEntity.this.func_70638_az() == null) {
                return false;
            }
            if (EnchanterEntity.this.func_193082_dl()) {
                return false;
            }
            if (EnchanterEntity.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (EnchanterEntity.this.enchantmentTargets.size() > 1) {
                return false;
            }
            List list = AreaOfEffectHelper.getNearbyEnemies((Entity)EnchanterEntity.this, (float)16.0f, (World)EnchanterEntity.this.field_70170_p, livingEntity -> {
                if (livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).isPresent()) {
                    MobEnchantCapability mobEnchantCapability = (MobEnchantCapability)livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).resolve().get();
                    return !mobEnchantCapability.hasEnchant() && livingEntity instanceof MonsterEntity;
                }
                return false;
            });
            if (list.isEmpty()) {
                return false;
            }
            EnchanterEntity.this.setEnchantmentTarget((MonsterEntity)list.get(EnchanterEntity.this.field_70146_Z.nextInt(list.size())));
            EnchanterEntity.this.setEnchantTicks(45);
            return true;
        }

        public boolean func_75253_b() {
            return EnchanterEntity.this.getEnchantmentTarget() != null && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EnchanterEntity.this.setEnchantmentTarget(null);
        }

        protected void func_190868_j() {
            MonsterEntity selectedMonsterEntity = EnchanterEntity.this.getEnchantmentTarget();
            if (selectedMonsterEntity != null && selectedMonsterEntity.func_70089_S()) {
                selectedMonsterEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                    cap.addMobEnchant((LivingEntity)selectedMonsterEntity, MobEnchants.STRONG, 2);
                    cap.addMobEnchant((LivingEntity)selectedMonsterEntity, MobEnchants.PROTECTION, 2);
                    selectedMonsterEntity.func_213323_x_();
                });
                EnchanterEntity.this.addEnchantmentTarget(selectedMonsterEntity);
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 45;
        }

        protected int func_190872_i() {
            return 140;
        }

        protected SoundEvent func_190871_k() {
            return (SoundEvent)ModSoundEvents.ENCHANTER_SPELL.get();
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.NONE;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)EnchanterEntity.this);
        }

        public void func_75246_d() {
            if (EnchanterEntity.this.getEnchantmentTarget() != null) {
                EnchanterEntity.this.func_70671_ap().func_75651_a((Entity)EnchanterEntity.this.getEnchantmentTarget(), (float)EnchanterEntity.this.func_184649_cE(), (float)EnchanterEntity.this.func_70646_bf());
            }
        }
    }
}

