/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorSet;
import com.infamous.dungeons_mobs.entities.SpawnArmoredHelper;
import com.infamous.dungeons_mobs.entities.illagers.IllagerArmsUtil;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.entities.summonables.SummonSpotEntity;
import com.infamous.dungeons_mobs.goals.ApproachTargetGoal;
import com.infamous.dungeons_mobs.goals.LookAtTargetGoal;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.ModProjectileHelper;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DungeonsIllusionerEntity
extends AbstractIllagerEntity
implements IAnimatable,
SpawnArmoredMob {
    public int shootAnimationTick;
    public int shootAnimationLength = 35;
    public int shootAnimationActionPoint = 15;
    public int blindAnimationTick;
    public int blindAnimationLength = 30;
    public int blindAnimationActionPoint = 18;
    public int vanishAnimationTick;
    public int vanishAnimationLength = 20;
    public int appearAnimationTick;
    public int appearAnimationLength = 20;
    public int appearDelay = 0;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public DungeonsIllusionerEntity(World world) {
        super((EntityType)ModEntityTypes.ILLUSIONER.get(), world);
    }

    public DungeonsIllusionerEntity(EntityType<? extends DungeonsIllusionerEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RemainStationaryGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new CreateIllusionsGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BlindAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ShootAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ApproachTargetGoal((CreatureEntity)this, 7.5, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false).func_190882_b(600));
    }

    public boolean shouldBeStationary() {
        return this.appearAnimationTick > 0 || this.appearDelay > 0;
    }

    public boolean func_184638_cS() {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233818_a_, 50.0);
    }

    public void func_70103_a(byte p_28844_) {
        if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 11) {
            this.blindAnimationTick = this.blindAnimationLength;
        } else if (p_28844_ == 9) {
            this.vanishAnimationTick = this.vanishAnimationLength;
        } else if (p_28844_ == 8) {
            this.appearAnimationTick = this.appearAnimationLength;
        } else if (p_28844_ == 6) {
            this.appearDelay = 11;
        } else if (p_28844_ == 7) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(p_28844_);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tickDownAnimTimers();
        if (this.appearDelay > 0) {
            --this.appearDelay;
        }
        if (!this.field_70170_p.field_72995_K && this.appearDelay == 1) {
            this.appearAnimationTick = this.appearAnimationLength;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void tickDownAnimTimers() {
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.blindAnimationTick > 0) {
            --this.blindAnimationTick;
        }
        if (this.vanishAnimationTick > 0) {
            --this.vanishAnimationTick;
        }
        if (this.appearAnimationTick > 0) {
            --this.appearAnimationTick;
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        String suffix = "_uncrossed";
        if (IllagerArmsUtil.armorHasCrossedArms(this, this.func_184582_a(EquipmentSlotType.CHEST))) {
            suffix = "";
        }
        if (this.appearAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_appear" + suffix, Boolean.valueOf(true)));
        } else if (this.vanishAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_vanish" + suffix, Boolean.valueOf(true)));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_shoot" + suffix, Boolean.valueOf(true)));
        } else if (this.blindAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_blind" + suffix, Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_walk" + suffix, Boolean.valueOf(true)));
        } else if (this.func_213656_en()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("illusioner_idle" + suffix, Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        SpawnArmoredHelper.equipArmorSet(ModItems.ILLUSIONER_ARMOR, (MobEntity)this);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item SHORTBOW = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "shortbow"));
            ItemStack shortbow = new ItemStack((IItemProvider)SHORTBOW);
            this.func_184201_a(EquipmentSlotType.MAINHAND, shortbow);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData iLivingEntityData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.func_180481_a(p_213386_2_);
        this.func_180483_b(p_213386_2_);
        return iLivingEntityData;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.ILLUSIONER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_193787_df;
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (p_70097_1_.func_76346_g() != null && this.func_184191_r(p_70097_1_.func_76346_g()) && p_70097_1_ != DamageSource.field_76380_i) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public void shootRocket(LivingEntity target) {
        int explosionsByDifficulty = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_203095_a().func_151525_a();
        ItemStack fireworkRocket = ModProjectileHelper.createRocket(explosionsByDifficulty * 2, DyeColor.PINK, DyeColor.PURPLE);
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, fireworkRocket, (Entity)this, this.func_226277_ct_(), this.func_226280_cw_() - (double)0.15f, this.func_226281_cx_(), true);
        double xDifference = target.func_226277_ct_() - this.func_226277_ct_();
        double yDifference = target.func_226283_e_(0.3333333333333333) - fireworkrocketentity.func_226278_cu_();
        double zDifference = target.func_226281_cx_() - this.func_226281_cx_();
        fireworkrocketentity.func_70186_c(xDifference, yDifference, zDifference, 1.0f, (float)(18.0 - (double)this.field_70170_p.func_175659_aa().func_151525_a() * 7.5));
        this.func_184185_a(SoundEvents.field_187634_bp, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
    }

    private void spawnBlindingCloud(BlockPos pos) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        areaeffectcloudentity.func_184496_a(new EffectInstance(Effects.field_76440_q, 100));
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public ArmorSet getArmorSet() {
        return ModItems.ILLUSIONER_ARMOR;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return DungeonsIllusionerEntity.this.shouldBeStationary();
        }
    }

    class CreateIllusionsGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        private final Predicate<Entity> ILLUSIONER_CLONE = p_33346_ -> p_33346_ instanceof IllusionerCloneEntity && ((IllusionerCloneEntity)((Object)p_33346_)).getOwner() != null && ((IllusionerCloneEntity)((Object)p_33346_)).getOwner() == this.mob;

        public CreateIllusionsGoal(DungeonsIllusionerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            int nearbyClones = this.mob.field_70170_p.func_175674_a((Entity)this.mob, this.mob.func_174813_aQ().func_186662_g(30.0), this.ILLUSIONER_CLONE).size();
            return this.target != null && this.mob.field_70173_aa >= this.nextUseTime && this.mob.field_70146_Z.nextInt(10) == 0 && this.mob.func_70685_l((Entity)this.target) && nearbyClones <= 0 && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a(SoundEvents.field_193790_di, 1.0f, 1.0f);
            this.mob.vanishAnimationTick = this.mob.vanishAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)9);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.vanishAnimationTick == 1) {
                SummonSpotEntity summonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                summonSpot.func_174828_a(this.target.func_233580_cy_().func_177963_a(-12.5 + (double)this.mob.field_70146_Z.nextInt(25), 0.0, -12.5 + (double)this.mob.field_70146_Z.nextInt(25)), 0.0f, 0.0f);
                ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)summonSpot);
                PositionUtils.moveToCorrectHeight(summonSpot);
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)7);
                this.mob.func_174828_a(summonSpot.func_233580_cy_(), 0.0f, 0.0f);
                this.mob.func_181013_g(this.mob.field_70146_Z.nextInt(360));
                this.mob.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_()));
                this.mob.appearDelay = 11;
                this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)6);
                this.mob.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
                PositionUtils.moveToCorrectHeight((Entity)this.mob);
                if (this.target instanceof MobEntity) {
                    ((MobEntity)this.target).func_70624_b(null);
                    ((MobEntity)this.target).func_70604_c(null);
                    if (this.target instanceof IAngerable) {
                        ((IAngerable)this.target).func_241356_K__();
                        ((IAngerable)this.target).func_70604_c(null);
                        ((IAngerable)this.target).func_70624_b(null);
                        ((IAngerable)this.target).func_230259_a_(null);
                    }
                }
                int clonesByDifficulty = this.mob.field_70170_p.func_175649_E(this.mob.func_233580_cy_()).func_203095_a().func_151525_a();
                for (int i = 0; i < clonesByDifficulty * 4; ++i) {
                    SummonSpotEntity cloneSummonSpot = (SummonSpotEntity)((EntityType)ModEntityTypes.SUMMON_SPOT.get()).func_200721_a(this.mob.field_70170_p);
                    cloneSummonSpot.func_174828_a(this.target.func_233580_cy_().func_177963_a(-12.5 + (double)this.mob.field_70146_Z.nextInt(25), 0.0, -12.5 + (double)this.mob.field_70146_Z.nextInt(25)), 0.0f, 0.0f);
                    cloneSummonSpot.mobSpawnRotation = this.mob.field_70146_Z.nextInt(360);
                    ((ServerWorld)this.mob.field_70170_p).func_242417_l((Entity)cloneSummonSpot);
                    PositionUtils.moveToCorrectHeight(cloneSummonSpot);
                    IllusionerCloneEntity clone = (IllusionerCloneEntity)((EntityType)ModEntityTypes.ILLUSIONER_CLONE.get()).func_200721_a(this.mob.field_70170_p);
                    clone.func_213386_a((IServerWorld)((ServerWorld)this.mob.field_70170_p), this.mob.field_70170_p.func_175649_E(cloneSummonSpot.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                    clone.setOwner((MobEntity)this.mob);
                    clone.func_70606_j(this.mob.func_110143_aJ());
                    for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                        ItemStack itemstack = this.mob.func_184582_a(equipmentslottype);
                        if (itemstack.func_190926_b()) continue;
                        clone.func_184201_a(equipmentslottype, itemstack.func_77946_l());
                        clone.func_184642_a(equipmentslottype, 0.0f);
                    }
                    clone.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d(this.mob.func_226277_ct_(), this.mob.func_226280_cw_(), this.mob.func_226281_cx_()));
                    clone.setDelayedAppear(true);
                    cloneSummonSpot.summonedEntity = clone;
                    cloneSummonSpot.func_184185_a(SoundEvents.field_193788_dg, 1.0f, 1.0f);
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.nextUseTime = this.mob.field_70173_aa + 50 + this.mob.field_70146_Z.nextInt(50);
        }

        public boolean animationsUseable() {
            return this.mob.vanishAnimationTick <= 0;
        }
    }

    class BlindAttackGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int cooldown;

        public BlindAttackGoal(DungeonsIllusionerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.target != null && this.mob.field_70146_Z.nextInt(30) == 0 && this.mob.func_70032_d((Entity)this.target) <= 10.0f && this.cooldown <= 0 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.func_184185_a(SoundEvents.field_193789_dh, 1.0f, 1.0f);
            this.mob.blindAnimationTick = this.mob.blindAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)11);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.blindAnimationTick == this.mob.blindAnimationActionPoint) {
                this.mob.func_184185_a(SoundEvents.field_193784_dd, 1.0f, 1.0f);
                this.mob.spawnBlindingCloud(this.target.func_233580_cy_());
                if (this.target instanceof MobEntity) {
                    ((MobEntity)this.target).func_70624_b(null);
                    ((MobEntity)this.target).func_70604_c(null);
                    if (this.target instanceof IAngerable) {
                        ((IAngerable)this.target).func_241356_K__();
                        ((IAngerable)this.target).func_70604_c(null);
                        ((IAngerable)this.target).func_70624_b(null);
                        ((IAngerable)this.target).func_230259_a_(null);
                    }
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.cooldown = 200 + this.mob.field_70146_Z.nextInt(100);
        }

        public boolean animationsUseable() {
            return this.mob.blindAnimationTick <= 0;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public DungeonsIllusionerEntity mob;
        @Nullable
        public LivingEntity target;
        public int cooldown;

        public ShootAttackGoal(DungeonsIllusionerEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.func_70638_az();
        }

        public boolean func_220685_C_() {
            return this.mob.shouldBeStationary();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean func_75250_a() {
            this.target = this.mob.func_70638_az();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.target != null && (double)this.mob.func_70032_d((Entity)this.target) <= 12.5 && this.cooldown <= 0 && this.mob.func_70685_l((Entity)this.target) && this.animationsUseable();
        }

        public boolean func_75253_b() {
            return this.target != null && !this.animationsUseable();
        }

        public void func_75249_e() {
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.field_70170_p.func_72960_a((Entity)this.mob, (byte)4);
        }

        public void func_75246_d() {
            this.target = this.mob.func_70638_az();
            this.mob.func_70661_as().func_75499_g();
            if (this.target != null) {
                this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                this.mob.shootRocket(this.target);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.cooldown = 60 + this.mob.field_70146_Z.nextInt(40);
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }
}

