/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.golem;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SquallGolemEntity
extends AbstractRaiderEntity
implements IAnimatable {
    private int attackTimer;
    private int attackID;
    public int cd;
    public static final byte STOMP_ATTACK = 1;
    public static final byte GOLEM_ACTIVATE = 2;
    public static final byte GOLEM_DEACTIVATE = 3;
    private int timeWithoutTarget;
    private static final DataParameter<Boolean> ACTIVATE = EntityDataManager.func_187226_a(SquallGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MELEEATTACKING = EntityDataManager.func_187226_a(SquallGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SquallGolemEntity(World world) {
        super((EntityType)ModEntityTypes.SQUALL_GOLEM.get(), world);
    }

    public SquallGolemEntity(EntityType<? extends AbstractRaiderEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 20;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 90.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233815_a_(Attributes.field_233824_g_, 1.25);
    }

    public boolean func_70104_M() {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        Vector3d velocity = this.func_213322_ci();
        float groundSpeed = MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
        if (this.attackID == 2) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.activate", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.attackID == 3) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.deactivate", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (!this.getActivate()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.deactivated", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isMeleeAttacking() && this.func_70089_S()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)(groundSpeed * 25.0f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimationSpeed(1.0);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squall_golem.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new Deactivate());
        this.field_70714_bg.func_75776_a(0, (Goal)new Activate());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACTIVATE, (Object)false);
        this.field_70180_af.func_187214_a(MELEEATTACKING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("activate", this.getActivate());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setActivate(compound.func_74767_n("activate"));
    }

    public void setActivate(boolean isActivate) {
        this.field_70180_af.func_187227_b(ACTIVATE, (Object)isActivate);
    }

    public boolean getActivate() {
        return (Boolean)this.field_70180_af.func_187225_a(ACTIVATE);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(MELEEATTACKING);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(MELEEATTACKING, (Object)attacking);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackID != 0) {
            ++this.attackTimer;
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 2.5, this.func_213322_ci().field_72449_c);
        this.handleLeafCollision();
        this.handleSteppingOnBlocks();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackID == 1 && this.attackTimer == 30) {
            this.Attackparticle(40, 0.5f, 2.6f, 0.5f);
            this.Attackparticle(40, 0.5f, 2.4f, -1.0f);
        }
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.field_72995_K) {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (!this.getActivate()) {
                    this.setActivate(true);
                    this.attackID = 2;
                }
            }
            if (this.func_213663_ek() != null && this.func_213663_ek().func_221333_v()) {
                this.timeWithoutTarget = 0;
                if (!this.getActivate()) {
                    this.setActivate(true);
                    this.attackID = 2;
                }
            }
            if (this.timeWithoutTarget > 200 && this.getActivate() && target == null) {
                this.timeWithoutTarget = 0;
                this.setActivate(false);
                this.attackID = 3;
            }
        }
        if (this.cd > 0) {
            --this.cd;
        }
    }

    private void Attackparticle(int paticle, float circle, float vec, float math) {
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < paticle; ++i1) {
                double DeltaMovementX = this.func_70681_au().nextGaussian() * 0.07;
                double DeltaMovementY = this.func_70681_au().nextGaussian() * 0.07;
                double DeltaMovementZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                double extraX = circle * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = circle * MathHelper.func_76134_b((float)angle);
                double theta = (double)this.field_70761_aq * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)vec * vecX + extraX));
                int hitY = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int hitZ = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.field_70170_p.func_180495_p(hit.func_177977_b());
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, block), this.func_226277_ct_() + (double)vec * vecX + extraX + (double)(f * math), this.func_226278_cu_() + extraY, this.func_226281_cx_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private void handleSteppingOnBlocks() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (SquallGolemEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    private void handleLeafCollision() {
        if (this.func_70089_S() && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean destroyedLeafBlock = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block instanceof LeavesBlock)) continue;
                destroyedLeafBlock = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || destroyedLeafBlock;
            }
            if (!destroyedLeafBlock && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    protected int func_70682_h(int air) {
        return air;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (((Boolean)this.field_70180_af.func_187225_a(ACTIVATE)).booleanValue() && this.field_70708_bq > 5) {
            return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_IDLE.get();
        }
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = false;
        if (!this.getActivate() && source != DamageSource.field_76380_i) {
            this.func_184185_a(SoundEvents.field_187928_hb, 1.0f, 0.4f);
            if (source.func_76346_g() instanceof LivingEntity && source.func_76346_g().func_190530_aW()) {
                this.func_70624_b((LivingEntity)source.func_76346_g());
            }
            flag = false;
        } else {
            flag = super.func_70097_a(source, amount);
        }
        return flag;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        BlockPos golemPos = this.func_233580_cy_();
        BlockPos posBeneathGolem = golemPos.func_177977_b();
        BlockState blockstateBeneathGolem = worldIn.func_180495_p(posBeneathGolem);
        if (!blockstateBeneathGolem.func_235719_a_((IBlockReader)worldIn, posBeneathGolem, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstateAboveGolem;
            BlockPos posAboveGolem = golemPos.func_177981_b(i);
            if (WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)posAboveGolem, (BlockState)(blockstateAboveGolem = worldIn.func_180495_p(posAboveGolem)), (FluidState)blockstateAboveGolem.func_204520_s(), (EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get()))) continue;
            return false;
        }
        return WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)golemPos, (BlockState)worldIn.func_180495_p(golemPos), (FluidState)Fluids.field_204541_a.func_207188_f(), (EntityType)((EntityType)ModEntityTypes.SQUALL_GOLEM.get())) && worldIn.func_226668_i_((Entity)this);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTimer = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)(-id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTimer = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.875f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)ModSoundEvents.SQUALL_GOLEM_WALK.get(), 1.12f, 1.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_HURT.get();
    }

    protected float func_70599_aP() {
        return 2.5f;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_DEATH.get();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)this, worldIn);
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)ModSoundEvents.SQUALL_GOLEM_IDLE.get();
    }

    public boolean func_213637_dY() {
        return false;
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return SquallGolemEntity.this.attackID == 1 && SquallGolemEntity.this.cd <= 0;
        }

        public boolean func_75253_b() {
            return SquallGolemEntity.this.attackTimer < 34;
        }

        public void func_75249_e() {
            if (SquallGolemEntity.this.func_70638_az() != null) {
                SquallGolemEntity.this.func_70671_ap().func_75651_a((Entity)SquallGolemEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            SquallGolemEntity.this.setMeleeAttacking(true);
            SquallGolemEntity.this.setAttackID(1);
        }

        public void func_75246_d() {
            SquallGolemEntity.this.func_213293_j(0.0, SquallGolemEntity.this.func_213322_ci().field_72448_b, 0.0);
            LivingEntity target = SquallGolemEntity.this.func_70638_az();
            if (SquallGolemEntity.this.attackTimer < 15 && target != null) {
                SquallGolemEntity.this.func_70625_a((Entity)target, 15.0f, 15.0f);
            } else {
                SquallGolemEntity.this.field_70177_z = SquallGolemEntity.this.field_70126_B;
            }
            if (SquallGolemEntity.this.attackTimer == 12) {
                SquallGolemEntity.this.func_184185_a((SoundEvent)ModSoundEvents.SQUALL_GOLEM_ATTACK.get(), 2.0f, 1.0f);
            }
            if (SquallGolemEntity.this.attackTimer == 30) {
                this.AreaAttack(5.0f, 5.0f, 5.0f, 5.0f, 60.0f, 1.0f);
            }
        }

        private void AreaAttack(float range, float X, float Y, float Z, float arc, float damage) {
            for (LivingEntity entityHit : SquallGolemEntity.this.field_70170_p.func_217357_a(LivingEntity.class, SquallGolemEntity.this.func_174813_aQ().func_72314_b((double)X, (double)Y, (double)Z))) {
                float entityHitAngle = (float)((Math.atan2(entityHit.func_226281_cx_() - SquallGolemEntity.this.func_226281_cx_(), entityHit.func_226277_ct_() - SquallGolemEntity.this.func_226277_ct_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = SquallGolemEntity.this.field_70761_aq % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.func_226281_cx_() - SquallGolemEntity.this.func_226281_cx_()) * (entityHit.func_226281_cx_() - SquallGolemEntity.this.func_226281_cx_()) + (entityHit.func_226277_ct_() - SquallGolemEntity.this.func_226277_ct_()) * (entityHit.func_226277_ct_() - SquallGolemEntity.this.func_226277_ct_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || SquallGolemEntity.this.func_184191_r((Entity)entityHit) || entityHit == SquallGolemEntity.this) continue;
                entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)SquallGolemEntity.this), (float)SquallGolemEntity.this.func_233637_b_(Attributes.field_233823_f_) * damage);
                SquallGolemEntity v = SquallGolemEntity.this;
                float attackKnockback = (float)SquallGolemEntity.this.func_233637_b_(Attributes.field_233824_g_);
                double ratioX = MathHelper.func_76126_a((float)(v.field_70177_z * ((float)Math.PI / 180)));
                double ratioZ = -MathHelper.func_76134_b((float)(v.field_70177_z * ((float)Math.PI / 180)));
                double knockbackReduction = 0.35;
                entityHit.func_70097_a(DamageSource.func_76358_a((LivingEntity)v), damage);
                this.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, knockbackReduction);
                entityHit.func_213317_d(entityHit.func_213322_ci().func_72441_c(0.0, 0.3333333, 0.0));
            }
        }

        public void func_75251_c() {
            SquallGolemEntity.this.setMeleeAttacking(false);
            SquallGolemEntity.this.setAttackID(0);
            SquallGolemEntity.this.cd = 25;
        }

        private void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
            if (event.isCanceled()) {
                return;
            }
            strength = event.getStrength();
            ratioX = event.getRatioX();
            ratioZ = event.getRatioZ();
            if (!((strength = (float)((double)strength * (1.0 - attackTarget.func_233637_b_(Attributes.field_233820_c_) * knockbackResistanceReduction))) <= 0.0f)) {
                attackTarget.field_70160_al = true;
                Vector3d vector3d = attackTarget.func_213322_ci();
                Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)strength);
                attackTarget.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, attackTarget.func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)strength) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
            }
        }
    }

    class Deactivate
    extends Goal {
        public Deactivate() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SquallGolemEntity.this.attackID == 3;
        }

        public boolean func_75253_b() {
            return SquallGolemEntity.this.attackTimer < 80;
        }

        public void func_75249_e() {
            SquallGolemEntity.this.setAttackID(3);
            SquallGolemEntity.this.func_184185_a((SoundEvent)ModSoundEvents.SQUALL_GOLEM_OFF.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            SquallGolemEntity.this.func_213293_j(0.0, SquallGolemEntity.this.func_213322_ci().field_72448_b, 0.0);
        }

        public void func_75251_c() {
            SquallGolemEntity.this.setAttackID(0);
        }
    }

    class Activate
    extends Goal {
        public Activate() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SquallGolemEntity.this.attackID == 2;
        }

        public boolean func_75253_b() {
            return SquallGolemEntity.this.attackTimer < 60;
        }

        public void func_75249_e() {
            SquallGolemEntity.this.setAttackID(2);
            SquallGolemEntity.this.func_184185_a((SoundEvent)ModSoundEvents.SQUALL_GOLEM_OPEN.get(), 1.0f, 1.0f);
        }

        public void func_75246_d() {
            SquallGolemEntity.this.func_213293_j(0.0, SquallGolemEntity.this.func_213322_ci().field_72448_b, 0.0);
        }

        public void func_75251_c() {
            SquallGolemEntity.this.setAttackID(0);
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !SquallGolemEntity.this.getActivate();
        }

        public void func_75246_d() {
            SquallGolemEntity.this.func_213293_j(0.0, SquallGolemEntity.this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)SquallGolemEntity.this, 1.25, false);
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            float f = SquallGolemEntity.this.func_213311_cf() - 0.1f;
            return f * 1.8f * f * 1.8f + p_179512_1_.func_213311_cf();
        }
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        protected PathNodeType func_215744_a(IBlockReader blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, PathNodeType pathNodeType) {
            return pathNodeType == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity mobEntity, World world) {
            super(mobEntity, world);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }
    }
}

