/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import com.infamous.dungeons_mobs.entities.ender.AbstractEnderlingEntity;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EndersentEntity
extends AbstractEnderlingEntity
implements IAnimatable {
    private final ServerBossInfo bossEvent = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186743_c(true).func_186742_b(true);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final DataParameter<Integer> TELEPORTING = EntityDataManager.func_187226_a(EndersentEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EndersentEntity(EntityType<? extends EndersentEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractEnderlingEntity.class}).func_220794_a(new Class[0]).func_190882_b(500));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(500));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEnderlingEntity.FindPlayerGoal(this, null));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORTING, (Object)0);
    }

    public int isTeleporting() {
        return (Integer)this.field_70180_af.func_187225_a(TELEPORTING);
    }

    public void setTeleporting(int p_189794_1_) {
        if (p_189794_1_ == 15) {
            if (this.func_70638_az() != null) {
                this.func_70107_b(this.func_70638_az().func_226277_ct_() - 5.0 + (double)this.field_70146_Z.nextInt(10), this.func_70638_az().func_226278_cu_(), this.func_70638_az().func_226281_cx_() - 5.0 + (double)this.field_70146_Z.nextInt(10));
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            } else {
                this.func_70107_b(this.func_226277_ct_() - 20.0 + (double)this.field_70146_Z.nextInt(40), this.func_226278_cu_(), this.func_226281_cx_() - 20.0 + (double)this.field_70146_Z.nextInt(40));
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(TELEPORTING, (Object)p_189794_1_);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 100) {
            this.func_70106_y();
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (this.func_145818_k_()) {
            this.bossEvent.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent p_200203_1_) {
        super.func_200203_b(p_200203_1_);
        this.bossEvent.func_186739_a(this.func_145748_c_());
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233820_c_, 0.85).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 14.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_IDLE.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.ENDERSENT_HURT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_DEATH.get();
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.func_184185_a((SoundEvent)ModSoundEvents.ENDERSENT_ATTACK.get(), 1.0f, 1.0f);
        return super.func_70652_k(p_70652_1_);
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 1.25f, 1.0f);
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.ENDERSENT_STEP.get();
    }

    @Override
    public void func_70624_b(LivingEntity p_70624_1_) {
        super.func_70624_b(p_70624_1_);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.isTeleporting() > 0) {
            this.setTeleporting(this.isTeleporting() - 1);
        }
        if (this.field_70146_Z.nextInt(500) == 0 && this.func_70638_az() == null) {
            this.setTeleporting(50);
        } else if (this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az() != null) {
            this.setTeleporting(50);
        }
        if (this.isTeleporting() > 0) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
        }
        this.bossEvent.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity p_184178_1_) {
        super.func_184178_b(p_184178_1_);
        this.bossEvent.func_186760_a(p_184178_1_);
    }

    public void func_184203_c(ServerPlayerEntity p_184203_1_) {
        super.func_184203_c(p_184203_1_);
        this.bossEvent.func_186761_b(p_184203_1_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_death", Boolean.valueOf(false)));
        } else if (this.isTeleporting() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_teleport", Boolean.valueOf(false)));
        } else if (this.isAttacking() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("endersent_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected boolean teleport() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(8) - 4);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.teleport(d1, d2, d3);
    }

    @Override
    protected boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, (SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a((SoundEvent)ModSoundEvents.ENDERSENT_TELEPORT.get(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final EntityPredicate slimePredicate;

        public AttackGoal(double speed) {
            super((CreatureEntity)EndersentEntity.this, speed, true);
            this.slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 5.0f * this.field_75441_b.func_213311_cf() * 5.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
            EndersentEntity.this.setRunning(10);
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    EndersentEntity.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

