/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import com.infamous.dungeons_mobs.entities.ender.AbstractEnderlingEntity;
import com.infamous.dungeons_mobs.entities.projectiles.BlastlingBulletEntity;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BlastlingEntity
extends AbstractEnderlingEntity
implements IAnimatable,
IRangedAttackMob {
    public static final DataParameter<Integer> SHOOT_TIME = EntityDataManager.func_187226_a(BlastlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public float flameTicks;

    public BlastlingEntity(EntityType<? extends BlastlingEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.15, 20, 10.0f));
        this.field_70714_bg.func_75776_a(0, new AvoidEntityGoal((CreatureEntity)this, 5.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEnderlingEntity.FindPlayerGoal(this, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractEnderlingEntity.class}).func_220794_a(new Class[0]).func_190882_b(500));
        this.field_70715_bh.func_75776_a(1, (Goal)new AbstractEnderlingEntity.EnderlingTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true).func_190882_b(500));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.225f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.BLASTLING_IDLE.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSoundEvents.BLASTLING_HURT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.BLASTLING_DEATH.get();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 0.75f, 1.0f);
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSoundEvents.BLASTLING_STEP.get();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.flameTicks += 0.25f;
        if (this.func_70638_az() != null && this.getShootTime() <= 2) {
            this.setShootTime(15);
        }
        if (this.getShootTime() > 0) {
            this.setShootTime(this.getShootTime() - 1);
        }
        if (!this.field_70170_p.field_72995_K && (this.getShootTime() == 2 || this.getShootTime() == 8) && this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            this.shoot(this.getShootTime() == 2, this.func_70638_az());
        }
    }

    private void shoot(boolean leftArm, LivingEntity p_82216_2_) {
        this.readyShoot(leftArm, p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_());
        this.func_184185_a((SoundEvent)ModSoundEvents.BLASTLING_SHOOT.get(), 2.0f, this.func_70647_i());
    }

    private void readyShoot(boolean p_82209_1_, double p_82209_2_, double p_82209_4_, double p_82209_6_) {
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = p_82209_2_ - d0;
        double d4 = p_82209_4_ - d1;
        double d5 = p_82209_6_ - d2;
        BlastlingBulletEntity witherskullentity = new BlastlingBulletEntity(this.field_70170_p, (LivingEntity)this, d3, d4, d5);
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    private double getHeadX(boolean p_82214_1_) {
        float f = (this.field_70761_aq + (float)(180.0 * (p_82214_1_ ? 0.0 : 0.75))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.func_226277_ct_() + (double)f1 * 1.3;
    }

    private double getHeadY(boolean p_82208_1_) {
        return this.func_226278_cu_() + 1.75;
    }

    private double getHeadZ(boolean p_82213_1_) {
        float f = (this.field_70761_aq + (float)(180.0 * (p_82213_1_ ? 0.0 : 0.75))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.func_226281_cx_() + (double)f1 * 1.3;
    }

    public void func_82196_d(LivingEntity p_82196_1_, float p_82196_2_) {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOT_TIME, (Object)0);
    }

    public int getShootTime() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOT_TIME);
    }

    public void setShootTime(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SHOOT_TIME, (Object)p_189794_1_);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.getShootTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("blastling_shoot", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("blastling_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("blastling_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class AvoidEntityGoal<T extends LivingEntity>
    extends Goal {
        protected final CreatureEntity mob;
        private final double walkSpeedModifier;
        private final double sprintSpeedModifier;
        protected LivingEntity toAvoid;
        protected final float maxDist;
        protected Path path;
        protected final PathNavigator pathNav;
        protected final Predicate<LivingEntity> avoidPredicate;
        protected final Predicate<LivingEntity> predicateOnAvoidEntity;
        private final EntityPredicate avoidEntityTargeting;

        public AvoidEntityGoal(CreatureEntity p_i46404_1_, float p_i46404_3_, double p_i46404_4_, double p_i46404_6_) {
            this(p_i46404_1_, p_200828_0_ -> true, p_i46404_3_, p_i46404_4_, p_i46404_6_, EntityPredicates.field_188444_d::test);
        }

        public AvoidEntityGoal(CreatureEntity p_i48859_1_, Predicate<LivingEntity> p_i48859_3_, float p_i48859_4_, double p_i48859_5_, double p_i48859_7_, Predicate<LivingEntity> p_i48859_9_) {
            this.mob = p_i48859_1_;
            this.avoidPredicate = p_i48859_3_;
            this.maxDist = p_i48859_4_;
            this.walkSpeedModifier = p_i48859_5_;
            this.sprintSpeedModifier = p_i48859_7_;
            this.predicateOnAvoidEntity = p_i48859_9_;
            this.pathNav = p_i48859_1_.func_70661_as();
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.avoidEntityTargeting = new EntityPredicate().func_221013_a((double)p_i48859_4_).func_221012_a(p_i48859_9_.and(p_i48859_3_));
        }

        public AvoidEntityGoal(CreatureEntity p_i48860_1_, float p_i48860_3_, double p_i48860_4_, double p_i48860_6_, Predicate<LivingEntity> p_i48860_8_) {
            this(p_i48860_1_, p_203782_0_ -> true, p_i48860_3_, p_i48860_4_, p_i48860_6_, p_i48860_8_);
        }

        public boolean func_75250_a() {
            this.toAvoid = BlastlingEntity.this.func_70638_az();
            if (this.toAvoid == null || this.mob.func_70032_d((Entity)this.toAvoid) > this.maxDist) {
                return false;
            }
            Vector3d vector3d = RandomPositionGenerator.func_75461_b((CreatureEntity)this.mob, (int)16, (int)7, (Vector3d)this.toAvoid.func_213303_ch());
            if (vector3d == null) {
                return false;
            }
            if (this.toAvoid.func_70092_e(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c) < this.toAvoid.func_70068_e((Entity)this.mob)) {
                return false;
            }
            this.path = this.pathNav.func_225466_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0);
            return BlastlingEntity.this.func_70638_az() != null && BlastlingEntity.this.func_70638_az().func_70089_S() && this.path != null;
        }

        public boolean func_75253_b() {
            return BlastlingEntity.this.func_70638_az() != null && BlastlingEntity.this.func_70638_az().func_70089_S() && !this.pathNav.func_75500_f();
        }

        public void func_75249_e() {
            this.pathNav.func_75484_a(this.path, this.walkSpeedModifier);
        }

        public void func_75251_c() {
            this.toAvoid = null;
        }

        public void func_75246_d() {
            BlastlingEntity.this.setShootTime(0);
            if (this.mob.func_70068_e((Entity)this.toAvoid) < 49.0) {
                this.mob.func_70661_as().func_75489_a(this.sprintSpeedModifier);
            } else {
                this.mob.func_70661_as().func_75489_a(this.walkSpeedModifier);
            }
        }
    }
}

