/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.ender;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;

public abstract class AbstractEnderlingEntity
extends MonsterEntity
implements IAnimatable {
    public static final DataParameter<Integer> ATTACKING = EntityDataManager.func_187226_a(AbstractEnderlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> RUNNING = EntityDataManager.func_187226_a(AbstractEnderlingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_STARED_AT = EntityDataManager.func_187226_a(AbstractEnderlingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final EntityPredicate followPredicate = new EntityPredicate().func_221013_a(50.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();

    protected AbstractEnderlingEntity(EntityType<? extends AbstractEnderlingEntity> p_i48553_1_, World p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    public void func_70624_b(@Nullable LivingEntity p_70624_1_) {
        if (p_70624_1_ == null) {
            this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)false);
        }
        super.func_70624_b(p_70624_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)0);
        this.field_70180_af.func_187214_a(RUNNING, (Object)0);
        this.field_70180_af.func_187214_a(DATA_STARED_AT, (Object)false);
    }

    public boolean hasBeenStaredAt() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_STARED_AT);
    }

    public void setBeingStaredAt() {
        this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)true);
    }

    private boolean isLookingAtMe(PlayerEntity p_70821_1_) {
        ItemStack itemstack = (ItemStack)p_70821_1_.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vector3d vector3d = p_70821_1_.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() - p_70821_1_.func_226277_ct_(), this.func_226280_cw_() - p_70821_1_.func_226280_cw_(), this.func_226281_cx_() - p_70821_1_.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? p_70821_1_.func_70685_l((Entity)this) : false;
    }

    public boolean func_213380_a(IWorld p_213380_1_, SpawnReason p_213380_2_) {
        return p_213380_2_ == SpawnReason.NATURAL && this.field_70170_p.func_242406_i(this.func_233580_cy_()).get() == Biomes.field_76779_k ? false : MonsterEntity.func_223315_a((EntityType)this.func_200600_R(), (IWorld)p_213380_1_, (SpawnReason)p_213380_2_, (BlockPos)this.func_233580_cy_(), (Random)this.field_70146_Z);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isAttacking() > 0) {
            this.setAttacking(this.isAttacking() - 1);
        }
        if (this.isRunning() > 0) {
            this.setRunning(this.isRunning() - 1);
        }
    }

    public int isAttacking() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)p_189794_1_);
    }

    public int isRunning() {
        return (Integer)this.field_70180_af.func_187225_a(RUNNING);
    }

    public void setRunning(int p_189794_1_) {
        this.field_70180_af.func_187227_b(RUNNING, (Object)p_189794_1_);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public boolean func_230270_dK_() {
        return true;
    }

    protected void func_70619_bc() {
        float f;
        if (this.shouldTeleportInDay() && this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(600) == 0 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleport();
        }
        super.func_70619_bc();
    }

    public boolean shouldTeleportInDay() {
        return false;
    }

    protected boolean teleport() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.teleport(d1, d2, d3);
    }

    protected boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        boolean flag = super.func_70097_a(p_70097_1_, p_70097_2_);
        if (!this.field_70170_p.func_201670_d() && !(p_70097_1_.func_76346_g() instanceof LivingEntity) && this.field_70146_Z.nextInt(2) == 0) {
            this.teleport();
        }
        return flag;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final AbstractEnderlingEntity enderman;
        private PlayerEntity pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate startAggroTargetConditions;
        private final EntityPredicate continueAggroTargetConditions = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(AbstractEnderlingEntity p_i241912_1_, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((MobEntity)p_i241912_1_, PlayerEntity.class, 10, false, false, p_i241912_2_);
            this.enderman = p_i241912_1_;
            this.startAggroTargetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i241912_1_.isLookingAtMe((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.pendingTarget = this.enderman.field_70170_p.func_217370_a(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.pendingTarget != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.setBeingStaredAt();
        }

        public void func_75251_c() {
            this.pendingTarget = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.pendingTarget != null) {
                if (!this.enderman.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.continueAggroTargetConditions.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.enderman.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.pendingTarget;
                    this.pendingTarget = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.isLookingAtMe((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportTowards((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }

    public class EnderlingTargetGoal<T extends LivingEntity>
    extends TargetGoal {
        protected final Class<T> targetType;
        protected final int randomInterval;
        protected LivingEntity target;
        protected EntityPredicate targetConditions;

        public EnderlingTargetGoal(MobEntity p_i50313_1_, Class<T> p_i50313_2_, boolean p_i50313_3_) {
            this(p_i50313_1_, p_i50313_2_, p_i50313_3_, false);
        }

        public EnderlingTargetGoal(MobEntity p_i50314_1_, Class<T> p_i50314_2_, boolean p_i50314_3_, boolean p_i50314_4_) {
            this(p_i50314_1_, p_i50314_2_, 10, p_i50314_3_, p_i50314_4_, null);
        }

        public EnderlingTargetGoal(MobEntity p_i50315_1_, Class<T> p_i50315_2_, int p_i50315_3_, boolean p_i50315_4_, @Nullable boolean p_i50315_5_, Predicate<LivingEntity> p_i50315_6_) {
            super(p_i50315_1_, p_i50315_4_, p_i50315_5_);
            this.targetType = p_i50315_2_;
            this.randomInterval = p_i50315_3_;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
            this.targetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_i50315_6_);
        }

        public boolean func_75250_a() {
            if (this.randomInterval > 0 && this.field_75299_d.func_70681_au().nextInt(this.randomInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.target != null;
        }

        protected AxisAlignedBB getTargetSearchArea(double p_188511_1_) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(p_188511_1_, 4.0, p_188511_1_);
        }

        protected void findTarget() {
            this.target = this.targetType != PlayerEntity.class && this.targetType != ServerPlayerEntity.class ? this.field_75299_d.field_70170_p.func_225318_b(this.targetType, this.targetConditions, (LivingEntity)this.field_75299_d, this.field_75299_d.func_226277_ct_(), this.field_75299_d.func_226280_cw_(), this.field_75299_d.func_226281_cx_(), this.getTargetSearchArea(this.func_111175_f())) : this.field_75299_d.field_70170_p.func_217372_a(this.targetConditions, (LivingEntity)this.field_75299_d, this.field_75299_d.func_226277_ct_(), this.field_75299_d.func_226280_cw_(), this.field_75299_d.func_226281_cx_());
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.target);
            super.func_75249_e();
        }

        public void setTarget(@Nullable LivingEntity p_234054_1_) {
            this.target = p_234054_1_;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public final EntityPredicate slimePredicate;

        public AttackGoal(double speed) {
            super((CreatureEntity)AbstractEnderlingEntity.this, speed, true);
            this.slimePredicate = new EntityPredicate().func_221013_a(20.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 3.0f * this.field_75441_b.func_213311_cf() * 3.0f + p_179512_1_.func_213311_cf();
        }

        public void func_75246_d() {
            super.func_75246_d();
            AbstractEnderlingEntity.this.setRunning(10);
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30) {
                    AbstractEnderlingEntity.this.setAttacking(30);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

